using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class EngineDescription : ICloneable
    {
        #region 
        [Serializable]
        public struct TechnologyOverrides
        {
            public override string ToString()
            {
                return this.ToString(',');
            }
            public string ToString(char delimiter)
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("LUB="   + this.LUB);     sb.Append(delimiter);
                sb.Append("EFR="   + this.EFR);     sb.Append(delimiter);
                sb.Append("CCPS="  + this.CCPS);    sb.Append(delimiter);
                sb.Append("DVVLS=" + this.DVVLS);   sb.Append(delimiter);
                sb.Append("DEACS=" + this.DEACS);   sb.Append(delimiter);
                sb.Append("ICP="   + this.ICP);     sb.Append(delimiter);
                sb.Append("DCP="   + this.DCP);     sb.Append(delimiter);
                sb.Append("DVVLD=" + this.DVVLD);   sb.Append(delimiter);
                sb.Append("CVVL="  + this.CVVL);    sb.Append(delimiter);
                sb.Append("DEACD=" + this.DEACD);   sb.Append(delimiter);
                sb.Append("DEACO=" + this.DEACO);   sb.Append(delimiter);
                sb.Append("CCPO="  + this.CCPO);    sb.Append(delimiter);
                sb.Append("DVVLO=" + this.DVVLO);   sb.Append(delimiter);
                sb.Append("CDOHC=" + this.CDOHC);   sb.Append(delimiter);
                sb.Append("SGDI="  + this.SGDI);    sb.Append(delimiter);
                sb.Append("CBRST=" + this.CBRST);   sb.Append(delimiter);
                sb.Append("TRBDS=" + this.TRBDS);   sb.Append(delimiter);
                sb.Append("EGRB="  + this.EGRB);    sb.Append(delimiter);
                sb.Append("DSLT="  + this.DSLT);    sb.Append(delimiter);
                sb.Append("DSLC="  + this.DSLC);
                return sb.ToString();
            }
            public TechnologyOverride this[string abbr]
            {
                get
                {
                    switch (abbr.ToUpper())
                    {
                        case "LUB"   : return this.LUB  ;
                        case "EFR"   : return this.EFR  ;
                        case "CCPS"  : return this.CCPS ;
                        case "DVVLS" : return this.DVVLS;
                        case "DEACS" : return this.DEACS;
                        case "ICP"   : return this.ICP  ;
                        case "DCP"   : return this.DCP  ;
                        case "DVVLD" : return this.DVVLD;
                        case "CVVL"  : return this.CVVL ;
                        case "DEACD" : return this.DEACD;
                        case "DEACO" : return this.DEACO;
                        case "CCPO"  : return this.CCPO ;
                        case "DVVLO" : return this.DVVLO;
                        case "CDOHC" : return this.CDOHC;
                        case "SGDI"  : return this.SGDI ;
                        case "CBRST" : return this.CBRST;
                        case "TRBDS" : return this.TRBDS;
                        case "EGRB"  : return this.EGRB ;
                        case "DSLT"  : return this.DSLT ;
                        case "DSLC"  : return this.DSLC ;
                        default: return TechnologyOverride.None;
                    }
                }
            }
            public TechnologyOverride LUB;
            public TechnologyOverride EFR;
            public TechnologyOverride CCPS;
            public TechnologyOverride DVVLS;
            public TechnologyOverride DEACS;
            public TechnologyOverride ICP;
            public TechnologyOverride DCP;
            public TechnologyOverride DVVLD;
            public TechnologyOverride CVVL;
            public TechnologyOverride DEACD;
            public TechnologyOverride DEACO;
            public TechnologyOverride CCPO;
            public TechnologyOverride DVVLO;
            public TechnologyOverride CDOHC;
            public TechnologyOverride SGDI;
            public TechnologyOverride CBRST;
            public TechnologyOverride TRBDS;
            public TechnologyOverride EGRB;
            public TechnologyOverride DSLT;
            public TechnologyOverride DSLC;
        }
        #endregion
        #region 
        public EngineDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EngineDescription Clone()
        {
            EngineDescription ed = new EngineDescription();
            ed.Code                 = this.Code;
            ed.Manufacturer         = this.Manufacturer;
            ed.Name                 = this.Name;
            ed.Configuration        = this.Configuration;
            ed.Fuel                 = this.Fuel;
            ed.EngineOilViscosity   = this.EngineOilViscosity;
            ed.Cycle                = this.Cycle;
            ed.AirFuelRatio         = this.AirFuelRatio;
            ed.FuelSystem           = this.FuelSystem;
            ed.Aspiration           = this.Aspiration;
            ed.ValvetrainDesign     = this.ValvetrainDesign;
            ed.ValveActuationTiming = this.ValveActuationTiming;
            ed.ValveLift            = this.ValveLift;
            ed.Cylinders            = this.Cylinders;
            ed.ValvesPerCylinder    = this.ValvesPerCylinder;
            ed.Deactivation         = this.Deactivation;
            ed.Displacement         = this.Displacement;
            ed.MinCompressionRatio  = this.MinCompressionRatio;
            ed.MaxCompressionRatio  = this.MaxCompressionRatio;
            ed.Horsepower           = this.Horsepower;
            ed.Torque               = this.Torque;
            ed.Overrides            = this.Overrides;
            return ed;
        }
        #endregion
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Name;
        public string Configuration;
        public string Fuel;
        public string EngineOilViscosity;
        public char   Cycle;
        public double AirFuelRatio;
        public string FuelSystem;
        public char   Aspiration;
        public string ValvetrainDesign;
        public string ValveActuationTiming;
        public string ValveLift;
        public int    Cylinders;
        public int    ValvesPerCylinder;
        public double Deactivation;
        public double Displacement;
        public double MinCompressionRatio;
        public double MaxCompressionRatio;
        public double Horsepower;
        public double Torque;
        public EngineDescription.TechnologyOverrides Overrides;
        #endregion
    }
}

