using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct EncryptionSettings
    {
        #region 
        [Serializable]
        public struct EncryptionTypeInfo
        {
            #region 
            public EncryptionTypeInfo(string title, string algorithm, string provider, int defaultKey, int minKey,
                int maxKey, bool encryptDocProperties)
            {
                this.Title      = title;
                this.Algorithm  = algorithm;
                this.Provider   = provider;
                this.DefaultKey = defaultKey;
                this.MinKey     = minKey;
                this.MaxKey     = maxKey;
                this.EncryptDocProperties = encryptDocProperties;
            }
            #endregion
            #region 
            internal static EncryptionTypeInfo FromRC4Base(string provider)
            {
                return new EncryptionTypeInfo("RC4, " + provider, "RC4", provider, 40, 40, 56, true);
            }
            internal static EncryptionTypeInfo FromRC4Enhanced(string provider)
            {
                return EncryptionTypeInfo.FromRC4Enhanced(provider, 128);
            }
            internal static EncryptionTypeInfo FromRC4Enhanced(string provider, int defaultKey)
            {
                return new EncryptionTypeInfo("RC4, " + provider, "RC4", provider, defaultKey, 40, 128, true);
            }
            public override string ToString()
            {
                return this.Title;
            }
            #endregion
            #region 
            public static EncryptionTypeInfo OfficeXor
            {
                get
                {
                    return new EncryptionTypeInfo("Weak Encryption (XOR)", "OfficeXor", "", -1, -1, -1, false);
                }
            }
            public static EncryptionTypeInfo OfficeStandard
            {
                get
                {
                    return new EncryptionTypeInfo("Office 97/2000 Compatible", "OfficeStandard", "", 40, 40, 40, false);
                }
            }
            #endregion
            #region 
            public string Title;
            public string Algorithm;
            public string Provider;
            public int DefaultKey;
            public int MinKey;
            public int MaxKey;
            public bool EncryptDocProperties;
            #endregion
        }
        #endregion
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Encryption Settings ---";
            if (this.EncryptInput) { outStr += "\r\n  Encrypt Input"; }
            if (this.EncryptOutput)
            {
                outStr += "\r\n  Encrypt Output";
                if (this.EncryptDocumentProperties) { outStr += "\r\n  Encrypt Document Properties"; }
                outStr += "\r\n  Encryption Key Length=" + this.EncryptionKeyLength +
                    "\r\n  Encryption Type=" + this.EncryptionType.ToString();
            }
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        #region 
        public static readonly EncryptionTypeInfo[] EncryptionTypes =
            new EncryptionTypeInfo[]
            {
                EncryptionTypeInfo.OfficeXor,
                EncryptionTypeInfo.OfficeStandard,
                EncryptionTypeInfo.FromRC4Base("Microsoft Base Cryptographic Provider v1.0"),
                EncryptionTypeInfo.FromRC4Base("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider"),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft DH SChannel Cryptographic Provider", 40),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft Enhanced Cryptographic Provider v1.0"),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider"),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)"),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft RSA SChannel Cryptographic Provider"),
                EncryptionTypeInfo.FromRC4Enhanced("Microsoft Strong Cryptographic Provider")
            };
        #endregion
        public bool EncryptInput;
        public string InputPassword;
        public bool EncryptOutput;
        public bool EncryptDocumentProperties;
        public int EncryptionKeyLength;
        public EncryptionTypeInfo EncryptionType;
        public string OutputPasswordToOpen;
        public string OutputPasswordToModify;
        #endregion
    }
}

