using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct OperatingModes
    {
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Operating Modes ---" +
                "\r\n  ModelingApproach="                  + this.ModelingApproach                  +
                "\r\n  AutoToggleApproach="                + this.AutoToggleApproach                +
                "\r\n  NoFines="                           + this.NoFines                           +
                "\r\n  MultiYearModeling="                 + this.MultiYearModeling                 +
                "\r\n  MultiYearStartYear="                + this.MultiYearStartYear                +
                "\r\n  SplitSharedEngsOrTrns="             + this.SplitSharedEngsOrTrns             +
                "\r\n  SplitConflictingEngsOrTrns="        + this.SplitConflictingEngsOrTrns        +
                "\r\n  SkipSharedEngsOrTrns="              + this.SkipSharedEngsOrTrns              +
                "\r\n  SkipConflictingEngsOrTrns="         + this.SkipConflictingEngsOrTrns         +
                "\r\n  TechnologyFuelEstimates="           + this.TechnologyFuelEstimates           +
                "\r\n  TechnologyCostEstimates="           + this.TechnologyCostEstimates           +
                "\r\n  Backfill="                          + this.Backfill                          +
                "\r\n  ClipTechImprovements="              + this.ClipTechImprovements              +
                "\r\n  ClipTechCosts="                     + this.ClipTechCosts                     +
                "\r\n  ReserveTechnologiesIfInCompliance=" + this.ReserveTechnologiesIfInCompliance +
                "\r\n  IgnoreYearAvailable="               + this.IgnoreYearAvailable               +
                "\r\n  IgnorePhaseIn="                     + this.IgnorePhaseIn                     +
                "\r\n  IgnoreRefreshRedesign="             + this.IgnoreRefreshRedesign             +
                "\r\n  IgnoreWeightInMsApplication="       + this.IgnoreWeightInMsApplication       +
                "\r\n  ShutoffEngineTechsAfterHEV="        + this.ShutoffEngineTechsAfterHEV        +
                "\r\n  ShutoffTransmissionTechsAfterHEV="  + this.ShutoffTransmissionTechsAfterHEV  +
                "\r\n  ShutoffElecTechsAfterHEV="          + this.ShutoffElecTechsAfterHEV          +
                "\r\n  FuelPriceEstimates="                + this.FuelPriceEstimates;
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        #region 
        public ModelingApproach ModelingApproach;
        public bool AutoToggleApproach;
        public bool NoFines;
        public bool MultiYearModeling;
        public int MultiYearStartYear;
        public bool SplitSharedEngsOrTrns;
        public bool SplitConflictingEngsOrTrns;
        public bool SkipSharedEngsOrTrns;
        public bool SkipConflictingEngsOrTrns;
        #endregion
        #region 
        public Estimates TechnologyFuelEstimates;
        public Estimates TechnologyCostEstimates;
        public bool Backfill;
        public bool ClipTechImprovements;
        public bool ClipTechCosts;
        public bool ReserveTechnologiesIfInCompliance;
        #endregion
        #region 
        public bool IgnoreYearAvailable;
        public bool IgnorePhaseIn;
        public bool IgnoreRefreshRedesign;
        public bool IgnoreWeightInMsApplication;
        public bool ShutoffEngineTechsAfterHEV;
        public bool ShutoffTransmissionTechsAfterHEV;
        public bool ShutoffElecTechsAfterHEV;
        public Estimates FuelPriceEstimates;
        #endregion
        #endregion
    }
}

