using System;
namespace Volpe.Cafe
{
    [Serializable]
    public class TechnologySynergies : ICloneable
    {
        #region 
        public TechnologySynergies()
        {
            this._synergies = new double     [TechnologyIndexes.TechnologyCount];
            this._type      = new SynergyType[TechnologyIndexes.TechnologyCount];
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TechnologySynergies Clone()
        {
            TechnologySynergies ts = new TechnologySynergies();
            ts._synergies = (double     [])Global.CloneArray(this._synergies, typeof(double     ));
            ts._type      = (SynergyType[])Global.CloneArray(this._type     , typeof(SynergyType));
            return ts;
        }
        #endregion
        internal void SetSynergy(int index, double synergy, SynergyType type)
        {
            if (index >= 0 && index < TechnologyIndexes.TechnologyCount)
            {
                this._synergies[index] = synergy;
                this._type     [index] = type;
            }
        }
        #endregion
        #region 
        public double[] Synergies { get { return this._synergies; } }
        public SynergyType[] Type { get { return this._type; } }
        #endregion
        #region 
        double     [] _synergies;
        SynergyType[] _type;
        #endregion
    }
}

