using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlAxisFormat
    {
        #region 
        public XlAxisFormat()
            : this(true, null, true, false, double.NaN, double.NaN, double.NaN, double.NaN, double.NaN, false, false, null, null)
        {
        }
        public XlAxisFormat(bool hasTitle, XlAxisTitleFormat axisTitle, bool solidBorder, bool thickBorder, double crossesAt,
            double majorUnit, double minorUnit, double maximumScale, double minimumScale, bool reversePlotOrder,
            bool logorithmicScale, XlGridlinesFormat gridlinesFormat, XlTickLabelsFormat tickLabels)
        {
            this._axisTitle        = axisTitle;
            this._solidBorder      = solidBorder;
            this._thickBorder      = thickBorder;
            this._crossesAt        = crossesAt;
            this._hasTitle         = hasTitle;
            this._majorUnit        = majorUnit;
            this._minorUnit        = minorUnit;
            this._maximumScale     = maximumScale;
            this._minimumScale     = minimumScale;
            this._reversePlotOrder = reversePlotOrder;
            this._logorithmicScale = logorithmicScale;
            this._gridlinesFormat  = gridlinesFormat;
            this._tickLabels       = tickLabels;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{HasTitle="       + this._hasTitle +
                ", AxisTitle="        + this._axisTitle +
                ", SolidBorder="      + this._solidBorder +
                ", ThickBorder="      + this._thickBorder +
                ", CrossesAt="        + this._crossesAt +
                ", MajorUnit="        + this._majorUnit +
                ", MinorUnit="        + this._minorUnit +
                ", MaximumScale="     + this._maximumScale +
                ", MinimumScale="     + this._minimumScale +
                ", ReversePlotOrder=" + this._reversePlotOrder +
                ", LogorithmicScale=" + this._logorithmicScale +
                ", GridlinesFormat="  + this._gridlinesFormat +
                ", TickLabels="       + this._tickLabels + "}";
        }
        #endregion
        #region 
        public bool HasTitle
        {
            get { return this._hasTitle && this._axisTitle != null; }
            set { this._hasTitle = value; }
        }
        public XlAxisTitleFormat AxisTitle
        {
            get { return this._axisTitle; }
            set { this._axisTitle = value; }
        }
        public bool SolidBorder
        {
            get { return this._solidBorder; }
            set { this._solidBorder = value; }
        }
        public bool ThickBorder
        {
            get { return this._thickBorder; }
            set { this._thickBorder = value; }
        }
        public double CrossesAt
        {
            get { return this._crossesAt; }
            set { this._crossesAt = value; }
        }
        public double MajorUnit
        {
            get { return this._majorUnit; }
            set { this._majorUnit = value; }
        }
        public double MinorUnit
        {
            get { return this._minorUnit; }
            set { this._minorUnit = value; }
        }
        public double MaximumScale
        {
            get { return this._maximumScale; }
            set { this._maximumScale = value; }
        }
        public double MinimumScale
        {
            get { return this._minimumScale; }
            set { this._minimumScale = value; }
        }
        public bool ReversePlotOrder
        {
            get { return this._reversePlotOrder; }
            set { this._reversePlotOrder = value; }
        }
        public bool LogorithmicScale
        {
            get { return this._logorithmicScale; }
            set { this._logorithmicScale = value; }
        }
        public XlGridlinesFormat GridlinesFormat
        {
            get { return this._gridlinesFormat; }
            set { this._gridlinesFormat = value; }
        }
        public XlTickLabelsFormat TickLabels
        {
            get { return this._tickLabels; }
            set { this._tickLabels = value; }
        }
        #endregion
        #region 
        private bool _hasTitle;
        private XlAxisTitleFormat _axisTitle;
        private bool _solidBorder;
        private bool _thickBorder;
        private double _crossesAt;
        private double _majorUnit;
        private double _minorUnit;
        private double _maximumScale;
        private double _minimumScale;
        private bool _reversePlotOrder;
        private bool _logorithmicScale;
        private XlGridlinesFormat _gridlinesFormat;
        private XlTickLabelsFormat _tickLabels;
        #endregion
    }
}

