using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlDataLabelsFormat
    {
        #region 
        public XlDataLabelsFormat()
            : this(XlDataLabelsFormat.DefaultFont, null)
        {
        }
        public XlDataLabelsFormat(XlFont font, string numberFormat)
            : this(font, numberFormat, XlDataLabelsFormat.DefaultAlignment, 0)
        {
        }
        public XlDataLabelsFormat(XlFont font, string numberFormat, XlTextAlignment textAlignment, int textOrientation)
            : this(font, numberFormat, (numberFormat == null || numberFormat.Trim() == ""), textAlignment,
            textOrientation, false, false, false, false, false, true)
        {
        }
        public XlDataLabelsFormat(XlFont font, string numberFormat, bool numberFormatLinked, XlTextAlignment textAlignment,
            int textOrientation, bool shadow, bool showCategoryName, bool showLegendKey, bool showPercentage, bool showSeriesName,
            bool showValue)
        {
            this._font               = font;
            this._numberFormat       = numberFormat;
            this._numberFormatLinked = numberFormatLinked;
            this._textAlignment      = textAlignment;
            this._textOrientation    = textOrientation;
            this._shadow             = shadow;
            this._showCategoryName   = showCategoryName;
            this._showLegendKey      = showLegendKey;
            this._showPercentage     = showPercentage;
            this._showSeriesName     = showSeriesName;
            this._showValue          = showValue;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Font="             + this._font +
                ", NumberFormat="       + this._numberFormat +
                ", NumberFormatLinked=" + this._numberFormatLinked +
                ", TextAlignment="      + this._textAlignment +
                ", TextOrientation="    + this._textOrientation +
                ", Shadow="             + this._shadow +
                ", ShowCategoryName="   + this._showCategoryName +
                ", ShowLegendKey="      + this._showLegendKey +
                ", ShowPercentage="     + this._showPercentage +
                ", ShowSeriesName="     + this._showSeriesName +
                ", ShowValue="          + this._showValue + "}";
        }
        #endregion
        #region 
        public XlFont Font
        {
            get { return this._font; }
            set { this._font = value; }
        }
        public string NumberFormat
        {
            get { return this._numberFormat; }
            set { this._numberFormat = value; }
        }
        public bool NumberFormatLinked
        {
            get { return this._numberFormatLinked; }
            set { this._numberFormatLinked = value; }
        }
        public XlTextAlignment TextAlignment
        {
            get { return this._textAlignment; }
            set { this._textAlignment = value; }
        }
        public int TextOrientation
        {
            get { return this._textOrientation; }
            set { this._textOrientation = (value < -90) ? -90 : (value > 90) ? 90 : value; }
        }
        public bool Shadow
        {
            get { return this._shadow; }
            set { this._shadow = value; }
        }
        public bool ShowCategoryName
        {
            get { return this._showCategoryName; }
            set { this._showCategoryName = value; }
        }
        public bool ShowLegendKey
        {
            get { return this._showLegendKey; }
            set { this._showLegendKey = value; }
        }
        public bool ShowPercentage
        {
            get { return this._showPercentage; }
            set { this._showPercentage = value; }
        }
        public bool ShowSeriesName
        {
            get { return this._showSeriesName; }
            set { this._showSeriesName = value; }
        }
        public bool ShowValue
        {
            get { return this._showValue; }
            set { this._showValue = value; }
        }
        #endregion
        #region 
        public static readonly XlFont DefaultFont = new XlFont("Arial", 10);
        public static readonly XlTextAlignment DefaultAlignment = new XlTextAlignment(XlHAlign.Center, XlVAlign.Center);
        private XlFont _font;
        private string _numberFormat;
        private bool _numberFormatLinked;
        private XlTextAlignment _textAlignment;
        private int _textOrientation;
        private bool _shadow;
        private bool _showCategoryName;
        private bool _showLegendKey;
        private bool _showPercentage;
        private bool _showSeriesName;
        private bool _showValue;
        #endregion
    }
}

