using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlHeaderFooterText
    {
        #region 
        public XlHeaderFooterText()
            : this(null, null, null)
        {
        }
        public XlHeaderFooterText(string left, string center, string right)
        {
            this.SetText(left, center, right);
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{L:" + this.Left + ", C:" + this.Center + ", R:" + this.Right + "}";
        }
        public void SetText(string left, string center, string right)
        {
            this.Left   = left;
            this.Center = center;
            this.Right  = right;
        }
        public void SetDefaultHeader()
        {
            this.SetText(null, null, "&08 " + DateTime.Now.ToString());
        }
        public void SetDefaultFooter()
        {
            this.SetText("&08&F / &A", "&\"Arial,Bold\"&12DELIBERATIVE MATERIAL CONTAINING CBI--DO NOT CITE OR RELEASE",
                "&08Page &P of &N");
        }
        #endregion
        #region 
        public string Left;
        public string Center;
        public string Right;
        #endregion
    }
}

