using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlMargins
    {
        #region 
        public XlMargins()
            : this(0.5)
        {
        }
        public XlMargins(double side)
            : this(side, XlUnit.Inches)
        {
        }
        public XlMargins(double side, XlUnit unit)
            : this(side, side, side, side, unit)
        {
        }
        public XlMargins(double top, double left, double bottom, double right)
            : this(top, left, bottom, right, XlUnit.Inches)
        {
        }
        public XlMargins(double top, double left, double bottom, double right, XlUnit unit)
            : this(top, left, bottom, right, top - 0.25, bottom - 0.25, unit, false, false)
        {
        }
        public XlMargins(double side, double header, double footer, XlUnit unit, bool centerHorizontally, bool centerVertically)
            : this(side, side, side, side, header, footer, unit, centerHorizontally, centerVertically)
        {
        }
        public XlMargins(double top, double left, double bottom, double right, double header,
            double footer, XlUnit unit, bool centerHorizontally, bool centerVertically)
        {
            this.SetMargins(top, left, bottom, right, header, footer, unit, centerHorizontally, centerVertically);
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "({T:" + this.Top.ToString() + ", L:" + this.Left.ToString() + ", B:" +
                this.Bottom.ToString() + ", R:" + this.Right.ToString() + "}, {H:" +
                this.Header.ToString() + ", F:" + this.Footer.ToString() + "}, {U:" +
                this.Unit.ToString() + "}, {CH:" + this.CenterHorizontally + ", CV:" +
                this.CenterVertically.ToString() + "})";
        }
        public void SetMargins(double side)
        {
            this.SetMargins(side, side, side, side);
        }
        public void SetMargins(double top, double left, double bottom, double right)
        {
            this.Top    = top;
            this.Left   = left;
            this.Bottom = bottom;
            this.Right  = right;
        }
        public void SetMargins(double side, double header, double footer, XlUnit unit, bool centerHorizontally,
            bool centerVertically)
        {
            this.SetMargins(side, side, side, side, header, footer, unit, centerHorizontally, centerVertically);
        }
        public void SetMargins(double top, double left, double bottom, double right, double header, double footer, XlUnit unit,
            bool centerHorizontally, bool centerVertically)
        {
            this.SetMargins(top, left, bottom, right);
            this.Header = (header < 0) ? 0 : header;
            this.Footer = (footer < 0) ? 0 : footer;
            this.Unit   = unit;
            this.CenterHorizontally = centerHorizontally;
            this.CenterVertically   = centerVertically;
        }
        #endregion
        #region 
        public int PtTop    { get { return (int)(this.Top    * (int)this.Unit); } }
        public int PtBottom { get { return (int)(this.Bottom * (int)this.Unit); } }
        public int PtLeft   { get { return (int)(this.Left   * (int)this.Unit); } }
        public int PtRight  { get { return (int)(this.Right  * (int)this.Unit); } }
        public int PtHeader { get { return (int)(this.Header * (int)this.Unit); } }
        public int PtFooter { get { return (int)(this.Footer * (int)this.Unit); } }
        #endregion
        #region 
        public double Top;
        public double Bottom;
        public double Left;
        public double Right;
        public double Header;
        public double Footer;
        public XlUnit Unit;
        public bool CenterHorizontally;
        public bool CenterVertically;
        #endregion
    }
}

