using System;
namespace Volpe.Utils
{
    [Serializable]
    public enum ZipFormat : int
    {
        Zip = 1,
        GZip = 2,
    }
    [Serializable]
    public enum ZipMethod : int
    {
        Deflated = 8
    }
    [Serializable]
    public enum ZipStrategy : int
    {
        Default = 0,
        Filtered = 1,
        HuffmanOnly = 2
    }
    [Serializable]
    public enum ZipLevel : int
    {
        Default               = -1,
        NoCompression         =  0,
        BestSpeed             =  1,
        SecondBestSpeed       =  2,
        BalancedCompression   =  5,
        SecondBestCompression =  8,
        BestCompression       =  9,
        Lowest       = 1,
        VeryLow      = 2,
        Low          = 3,
        BelowAverage = 4,
        Average      = 5,
        AboveAverage = 6,
        High         = 7,
        VeryHigh     = 8,
        Highest      = 9,
        Level0 = 0,
        Level1 = 1,
        Level2 = 2,
        Level3 = 3,
        Level4 = 4,
        Level5 = 5,
        Level6 = 6,
        Level7 = 7,
        Level8 = 8,
        Level9 = 9
    }
}

