using System;
using Volpe.Cafe.Generic;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class RCBoolean : RCValue<bool>, ICloneable
    {
        #region 
        public RCBoolean() : base() { }
        public RCBoolean(bool initialValue) : base(initialValue, initialValue, initialValue) { }
        public RCBoolean(bool passengerCar, bool lightTruck, bool lightTruck2b3) : base(passengerCar, lightTruck, lightTruck2b3) { }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public new RCBoolean Clone()
        {
            RCBoolean value = new RCBoolean();
            this.CopyTo(value);
            return value;
        }
        #endregion
        public bool GetValue(RegulatoryClass regClass)
        {
            return (regClass == RegulatoryClass.All) ? this.IsTrue : this[regClass];
        }
        #endregion
        #region 
        public static RCBoolean False { get { return new RCBoolean(false); } }
        public static RCBoolean True { get { return new RCBoolean(true); } }
        public bool IsFalse { get { return this.Equals(False); } }
        public bool IsTrue { get { return this.Equals(True); } }
        #endregion
    }
}

