using System;
using Volpe.Cafe.Generic;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class RCInt32 : RCValue<int>, ICloneable
    {
        #region 
        public RCInt32() : base() { }
        public RCInt32(int initialValue) : base(initialValue, initialValue, initialValue) { }
        public RCInt32(int passengerCar, int lightTruck, int lightTruck2b3) : base(passengerCar, lightTruck, lightTruck2b3) { }
        #endregion
        #region 
        #region 
        public static RCInt32 operator +(RCInt32 value1, RCInt32 value2)
        {
            RCInt32 result = new RCInt32();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] + value2.Items[i];
            }
            return result;
        }
        public static RCInt32 operator +(RCInt32 value1, int value2)
        {
            return value1 + new RCInt32(value2);
        }
        public static RCInt32 operator +(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) + value2;
        }
        public static RCInt32 operator -(RCInt32 value1, RCInt32 value2)
        {
            RCInt32 result = new RCInt32();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] - value2.Items[i];
            }
            return result;
        }
        public static RCInt32 operator -(RCInt32 value1, int value2)
        {
            return value1 - new RCInt32(value2);
        }
        public static RCInt32 operator -(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) - value2;
        }
        public static RCInt32 operator *(RCInt32 value1, RCInt32 value2)
        {
            RCInt32 result = new RCInt32();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] * value2.Items[i];
            }
            return result;
        }
        public static RCInt32 operator *(RCInt32 value1, int value2)
        {
            return value1 * new RCInt32(value2);
        }
        public static RCInt32 operator *(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) * value2;
        }
        public static RCInt32 operator /(RCInt32 value1, RCInt32 value2)
        {
            RCInt32 result = new RCInt32();
            for (int i = 0; i < result.Items.Length; i++)
            {
                result.Items[i] = value1.Items[i] / value2.Items[i];
            }
            return result;
        }
        public static RCInt32 operator /(RCInt32 value1, int value2)
        {
            return value1 / new RCInt32(value2);
        }
        public static RCInt32 operator /(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) / value2;
        }
        public static RCInt32 operator +(RCInt32 value)
        {
            return RCInt32.Zero + value;
        }
        public static RCInt32 operator -(RCInt32 value)
        {
            return RCInt32.Zero - value;
        }
        public static RCInt32 operator ++(RCInt32 value)
        {
            return value + RCInt32.One;
        }
        public static RCInt32 operator --(RCInt32 value)
        {
            return value - RCInt32.One;
        }
        #endregion
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public new RCInt32 Clone()
        {
            RCInt32 value = new RCInt32();
            this.CopyTo(value);
            return value;
        }
        #endregion
        public string ToString(string format)
        {
            string s = string.Empty;
            for (int i = 0; i < this.Items.Length; i++)
            {
                if (i > 0) { s += ", "; }
                s += (Names[i] + "=" + this.Items[i].ToString(format));
            }
            return "{" + s + "}";
        }
        public int GetValue(RegulatoryClass regClass)
        {
            return (regClass == RegulatoryClass.All) ? this.Total : this[regClass];
        }
        #endregion
        #region 
        public static RCInt32 Zero { get { return new RCInt32(0); } }
        public static RCInt32 One { get { return new RCInt32(1); } }
        public int Total
        {
            get
            {
                int total = 0;
                for (int i = 0; i < this.Items.Length; i++)
                {
                    total += this.Items[i];
                }
                return total;
            }
        }
        #endregion
    }
}

