using System;
using System.Collections.Generic;
using Volpe.Cafe;
using Volpe.Cafe.Utils;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public sealed class Transmission : Component
    {
        #region 
        [Serializable]
        public sealed class CDescription
        {
            #region 
            internal CDescription() : base() { }
            #endregion
            #region 
            internal CDescription Clone()
            {
                CDescription td = new CDescription();
                td.Code            = this.Code;
                td.Manufacturer    = this.Manufacturer;
                td.Family          = this.Family;
                td.Type            = this.Type;
                td.NumForwardGears = this.NumForwardGears;
                td.UsedTechnologies      = (int[])Interaction.CloneArray(this.UsedTechnologies     , typeof(int));
                td.AvailableTechnologies = (int[])Interaction.CloneArray(this.AvailableTechnologies, typeof(int));
                return td;
            }
            public override string ToString()
            {
                return
                    (this.Type == "DCT" || this.Type == "A" || this.Type == "M") ? this.Type + this.NumForwardGears :
                    (this.Type.StartsWith("CVT")) ? "CVT" : this.Type;
            }
            #endregion
            #region 
            public int Code;
            public string Manufacturer;
            public string Family;
            public string Type;
            public int NumForwardGears;
            public int[] UsedTechnologies;
            public int[] AvailableTechnologies;
            #endregion
        }
        #endregion
        #region 
        Transmission() : base() { }
        internal Transmission(Transmission.CDescription description) : base()
        {
            this._description = description;
        }
        #endregion
        #region 
        internal Transmission Clone()
        {
            Transmission trn = new Transmission();
            trn._description = this._description.Clone();
            this.CopyTo(trn);
            return trn;
        }
        internal void SetParent(int parentCode)
        {
            if (parentCode != -1)
            {
                Transmission[] trns = this._manufacturer.Transmissions.ToArray();
                for (int i = 0; i < trns.Length; i++)
                {
                    if (parentCode == trns[i]._description.Code) { this._parent = trns[i]; break; }
                }
            }
        }
        internal void SetParent(Transmission value)
        {
            this._parent = value;
        }
        public Transmission Split(List<Vehicle> vehicles, int newCode)
        {
            Transmission trn = (Transmission)this.Clone();
            newCode = Math.Max(newCode, trn._manufacturer.GetNextTransmissionCode());
            trn._description.Code = newCode;
            trn._manufacturer.LastTrnCode = newCode;
            for (int i = 0, vehCount = vehicles.Count; i < vehCount; i++)
            {
                vehicles[i].SetTransmission(trn);
            }
            this.SplitTo(vehicles, trn);
            return trn;
        }
        #endregion
        #region 
        public override int[] TechnologyList { get { return TechnologyIndexes.TransmissionLevel; } }
        public Transmission.CDescription Description { get { return this._description; } }
        public Transmission Parent { get { return (Transmission)this._parent; } }
        #endregion
        #region 
        Transmission.CDescription _description;
        #endregion
    }
}

