using System;
using System.IO;
using System.Text;
namespace Volpe.Cafe.IO
{
    [Serializable]
    public sealed class ComplianceWriter
    {
        #region 
        public ComplianceWriter(string path, bool append)
        {
            this._lineCount = 0;
            this._sw        = new StreamWriter(path, append);
        }
        #endregion
        #region 
        public void Write(string value)
        {
            this._sw.Write(value);
            int index = -1;
            while (true)
            {
                index = value.IndexOf(NewLine, ++index);
                if (index == -1) { break; }
                this._lineCount++;
            }
        }
        public void WriteLine(string value)
        {
            this.Write(value);
            this._sw.Write(NewLine);
            this._lineCount++;
        }
        public void Close()
        {
            this._sw.Close();
        }
        #endregion
        #region 
        public int LineCount { get { return this._lineCount; } }
        #endregion
        #region 
        const string NewLine = "\n";
        int           _lineCount;
        StreamWriter  _sw;
        #endregion
    }
}

