#region << Using Directives >>
using System;
#endregion
namespace Volpe.Cafe.IO
{
    [Serializable]
    public class IOException : Exception
    {
        #region 
        public IOException(string fileName) : this(fileName, string.Empty) { }
        public IOException(string fileName, string message) : this(fileName, message, null) { }
        public IOException(string fileName, string message, Exception innerException) : this(fileName, message, innerException, 0) { }
        protected IOException(string fileName, string message, Exception innerException, int readWriteFlags)
            : base(((readWriteFlags == 2) ? ErrorWritingFile : (readWriteFlags == 1) ? ErrorReadingFile : ErrorProcessingFile) +
            fileName + ((message == null || message.Trim() == string.Empty) ? "" : "\nAdditional information: " + message), innerException)
        {
            this._fileName = fileName;
        }
        #endregion
        #region 
        public string FileName { get { return this._fileName; } }
        #endregion
        #region 
        internal const string ErrorProcessingFile = "Error processing file: ";
        internal const string ErrorReadingFile = "Error reading file: ";
        internal const string ErrorWritingFile = "Error writing file: ";
        string _fileName;
        #endregion
    }
}

