using System;
namespace Volpe.Cafe.IO.Reporting.XL
{
    [Serializable]
    public class XlReportingException : Exception
	{
        #region 
        public XlReportingException(string fileName)
            : this(string.Empty, fileName)
        {
        }
        public XlReportingException(string message, string fileName)
            : this(message, fileName, null)
        {
        }
        public XlReportingException(string message, string fileName, Exception innerException)
            : base("Error writing file: " + fileName + "\nAdditional information: " + message, innerException)
        {
            this._fileName = fileName;
        }
        #endregion
        #region 
        public string FileName { get { return this._fileName; } }
        #endregion
        #region 
        string _fileName;
        #endregion
	}
}

