using System;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public enum ModelingState : int
    {
        Unstarted = 0,
        StartRequested = 1,
        Running = 2,
        StopRequested = 3,
        Stopped = 4,
        Completed = 5
    }
    [Serializable]
    public enum ComponentType : int
    {
        General = 0,
        Engine = 1,
        Transmission = 2,
        Nameplate = 3
    }
    [Serializable]
    public enum RequiredModelInputs
    {
        None = 0,
        MarketData = 1,
        Technologies = 2,
        Parameters = 4,
        Scenarios = 8,
        All = MarketData | Technologies | Parameters | Scenarios
    }
}

