#region << Using Directives >>
using System;
using Volpe.Cafe.Data;
#endregion
namespace Volpe.Cafe.Model
{
    public class TechImpact : ICloneable
    {
        #region 
        public TechImpact(int len)
        {
            this.HasImpact         = new bool     [len];
            this.Vehicle           = new Vehicle  [len];
            this.Cost              = new double   [len];
            this.ERPCost           = new double   [len];
            this.MaintenanceCost   = new double   [len];
            this.RepairCost        = new double   [len];
            this.LossOfValue       = new double   [len];
            this.OffCycleCredit    = new double   [len];
            this.Improvement       = new FuelValue[len];
            this.Improvement2      = new FuelValue[len];
            this.NewFuelEconomy    = new FuelValue[len];
            this.NewFuelEconomy2   = new FuelValue[len];
            this.NewFuelShare      = new FuelValue[len];
            this.DeltaFuelEconomy  = new FuelValue[len];
            this.DeltaFuelEconomy2 = new FuelValue[len];
            this.DeltaCurbWeight   = new double   [len];
            this.DeltaGVWR         = new double   [len];
            this.DeltaGCWR         = new double   [len];
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TechImpact Clone()
        {
            TechImpact impact = new TechImpact(this.HasImpact.Length);
            this.CopyTo(impact);
            return impact;
        }
        public void CopyTo(TechImpact impact)
        {
            int len = this.HasImpact.Length;
            impact.Ignore = this.Ignore;
            Array.Copy(this.HasImpact        , impact.HasImpact        , len);
            Array.Copy(this.Vehicle          , impact.Vehicle          , len);
            Array.Copy(this.Cost             , impact.Cost             , len);
            Array.Copy(this.ERPCost          , impact.ERPCost          , len);
            Array.Copy(this.MaintenanceCost  , impact.MaintenanceCost  , len);
            Array.Copy(this.RepairCost       , impact.RepairCost       , len);
            Array.Copy(this.LossOfValue      , impact.LossOfValue      , len);
            Array.Copy(this.OffCycleCredit   , impact.OffCycleCredit   , len);
            Array.Copy(this.Improvement      , impact.Improvement      , len);
            Array.Copy(this.Improvement2     , impact.Improvement2     , len);
            Array.Copy(this.NewFuelEconomy   , impact.NewFuelEconomy   , len);
            Array.Copy(this.NewFuelEconomy2  , impact.NewFuelEconomy2  , len);
            Array.Copy(this.NewFuelShare     , impact.NewFuelShare     , len);
            Array.Copy(this.DeltaFuelEconomy , impact.DeltaFuelEconomy , len);
            Array.Copy(this.DeltaFuelEconomy2, impact.DeltaFuelEconomy2, len);
            Array.Copy(this.DeltaCurbWeight  , impact.DeltaCurbWeight  , len);
            Array.Copy(this.DeltaGVWR        , impact.DeltaGVWR        , len);
            Array.Copy(this.DeltaGCWR        , impact.DeltaGCWR        , len);
        }
        #endregion
        public override string ToString()
        {
            return "{" + this.ToStringInternal() + "}";
        }
        public string ToString(bool fullString)
        {
            if (fullString)
            {
                return "{Vehicle Code=" + this.Vehicle[this.Vehicle.Length - 1].Description.Code + ", Ignore=" + this.Ignore +
                    ", " + this.ToStringInternal() + "}";
            }
            else { return this.ToString(); }
        }
        string ToStringInternal()
        {
            int lastYear  = this.HasImpact.Length - 1;
            int firstYear = 0;
            for (int i = 0; i < this.HasImpact.Length; i++)
            {   
                if (this.HasImpact[i]) { firstYear = i; break; }
            }
            bool multiple = (firstYear != lastYear);
            string impactString = string.Empty;
            for (int i = lastYear; i >= firstYear; i--)
            {   
                if (this.HasImpact[i])
                {
                    if (multiple) { impactString += "{"; }
                    impactString +=
                        "Model Year="         + (ModelYear.MinYear +   i)                     .ToString(        ) +
                        ", Veh Code="         + this.Vehicle          [i].Description.Code    .ToString(        ) +
                        ", Sales="            + this.Vehicle          [i].Description.Sales[i].ToString(        ) +
                        ", Cost="             + this.Cost             [i]                     .ToString("0.####") +
                        ", ERPCost="          + this.ERPCost          [i]                     .ToString("0.####") +
                        ", MaintenanceCost="  + this.MaintenanceCost  [i]                     .ToString("0.####") +
                        ", RepairCost="       + this.RepairCost       [i]                     .ToString("0.####") +
                        ", Loss Of Val="      + this.LossOfValue      [i]                     .ToString("0.####") +
                        ", Off-Cycle Credit=" + this.OffCycleCredit   [i]                     .ToString("0.####") +
                        ", Improvement="      + this.Improvement      [i]                     .ToString("0.####") +
                        ", Improvement2="     + this.Improvement2     [i]                     .ToString("0.####") +
                        ", New FE="           + this.NewFuelEconomy   [i]                     .ToString("0.####") +
                        ", New FE2="          + this.NewFuelEconomy2  [i]                     .ToString("0.####") +
                        ", New Share="        + this.NewFuelShare     [i]                     .ToString("0.####") +
                        ", Delta FE="         + this.DeltaFuelEconomy [i]                     .ToString("0.####") +
                        ", Delta FE2="        + this.DeltaFuelEconomy2[i]                     .ToString("0.####") +
                        ", Delta CW="         + this.DeltaCurbWeight  [i]                     .ToString("0.####") +
                        ", Delta GVWR="       + this.DeltaGVWR        [i]                     .ToString("0.####") +
                        ", Delta GCWR="       + this.DeltaGCWR        [i]                     .ToString("0.####");
                    if (multiple) { impactString += ((i == firstYear) ? "}" : "}, "); }
                }
            }
            return impactString;
        }
        public void Reset()
        {
            int len = this.HasImpact.Length;
            this.Ignore = false;
            Array.Clear(this.HasImpact        , 0, len);
            Array.Clear(this.Vehicle          , 0, len);
            Array.Clear(this.Cost             , 0, len);
            Array.Clear(this.ERPCost          , 0, len);
            Array.Clear(this.MaintenanceCost  , 0, len);
            Array.Clear(this.RepairCost       , 0, len);
            Array.Clear(this.LossOfValue      , 0, len);
            Array.Clear(this.OffCycleCredit   , 0, len);
            Array.Clear(this.Improvement      , 0, len);
            Array.Clear(this.Improvement2     , 0, len);
            Array.Clear(this.NewFuelEconomy   , 0, len);
            Array.Clear(this.NewFuelEconomy2  , 0, len);
            Array.Clear(this.NewFuelShare     , 0, len);
            Array.Clear(this.DeltaFuelEconomy , 0, len);
            Array.Clear(this.DeltaFuelEconomy2, 0, len);
            Array.Clear(this.DeltaCurbWeight  , 0, len);
            Array.Clear(this.DeltaGVWR        , 0, len);
            Array.Clear(this.DeltaGCWR        , 0, len);
        }
        public bool HasFuelTypeChanged(int yrIndex)
        {
            return (this.NewFuelShare[yrIndex].FuelType != this.Vehicle[yrIndex].Description.FuelShare.FuelType);
        }
        public bool HasWeightChanged(int yrIndex)
        {
            return (this.DeltaCurbWeight[yrIndex] != 0);
        }
        public bool HasGVWRChanged(int yrIndex)
        {
            return (this.DeltaGVWR[yrIndex] != 0);
        }
        public bool HasGCWRChanged(int yrIndex)
        {
            return (this.DeltaGCWR[yrIndex] != 0);
        }
        public bool HasFootprintChanged(int yrIndex)
        {
            return false;
        }
        #endregion
        #region 
        public bool Ignore;
        public bool[] HasImpact;
        public Vehicle[] Vehicle;
        public double[] Cost;
        public double[] ERPCost;
        public double[] MaintenanceCost;
        public double[] RepairCost;
        public double[] LossOfValue;
        public double[] OffCycleCredit;
        public FuelValue[] Improvement;
        public FuelValue[] Improvement2;
        public FuelValue[] NewFuelEconomy;
        public FuelValue[] NewFuelEconomy2;
        public FuelValue[] NewFuelShare;
        public FuelValue[] DeltaFuelEconomy;
        public FuelValue[] DeltaFuelEconomy2;
        public double[] DeltaCurbWeight;
        public double[] DeltaGVWR;
        public double[] DeltaGCWR;
        #endregion
    }
}

