using System;
using System.Globalization;
using Volpe.Cafe.Utils;
namespace Volpe.Cafe
{
    [Serializable]
    public class ModelYear : IComparable
    {
        #region 
        public ModelYear(int year)
        {
            if (year < ModelYear.MinYear) { throw new ArgumentOutOfRangeException("year", year, ErrorStrings.ModelYearTooSmall); }
            this.Year  = year;
            this.Index = year - ModelYear.MinYear;
        }
        #endregion
        #region 
        #region 
        public int CompareTo(object obj)
        {
            int year = 0;
            if      (obj is ModelYear          ) { year = ((ModelYear)obj).Year; }
            else if (Interaction.IsNumeric(obj)) { year = Interaction.GetInt32(obj); }
            else                                 { throw new ArgumentException(ErrorStrings.ObjectIsNotModelYearOrNumeric); }
            return this.Year.CompareTo(year);
        }
        #endregion
        #region 
        public override string ToString()
        {
            return this.Year.ToString();
        }
        public override int GetHashCode()
        {
            return this.Year.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                throw new ArgumentNullException("obj");
            }
            return (this.CompareTo(obj) == 0);
        }
        public bool Equals(ModelYear year)
        {
            return (this.Year == year.Year);
        }
        public bool Equals(int year)
        {
            return (this.Year == year);
        }
        public bool EqualsIndex(int index)
        {
            return (this.Index == index);
        }
        #endregion
        public static int ToIndex(int year)
        {
            if (year < ModelYear.MinYear) { throw new ArgumentOutOfRangeException("year", year, ErrorStrings.ModelYearTooSmall); }
            return year - ModelYear.MinYear;
        }
        public static int FromIndex(int index)
        {
            return index + ModelYear.MinYear;
        }
        public static bool IsValid(int year)
        {
            return (year >= ModelYear.MinYear);
        }
        public static ModelYear NewModelYearFromIndex(int index)
        {
            return new ModelYear(index + ModelYear.MinYear);
        }
        public static ModelYear NewModelYearFromYear(int year)
        {
            return new ModelYear(year);
        }
        #endregion
        #region 
        public int Index { get; private set; }
        public int Year { get; private set; }
        #endregion
        #region 
        public const int MinYear = 2000;
        public static readonly ModelYear MinModelYear = new ModelYear(ModelYear.MinYear);
        #endregion
    }
}

