﻿#region << Using Directives >>
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
#endregion

namespace Volpe.Cafe.UI
{
    /// <summary>
    /// Provides a viewer capable of loading and displaying information from text files, including those formatted as RTF.
    /// </summary>
    public class RtfViewer : Form
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="RtfViewer"/> class.
        /// </summary>
        protected RtfViewer()
        {
            this.InitializeComponent();
        }

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true, if managed resources should be disposed; false, otherwise.</param>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        #endregion


        #region /*** Methods ***/

        #region /* Designer Generated Code */

        void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(RtfViewer));
            this.ux_rtf = new System.Windows.Forms.RichTextBox();
            this.SuspendLayout();
            // 
            // ux_rtf
            // 
            this.ux_rtf.BackColor = System.Drawing.Color.White;
            this.ux_rtf.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_rtf.Location = new System.Drawing.Point(0, 0);
            this.ux_rtf.Name = "ux_rtf";
            this.ux_rtf.ReadOnly = true;
            this.ux_rtf.Size = new System.Drawing.Size(624, 442);
            this.ux_rtf.TabIndex = 0;
            this.ux_rtf.Text = "";
            this.ux_rtf.KeyUp += new System.Windows.Forms.KeyEventHandler(this.RTF_KeyUp);
            // 
            // RtfViewer
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.ClientSize = new System.Drawing.Size(624, 442);
            this.Controls.Add(this.ux_rtf);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "RtfViewer";
            this.Text = "CAFE Model";
            this.ResumeLayout(false);

        }

        #endregion

        #region /* Show Methods */

        /// <summary>
        /// Displays the <see cref="RtfViewer"/> with the specified caption and prompt-options, loading the text to use for the
        /// body of the dialog from the specified <see cref="Stream"/>.
        /// </summary>
        /// <param name="caption">The text to display in the <see cref="RtfViewer"/>'s title bar.</param>
        /// <param name="stream">The stream whose text to load into the <see cref="RtfViewer"/>'s body.</param>
        public static void Show(string caption, Stream stream)
        {
            RtfViewer viewer = new RtfViewer();
            //
            if (viewer.LoadStream(caption, stream, RichTextBoxStreamType.RichText        )) { return; }
            if (viewer.LoadStream(caption, stream, RichTextBoxStreamType.RichNoOleObjs   )) { return; }
            if (viewer.LoadStream(caption, stream, RichTextBoxStreamType.PlainText       )) { return; }
            if (viewer.LoadStream(caption, stream, RichTextBoxStreamType.UnicodePlainText)) { return; }
            //
            viewer.ux_rtf.Text = "Stream could not be opened.";
            viewer.Text = caption;
            viewer.Show();
        }

        #endregion

        bool LoadStream(string caption, Stream stream, RichTextBoxStreamType fileType)
        {
            try
            {
                stream.Seek(0, SeekOrigin.Begin);
                this.ux_rtf.LoadFile(stream, fileType);
                if (fileType == RichTextBoxStreamType.PlainText)
                {
                    this.ux_rtf.Font = new Font("Courier New", 10);
                }
                this.Text = caption;
                this.Show();
                return true;
            }
            catch { return false; }
        }

        void RTF_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) { this.Close(); }
        }

        #endregion


        #region /*** Variables ***/

        #region /* UI Variables */

        RichTextBox ux_rtf;

        #endregion

        #endregion

    }
}
