﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Model
{
    /// <summary>
    /// Contains event data representing the progress of the compliance model.
    /// </summary>
    [Serializable]
    public class ModelingProgressEventArgs : EventArgs
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="ModelingProgressEventArgs"/> class using the specified parameters.
        /// </summary>
        /// <param name="progress">The progress of the compliance model when the event was generated.</param>
        public ModelingProgressEventArgs(IModelingProgress progress)
        {
            this._progress = progress;
        }

        #endregion


        #region /*** Methods ***/

        /// <summary>
        /// Returns the string representation of this <see cref="ModelingProgressEventArgs"/> instance.
        /// </summary>
        /// <returns>The string representation of the <see cref="ModelingProgressEventArgs"/> instance.</returns>
        public override string ToString()
        {
            return (this._progress == null) ? null : this._progress.ToString();
        }

        #endregion


        #region /*** Properties ***/

        /// <summary>Gets the progress of the compliance model when the event was generated.</summary>
        public IModelingProgress Progress { get { return this._progress; } }

        #endregion


        #region /*** Variables ***/

        IModelingProgress _progress;

        #endregion

    }
}
