﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Utils
{
    /// <summary>
    /// Provides basic information about the current system.
    /// </summary>
    public static class SystemInfo
    {

        #region /*** Constructors ***/

        static SystemInfo()
        {
            ProcessorCount = Environment.ProcessorCount;
            ProcessorArchitecture = Environment.GetEnvironmentVariable("PROCESSOR_ARCHITECTURE");
            ProcessorArchitecture_x86 = (ProcessorArchitecture == "x86" || ProcessorArchitecture == "X86");
            ProcessorArchitecture_x64 = (ProcessorArchitecture == "x64" || ProcessorArchitecture == "X64");

            MachineName = Environment.MachineName;
            OSVersion = Environment.OSVersion.ToString();
            CLRVersion = Environment.Version.ToString();
        }

        #endregion


        #region /*** Variables ***/

        /// <summary>Specifies the number of physical or logical processors (or CPU cores) in the system.</summary>
        public static readonly int ProcessorCount;
        /// <summary>Specifies the processor architecture as identified by the system.</summary>
        public static readonly string ProcessorArchitecture;
        /// <summary>Specifies whether the processor architecture is x86-32 as identified by the system.</summary>
        public static readonly bool ProcessorArchitecture_x86;
        /// <summary>Specifies whether the processor architecture is x86-64 as identified by the system.</summary>
        public static readonly bool ProcessorArchitecture_x64;

        /// <summary>Specifies the machine name of the current system.</summary>
        public static readonly string MachineName;
        /// <summary>Specifies the Operating System name and version for the current system.</summary>
        public static readonly string OSVersion;
        /// <summary>Specifies the Common Language Runtime version installed on the current system.</summary>
        public static readonly string CLRVersion;

        #endregion

    }
}
