using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public sealed class ComplianceProgress : ModelingProgress, IModelingProgress
    {
        #region 
        public ComplianceProgress(Scenario scen, ModelYear year, Manufacturer mfr)
            : this(scen, year, mfr, null)
        {
        }
        public ComplianceProgress(Scenario scen, ModelYear year, Manufacturer mfr, object additionalInfo)
            : base(scen, year, mfr, additionalInfo)
        {
        }
        #endregion
        #region 
        public override string ToString()
        {
            if (this._scen == null)
            {
                return "No progress information available.";
            }
            else
            {   
                string mfrProgress = null;
                if (this._mfr != null)
                {
                    ManufacturerModelingData mmd = this._mfr.ModelingData;
                    mfrProgress = "\n    Standard: "   + mmd.Standard.ToString(4) +
                                  "\n    CAFE: "       + mmd.CAFE    .ToString(4) +
                                  "\n    Credits: "    + mmd.Credits .ToString(0) +
                                  "\n    Fines: "      + mmd.Fines   .ToString(0) +
                                  "\n    Tech Costs: " + mmd.TechCost.ToString(0);
                }
                return (mfrProgress == null) ? base.ToString() : base.ToString() + mfrProgress;
            }
        }
        #endregion
    }
}

