#region << Using Directives >>
using System;
using System.Collections;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
using Volpe.Cafe.IO;
using Volpe.Cafe.Settings;
using TI = Volpe.Cafe.TechnologyIndexes;
using TA = Volpe.Cafe.Model.TechnologyApplicability;
#endregion
namespace Volpe.Cafe.Model
{
    [Serializable]
    public class LinearComplianceFinder
    {
        #region 
        public LinearComplianceFinder(Scenario scen, int startYear, ModelingSettings settings, LogWriter logWriter)
        {
            this._scen        = scen;
            this._startYear   = startYear;
            this._settings    = settings;
            this._logWriter   = logWriter;
            this._techs       = settings.Technologies;
            this._techGroups  = new TechnologyCollection[TA.TechTypeCount];
            for (int i = 0; i < TA.TechTypeCount; i++)
            {
                this._techGroups[i] = this._techs.GetTechnologyGroup(TA.TechTypes[i]);
            }
            this._cfCount   = 0;
            this._cfEff   = new ComplianceFinding();
            this._cfGroup = new ComplianceFinding();
            this._cfTmp   = new ComplianceFinding();
        }
        #endregion
        #region 
        public void Clear()
        {
            this._cfEff  .Clear(true);
            this._cfGroup.Clear(true);
            this._cfTmp  .Clear(true);
        }
        public ComplianceFinding GetNextFinding(ModelYear year, Industry[] modelYearData, int mfrIndex, bool lowCostFirst,
            bool allowSecondBest)
        {
            bool splitShared = this._settings.OperatingModes.SplitSharedEngsOrTrns;
            this._cfEff.Clear(false);
            for (int i = 0; i < TA.TechTypeCount; i++)
            {
                if (splitShared) 
                {
                    for (int j = 1; j <= 3; j++)
                    {
                        this.FindComplianceFindingByTechType(TA.TechTypes[i], this._techGroups[i], year, modelYearData, mfrIndex,
                            lowCostFirst, allowSecondBest, (RegulatoryClass)j);
                        ComplianceFinding eff = this.GetMostEfficient(this._cfEff, this._cfGroup);
                        if (eff != this._cfEff) { this._cfEff.CopyFrom(eff); }
                    }
                }
                else
                {
                    this.FindComplianceFindingByTechType(TA.TechTypes[i], this._techGroups[i], year, modelYearData, mfrIndex,
                        lowCostFirst, allowSecondBest, (RegulatoryClass)(-1));
                    ComplianceFinding eff = this.GetMostEfficient(this._cfEff, this._cfGroup);
                    if (eff != this._cfEff) { this._cfEff.CopyFrom(eff); }
                }
            }
            return (this._cfEff.IsEfficient || (this._cfEff.IsValid && allowSecondBest)) ? this._cfEff : null;
        }
        void FindComplianceFindingByTechType(TechnologyType techType, TechnologyCollection techGroup, ModelYear year,
            Industry[] modelYearData, int mfrIndex, bool lowCostFirst, bool allowSecondBest, RegulatoryClass regClass)
        {
            this._cfGroup.Clear(false);
            this._cfTmp.Initialize(this._scen, year, this._startYear, modelYearData, mfrIndex, this._settings, this._logWriter,
                techType, techGroup);
            int          yrIndex = year.Index;
            Manufacturer mfr     = modelYearData[yrIndex].Manufacturers[mfrIndex];
            IList componentList =
                (techType == TechnologyType.Engine)       ? (IList)mfr.Engines       :
                (techType == TechnologyType.Transmission) ? (IList)mfr.Transmissions :
                (techType == TechnologyType.Aerodynamics) ? (IList)mfr.NamePlates    : (IList)mfr.ModelYearVehicles;
            for (int i = 0, techCount = techGroup.Count; i < techCount; i++)
            {   
                this.ExamineTechnology(techType, techGroup, i, componentList, year, lowCostFirst, allowSecondBest, regClass);
                if (this._cfGroup.IsEfficient && lowCostFirst) { break; }
            } 
        }
        void ExamineTechnology(TechnologyType techType, TechnologyCollection techGroup, int techIdx, IList componentList,
            ModelYear year, bool lowCostFirst, bool allowSecondBest, RegulatoryClass regClass)
        {
            int t2Idx, t3Idx, t4Idx;    
            bool isMainBranch = this.FindTechBranches(techGroup, techGroup[techIdx].Index, out t2Idx, out t3Idx, out t4Idx);
            if (isMainBranch)
            {   
                for (int i = 0, componentCount = componentList.Count; i < componentCount; i++)
                {   
                    VehicleCollection vehs;
                    int vehIdx;     
                    this.GenerateComponentVehicles(componentList, i, techType, out vehs, out vehIdx);
                    if (vehs == null || vehs.Count == 0) { continue; }
                    this.ExamineComponent(techType, techGroup, techIdx, vehs, vehIdx, t2Idx, t3Idx, t4Idx, year, regClass);
                } 
            } 
        }
        void ExamineComponent(TechnologyType techType, TechnologyCollection techGroup, int techIdx, VehicleCollection vehs,
            int vehIdx, int t2Idx, int t3Idx, int t4Idx, ModelYear year, RegulatoryClass regClass)
        {
            this._cfTmp.ExamineFinding(techIdx, vehs, vehIdx, ref this._cfCount, regClass);
            ComplianceFinding eff = this.GetMostEfficient(this._cfGroup, this._cfTmp);
            if (eff != this._cfGroup) { this._cfGroup.CopyFrom(eff); }
            if (t2Idx != -1)
            {   
                this.ExamineComponent(techType, techGroup, t2Idx, vehs, vehIdx, t3Idx, t4Idx, -1, year, regClass);
            }
        }
        ComplianceFinding GetMostEfficient(ComplianceFinding cf1, ComplianceFinding cf2)
        {
            if      (!cf2.IsValid) { return cf1; }
            else if (!cf1.IsValid) { return cf2; }
            else
            {   
                if (cf2._efficiency <= cf1._efficiency) { cf1.LogFinding(); return cf2; }
                else                                    { cf2.LogFinding(); return cf1; }
            }
        }
        bool FindTechBranches(TechnologyCollection techGroup, int techIdx, out int t2Idx, out int t3Idx, out int t4Idx)
        {
            t2Idx = t3Idx = t4Idx = -1;
            switch (techIdx)
            {
                case TI.DVVLD:                              t2Idx = this.FindTechInGroup(techGroup, TI.CVVL ); break;
                case TI.DVVLO:                              t2Idx = this.FindTechInGroup(techGroup, TI.CDOHC); break;
                case TI.TRBDS: case TI.EGRB : case TI.DSLT: t2Idx = this.FindTechInGroup(techGroup, TI.DSLC ); break;
                case TI.NAUTO: case TI.DCTAM:               t2Idx = this.FindTechInGroup(techGroup, TI.CVT  ); break;
                case TI.PSHEV:                              t2Idx = this.FindTechInGroup(techGroup, TI.MHEV2);
                                                            t3Idx = this.FindTechInGroup(techGroup, TI.PHEV ); break;
                case TI.CVVL: case TI.CDOHC: case TI.DSLC: case TI.CVT: case TI.MHEV2: case TI.PHEV:
                    return false;
            }
            return true;
        }
        int FindTechInGroup(TechnologyCollection techGroup, int techIdx)
        {
            for (int i = 0, techCount = techGroup.Count; i < techCount; i++)
            {
                if (techGroup[i].Index == techIdx) { return i; }
            }
            return -1;
        }
        void GenerateComponentVehicles(IList componentList, int componentIndex, TechnologyType techType,
            out VehicleCollection vehs, out int vehIdx)
        {
            object component = componentList[componentIndex];
            vehIdx = -1;
            if      (techType == TechnologyType.Engine      ) { vehs = ((Engine      )component).ModelYearVehicles; }
            else if (techType == TechnologyType.Transmission) { vehs = ((Transmission)component).ModelYearVehicles; }
            else if (techType == TechnologyType.Aerodynamics) { vehs = ((NamePlate   )component).ModelYearVehicles; }
            else
            {   
                vehs   = (VehicleCollection)componentList;
                vehIdx = componentIndex;
            }
        }
        void Swap(Vehicle[] arr, int i, int j) { Vehicle tmp = arr[i]; arr[i] = arr[j]; arr[j] = tmp; }
        void Swap(ulong  [] arr, int i, int j) { ulong   tmp = arr[i]; arr[i] = arr[j]; arr[j] = tmp; }
        void Swap(int    [] arr, int i, int j) { int     tmp = arr[i]; arr[i] = arr[j]; arr[j] = tmp; }
        #endregion
        #region 
        public int CfCount { get { return this._cfCount; } }
        #endregion
        #region 
        Scenario         _scen;
        int              _startYear;
        ModelingSettings _settings;
        LogWriter        _logWriter;
        TechnologyCollection   _techs;
        TechnologyCollection[] _techGroups;
        int _cfCount;
        ComplianceFinding _cfEff;
        ComplianceFinding _cfGroup;
        ComplianceFinding _cfTmp;
        #endregion
    }
}

