#region << Using Directives >>
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Volpe.Cafe.Model;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Ui.Panels;
#endregion
namespace Volpe.Cafe.Ui
{
    public class ManageInput : System.Windows.Forms.Form
    {
        #region 
        public ManageInput(Session session)
        {
            this.InitializeComponent();
            this._session     = session;
            this._inputSaving = false;
            this.RefreshInputPanel();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_statusTextBox = new System.Windows.Forms.RichTextBox();
            this.ux_close = new System.Windows.Forms.Button();
            this.ux_save = new System.Windows.Forms.Button();
            this.ux_inputPanel = new Volpe.Cafe.Ui.Panels.InputPanel();
            this.SuspendLayout();
            this.ux_statusTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_statusTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_statusTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_statusTextBox.Enabled = false;
            this.ux_statusTextBox.ForeColor = System.Drawing.Color.Black;
            this.ux_statusTextBox.Location = new System.Drawing.Point(8, 312);
            this.ux_statusTextBox.Name = "ux_statusTextBox";
            this.ux_statusTextBox.ReadOnly = true;
            this.ux_statusTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_statusTextBox.Size = new System.Drawing.Size(264, 56);
            this.ux_statusTextBox.TabIndex = 1;
            this.ux_statusTextBox.TabStop = false;
            this.ux_statusTextBox.Text = "";
            this.ux_close.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_close.BackColor = System.Drawing.SystemColors.Control;
            this.ux_close.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.ux_close.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_close.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_close.ForeColor = System.Drawing.Color.Red;
            this.ux_close.Location = new System.Drawing.Point(336, 312);
            this.ux_close.Name = "ux_close";
            this.ux_close.Size = new System.Drawing.Size(48, 48);
            this.ux_close.TabIndex = 3;
            this.ux_close.Text = "Close";
            this.ux_close.Click += new System.EventHandler(this.Close_Click);
            this.ux_save.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_save.BackColor = System.Drawing.SystemColors.Control;
            this.ux_save.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_save.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_save.ForeColor = System.Drawing.Color.Green;
            this.ux_save.Location = new System.Drawing.Point(280, 312);
            this.ux_save.Name = "ux_save";
            this.ux_save.Size = new System.Drawing.Size(48, 48);
            this.ux_save.TabIndex = 2;
            this.ux_save.Text = "Save";
            this.ux_save.Click += new System.EventHandler(this.Save_Click);
            this.ux_inputPanel.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_inputPanel.AutoScroll = true;
            this.ux_inputPanel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_inputPanel.Location = new System.Drawing.Point(0, 0);
            this.ux_inputPanel.Name = "ux_inputPanel";
            this.ux_inputPanel.Size = new System.Drawing.Size(394, 312);
            this.ux_inputPanel.TabIndex = 0;
            this.AcceptButton = this.ux_save;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.CancelButton = this.ux_close;
            this.ClientSize = new System.Drawing.Size(394, 375);
            this.Controls.Add(this.ux_inputPanel);
            this.Controls.Add(this.ux_close);
            this.Controls.Add(this.ux_save);
            this.Controls.Add(this.ux_statusTextBox);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ManageInput";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Manage Input";
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            this.ux_inputPanel.ParsingChanged += new EventHandler(this.InputPanel_ParsingChanged);
            this.ux_inputPanel.Messages.MessagesChanged += new EventHandler(this.Messages_MessagesChanged);
            this.ux_inputPanel.SetInitialState(this._session.Settings.InputSettings);
            Application.Idle += new EventHandler(this.ManageInput_Idle);
            this.ux_save.Visible = !this._session.Running;
        }
        protected override void OnClosing(CancelEventArgs e)
        {
            if (this.ux_inputPanel.Parsing || this._inputSaving) { e.Cancel = true; return; }
            this.ux_inputPanel.ParsingChanged -= new EventHandler(this.InputPanel_ParsingChanged);
            this.ux_inputPanel.Messages.MessagesChanged -= new EventHandler(this.Messages_MessagesChanged);
            Application.Idle -= new EventHandler(this.ManageInput_Idle);
            base.OnClosing(e);
        }
        #endregion
        void ManageInput_Idle(object sender, EventArgs e)
        {
            this.RefreshInputPanel();
            this.ux_save.Enabled = !this._session.Running && this.ux_inputPanel.SettingsChanged;
        }
        void Messages_MessagesChanged(object sender, EventArgs e)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EventHandler(this.Messages_MessagesChanged));
            }
            else
            {
                this.ux_statusTextBox.Text      = this.ux_inputPanel.Messages.ToString();
                this.ux_statusTextBox.ForeColor = Color.Red;
                this.ux_statusTextBox.Enabled   = this.ux_statusTextBox.Text != "";
            }
        }
        void InputPanel_ParsingChanged(object sender, EventArgs e)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EventHandler(this.InputPanel_ParsingChanged));
            }
            else
            {
                bool enabled = !this.ux_inputPanel.Parsing;
                this.ux_save .Enabled = enabled;
                this.ux_close.Enabled = enabled;
                this.ControlBox       = enabled;
                if (this._inputSaving && enabled)
                {   
                    InputPanel pnl = this.ux_inputPanel;
                    if (pnl.MarketData     != null) { this._session.Data                    = pnl.MarketData; }
                    if (pnl.Technologies   != null) { this._session.Settings.Technologies   = pnl.Technologies.Data; }
                    if (pnl.Parameters     != null) { this._session.Settings.Parameters     = pnl.Parameters; }
                    if (pnl.EmissionsRates != null) { this._session.Settings.EmissionsRates = pnl.EmissionsRates; }
                    if (pnl.Scenarios      != null) { this._session.Settings.Scenarios      = pnl.Scenarios.Data; }
                    this._session.Settings.InputSettings = pnl.InputSettings;
                    this._session.SaveRequired = true;
                    this._inputSaving = false;
                }
            }
        }
        void Save_Click(object sender, System.EventArgs e)
        {
            this._inputSaving = true;
            this.ux_inputPanel.SaveChanges();
        }
        void Close_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        void RefreshInputPanel()
        {
            ICompliance selCompliance = this._session.Compliance;
            if (selCompliance != null)
            {
                this.ux_inputPanel.ShowMarketData   = selCompliance.RequiresMarketData;
                this.ux_inputPanel.ShowTechnologies = selCompliance.RequiresTechnologies;
                this.ux_inputPanel.ShowParameters   = selCompliance.RequiresParameters;
                this.ux_inputPanel.ShowEmissions    = selCompliance.RequiresEmissions;
                this.ux_inputPanel.ShowScenarios    = selCompliance.RequiresScenarios;
            }
        }
        #endregion
        #region 
        #region 
        Volpe.Cafe.Ui.Panels.InputPanel ux_inputPanel;
        System.Windows.Forms.RichTextBox ux_statusTextBox;
        System.Windows.Forms.Button ux_close;
        System.Windows.Forms.Button ux_save;
        #endregion
        Session _session;
        bool    _inputSaving;   
        #endregion
    }
}

