using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe.Data;
using Volpe.Cafe.IO;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
	public class InputPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
	{
        #region 
        public event EventHandler ParsingChanged;
        #endregion
        #region 
		public InputPanel()
		{
			this.InitializeComponent();
            this.PostInitialize();
        }
		protected override void Dispose(bool disposing)
		{
			base.Dispose(disposing);
		}
        #endregion
        #region 
		#region 
		void InitializeComponent()
		{
            this.ux_encryptionLabel = new System.Windows.Forms.Label();
            this.ux_encryptionPanel = new System.Windows.Forms.Panel();
            this.ux_inputPasswordLabel3 = new System.Windows.Forms.Label();
            this.ux_inputPasswordLabel2 = new System.Windows.Forms.Label();
            this.ux_inputPasswordVerfiy = new System.Windows.Forms.TextBox();
            this.ux_inputPasswordLabel1 = new System.Windows.Forms.Label();
            this.ux_inputPassword = new System.Windows.Forms.TextBox();
            this.ux_encryptInput = new System.Windows.Forms.RadioButton();
            this.ux_doNotEncryptInput = new System.Windows.Forms.RadioButton();
            this.ux_inputFilesLabel = new System.Windows.Forms.Label();
            this.ux_inputFilesPanel = new System.Windows.Forms.Panel();
            this.ux_reloadAllFromDisk = new System.Windows.Forms.CheckBox();
            this.ux_scenariosFileBrowse = new System.Windows.Forms.Button();
            this.ux_scenariosFile = new System.Windows.Forms.TextBox();
            this.ux_emissionsRatesFileBrowse = new System.Windows.Forms.Button();
            this.ux_emissionsRatesFile = new System.Windows.Forms.TextBox();
            this.ux_parametersFileBrowse = new System.Windows.Forms.Button();
            this.ux_parametersFile = new System.Windows.Forms.TextBox();
            this.ux_technologiesFileBrowse = new System.Windows.Forms.Button();
            this.ux_technologiesFile = new System.Windows.Forms.TextBox();
            this.ux_marketDataFileBrowse = new System.Windows.Forms.Button();
            this.ux_marketDataFile = new System.Windows.Forms.TextBox();
            this.ux_marketDataFileOutdatedLabel = new System.Windows.Forms.Label();
            this.ux_scenariosFileOutdatedLabel = new System.Windows.Forms.Label();
            this.ux_emissionsRatesFileOutdatedLabel = new System.Windows.Forms.Label();
            this.ux_parametersFileOutdatedLabel = new System.Windows.Forms.Label();
            this.ux_technologiesFileOutdatedLabel = new System.Windows.Forms.Label();
            this.ux_technologiesFileLabel = new System.Windows.Forms.Label();
            this.ux_parametersFileLabel = new System.Windows.Forms.Label();
            this.ux_emissionsRatesFileLabel = new System.Windows.Forms.Label();
            this.ux_scenariosFileLabel = new System.Windows.Forms.Label();
            this.ux_marketDataFileLabel = new System.Windows.Forms.Label();
            this.ux_encryptionPanel.SuspendLayout();
            this.ux_inputFilesPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_encryptionLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_encryptionLabel.Name = "ux_encryptionLabel";
            this.ux_encryptionLabel.Size = new System.Drawing.Size(240, 16);
            this.ux_encryptionLabel.TabIndex = 0;
            this.ux_encryptionLabel.Text = "Are any of the input files password protected?";
            this.ux_encryptionPanel.Controls.Add(this.ux_inputPasswordLabel3);
            this.ux_encryptionPanel.Controls.Add(this.ux_inputPasswordLabel2);
            this.ux_encryptionPanel.Controls.Add(this.ux_inputPasswordVerfiy);
            this.ux_encryptionPanel.Controls.Add(this.ux_inputPasswordLabel1);
            this.ux_encryptionPanel.Controls.Add(this.ux_inputPassword);
            this.ux_encryptionPanel.Controls.Add(this.ux_encryptInput);
            this.ux_encryptionPanel.Controls.Add(this.ux_doNotEncryptInput);
            this.ux_encryptionPanel.Location = new System.Drawing.Point(8, 16);
            this.ux_encryptionPanel.Name = "ux_encryptionPanel";
            this.ux_encryptionPanel.Size = new System.Drawing.Size(368, 80);
            this.ux_encryptionPanel.TabIndex = 1;
            this.ux_inputPasswordLabel3.Enabled = false;
            this.ux_inputPasswordLabel3.ForeColor = System.Drawing.Color.DarkRed;
            this.ux_inputPasswordLabel3.Location = new System.Drawing.Point(24, 64);
            this.ux_inputPasswordLabel3.Name = "ux_inputPasswordLabel3";
            this.ux_inputPasswordLabel3.Size = new System.Drawing.Size(336, 16);
            this.ux_inputPasswordLabel3.TabIndex = 7;
            this.ux_inputPasswordLabel3.Text = "Note:  The same password will be used for opening all input files.";
            this.ux_inputPasswordLabel2.Enabled = false;
            this.ux_inputPasswordLabel2.Location = new System.Drawing.Point(360, 44);
            this.ux_inputPasswordLabel2.Name = "ux_inputPasswordLabel2";
            this.ux_inputPasswordLabel2.Size = new System.Drawing.Size(8, 16);
            this.ux_inputPasswordLabel2.TabIndex = 5;
            this.ux_inputPasswordLabel2.Text = ")";
            this.ux_inputPasswordVerfiy.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_inputPasswordVerfiy.Enabled = false;
            this.ux_inputPasswordVerfiy.Location = new System.Drawing.Point(238, 40);
            this.ux_inputPasswordVerfiy.Name = "ux_inputPasswordVerfiy";
            this.ux_inputPasswordVerfiy.PasswordChar = '*';
            this.ux_inputPasswordVerfiy.Size = new System.Drawing.Size(120, 21);
            this.ux_inputPasswordVerfiy.TabIndex = 4;
            this.ux_inputPasswordVerfiy.Text = "";
            this.ux_inputPasswordLabel1.Enabled = false;
            this.ux_inputPasswordLabel1.Location = new System.Drawing.Point(148, 44);
            this.ux_inputPasswordLabel1.Name = "ux_inputPasswordLabel1";
            this.ux_inputPasswordLabel1.Size = new System.Drawing.Size(96, 16);
            this.ux_inputPasswordLabel1.TabIndex = 3;
            this.ux_inputPasswordLabel1.Text = "(verify password:";
            this.ux_inputPassword.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_inputPassword.Enabled = false;
            this.ux_inputPassword.Location = new System.Drawing.Point(24, 40);
            this.ux_inputPassword.Name = "ux_inputPassword";
            this.ux_inputPassword.PasswordChar = '*';
            this.ux_inputPassword.Size = new System.Drawing.Size(120, 21);
            this.ux_inputPassword.TabIndex = 2;
            this.ux_inputPassword.Text = "";
            this.ux_encryptInput.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_encryptInput.Location = new System.Drawing.Point(8, 24);
            this.ux_encryptInput.Name = "ux_encryptInput";
            this.ux_encryptInput.Size = new System.Drawing.Size(320, 16);
            this.ux_encryptInput.TabIndex = 1;
            this.ux_encryptInput.Text = "The input files are protected using the specified password:";
            this.ux_doNotEncryptInput.Checked = true;
            this.ux_doNotEncryptInput.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_doNotEncryptInput.Location = new System.Drawing.Point(8, 8);
            this.ux_doNotEncryptInput.Name = "ux_doNotEncryptInput";
            this.ux_doNotEncryptInput.Size = new System.Drawing.Size(272, 16);
            this.ux_doNotEncryptInput.TabIndex = 0;
            this.ux_doNotEncryptInput.TabStop = true;
            this.ux_doNotEncryptInput.Text = "The input files do not require a password to open,";
            this.ux_inputFilesLabel.Location = new System.Drawing.Point(8, 100);
            this.ux_inputFilesLabel.Name = "ux_inputFilesLabel";
            this.ux_inputFilesLabel.Size = new System.Drawing.Size(344, 16);
            this.ux_inputFilesLabel.TabIndex = 2;
            this.ux_inputFilesLabel.Text = "Please specify the input files you would like to use with the model:";
            this.ux_inputFilesPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_inputFilesPanel.Controls.Add(this.ux_reloadAllFromDisk);
            this.ux_inputFilesPanel.Controls.Add(this.ux_scenariosFileBrowse);
            this.ux_inputFilesPanel.Controls.Add(this.ux_scenariosFile);
            this.ux_inputFilesPanel.Controls.Add(this.ux_emissionsRatesFileBrowse);
            this.ux_inputFilesPanel.Controls.Add(this.ux_emissionsRatesFile);
            this.ux_inputFilesPanel.Controls.Add(this.ux_parametersFileBrowse);
            this.ux_inputFilesPanel.Controls.Add(this.ux_parametersFile);
            this.ux_inputFilesPanel.Controls.Add(this.ux_technologiesFileBrowse);
            this.ux_inputFilesPanel.Controls.Add(this.ux_technologiesFile);
            this.ux_inputFilesPanel.Controls.Add(this.ux_marketDataFileBrowse);
            this.ux_inputFilesPanel.Controls.Add(this.ux_marketDataFile);
            this.ux_inputFilesPanel.Controls.Add(this.ux_marketDataFileOutdatedLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_scenariosFileOutdatedLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_emissionsRatesFileOutdatedLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_parametersFileOutdatedLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_technologiesFileOutdatedLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_technologiesFileLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_parametersFileLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_emissionsRatesFileLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_scenariosFileLabel);
            this.ux_inputFilesPanel.Controls.Add(this.ux_marketDataFileLabel);
            this.ux_inputFilesPanel.Location = new System.Drawing.Point(8, 108);
            this.ux_inputFilesPanel.Name = "ux_inputFilesPanel";
            this.ux_inputFilesPanel.Size = new System.Drawing.Size(384, 232);
            this.ux_inputFilesPanel.TabIndex = 3;
            this.ux_reloadAllFromDisk.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reloadAllFromDisk.Location = new System.Drawing.Point(8, 208);
            this.ux_reloadAllFromDisk.Name = "ux_reloadAllFromDisk";
            this.ux_reloadAllFromDisk.Size = new System.Drawing.Size(192, 16);
            this.ux_reloadAllFromDisk.TabIndex = 15;
            this.ux_reloadAllFromDisk.Text = "Reload all selected files from disk.";
            this.ux_scenariosFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_scenariosFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_scenariosFileBrowse.Location = new System.Drawing.Point(304, 184);
            this.ux_scenariosFileBrowse.Name = "ux_scenariosFileBrowse";
            this.ux_scenariosFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_scenariosFileBrowse.TabIndex = 14;
            this.ux_scenariosFileBrowse.Text = "Browse";
            this.ux_scenariosFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_scenariosFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_scenariosFile.Location = new System.Drawing.Point(8, 184);
            this.ux_scenariosFile.Name = "ux_scenariosFile";
            this.ux_scenariosFile.Size = new System.Drawing.Size(295, 21);
            this.ux_scenariosFile.TabIndex = 13;
            this.ux_scenariosFile.Text = "";
            this.ux_emissionsRatesFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_emissionsRatesFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_emissionsRatesFileBrowse.Location = new System.Drawing.Point(304, 144);
            this.ux_emissionsRatesFileBrowse.Name = "ux_emissionsRatesFileBrowse";
            this.ux_emissionsRatesFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_emissionsRatesFileBrowse.TabIndex = 11;
            this.ux_emissionsRatesFileBrowse.Text = "Browse";
            this.ux_emissionsRatesFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_emissionsRatesFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_emissionsRatesFile.Location = new System.Drawing.Point(8, 144);
            this.ux_emissionsRatesFile.Name = "ux_emissionsRatesFile";
            this.ux_emissionsRatesFile.Size = new System.Drawing.Size(295, 21);
            this.ux_emissionsRatesFile.TabIndex = 10;
            this.ux_emissionsRatesFile.Text = "";
            this.ux_parametersFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_parametersFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_parametersFileBrowse.Location = new System.Drawing.Point(304, 104);
            this.ux_parametersFileBrowse.Name = "ux_parametersFileBrowse";
            this.ux_parametersFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_parametersFileBrowse.TabIndex = 8;
            this.ux_parametersFileBrowse.Text = "Browse";
            this.ux_parametersFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_parametersFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_parametersFile.Location = new System.Drawing.Point(8, 104);
            this.ux_parametersFile.Name = "ux_parametersFile";
            this.ux_parametersFile.Size = new System.Drawing.Size(295, 21);
            this.ux_parametersFile.TabIndex = 7;
            this.ux_parametersFile.Text = "";
            this.ux_technologiesFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_technologiesFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_technologiesFileBrowse.Location = new System.Drawing.Point(304, 64);
            this.ux_technologiesFileBrowse.Name = "ux_technologiesFileBrowse";
            this.ux_technologiesFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_technologiesFileBrowse.TabIndex = 5;
            this.ux_technologiesFileBrowse.Text = "Browse";
            this.ux_technologiesFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_technologiesFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_technologiesFile.Location = new System.Drawing.Point(8, 64);
            this.ux_technologiesFile.Name = "ux_technologiesFile";
            this.ux_technologiesFile.Size = new System.Drawing.Size(295, 21);
            this.ux_technologiesFile.TabIndex = 4;
            this.ux_technologiesFile.Text = "";
            this.ux_marketDataFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_marketDataFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_marketDataFileBrowse.Location = new System.Drawing.Point(304, 24);
            this.ux_marketDataFileBrowse.Name = "ux_marketDataFileBrowse";
            this.ux_marketDataFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_marketDataFileBrowse.TabIndex = 2;
            this.ux_marketDataFileBrowse.Text = "Browse";
            this.ux_marketDataFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_marketDataFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_marketDataFile.Location = new System.Drawing.Point(8, 24);
            this.ux_marketDataFile.Name = "ux_marketDataFile";
            this.ux_marketDataFile.Size = new System.Drawing.Size(295, 21);
            this.ux_marketDataFile.TabIndex = 1;
            this.ux_marketDataFile.Text = "";
            this.ux_marketDataFileOutdatedLabel.AutoSize = true;
            this.ux_marketDataFileOutdatedLabel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_marketDataFileOutdatedLabel.ForeColor = System.Drawing.Color.Gray;
            this.ux_marketDataFileOutdatedLabel.Location = new System.Drawing.Point(96, 8);
            this.ux_marketDataFileOutdatedLabel.Name = "ux_marketDataFileOutdatedLabel";
            this.ux_marketDataFileOutdatedLabel.Size = new System.Drawing.Size(246, 17);
            this.ux_marketDataFileOutdatedLabel.TabIndex = 16;
            this.ux_marketDataFileOutdatedLabel.Text = "(The file on disk is newer than data in memory.)";
            this.ux_marketDataFileOutdatedLabel.Visible = false;
            this.ux_scenariosFileOutdatedLabel.AutoSize = true;
            this.ux_scenariosFileOutdatedLabel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_scenariosFileOutdatedLabel.ForeColor = System.Drawing.Color.Gray;
            this.ux_scenariosFileOutdatedLabel.Location = new System.Drawing.Point(80, 168);
            this.ux_scenariosFileOutdatedLabel.Name = "ux_scenariosFileOutdatedLabel";
            this.ux_scenariosFileOutdatedLabel.Size = new System.Drawing.Size(246, 17);
            this.ux_scenariosFileOutdatedLabel.TabIndex = 20;
            this.ux_scenariosFileOutdatedLabel.Text = "(The file on disk is newer than data in memory.)";
            this.ux_scenariosFileOutdatedLabel.Visible = false;
            this.ux_emissionsRatesFileOutdatedLabel.AutoSize = true;
            this.ux_emissionsRatesFileOutdatedLabel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_emissionsRatesFileOutdatedLabel.ForeColor = System.Drawing.Color.Gray;
            this.ux_emissionsRatesFileOutdatedLabel.Location = new System.Drawing.Point(112, 128);
            this.ux_emissionsRatesFileOutdatedLabel.Name = "ux_emissionsRatesFileOutdatedLabel";
            this.ux_emissionsRatesFileOutdatedLabel.Size = new System.Drawing.Size(246, 17);
            this.ux_emissionsRatesFileOutdatedLabel.TabIndex = 19;
            this.ux_emissionsRatesFileOutdatedLabel.Text = "(The file on disk is newer than data in memory.)";
            this.ux_emissionsRatesFileOutdatedLabel.Visible = false;
            this.ux_parametersFileOutdatedLabel.AutoSize = true;
            this.ux_parametersFileOutdatedLabel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_parametersFileOutdatedLabel.ForeColor = System.Drawing.Color.Gray;
            this.ux_parametersFileOutdatedLabel.Location = new System.Drawing.Point(88, 88);
            this.ux_parametersFileOutdatedLabel.Name = "ux_parametersFileOutdatedLabel";
            this.ux_parametersFileOutdatedLabel.Size = new System.Drawing.Size(246, 17);
            this.ux_parametersFileOutdatedLabel.TabIndex = 18;
            this.ux_parametersFileOutdatedLabel.Text = "(The file on disk is newer than data in memory.)";
            this.ux_parametersFileOutdatedLabel.Visible = false;
            this.ux_technologiesFileOutdatedLabel.AutoSize = true;
            this.ux_technologiesFileOutdatedLabel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_technologiesFileOutdatedLabel.ForeColor = System.Drawing.Color.Gray;
            this.ux_technologiesFileOutdatedLabel.Location = new System.Drawing.Point(96, 48);
            this.ux_technologiesFileOutdatedLabel.Name = "ux_technologiesFileOutdatedLabel";
            this.ux_technologiesFileOutdatedLabel.Size = new System.Drawing.Size(246, 17);
            this.ux_technologiesFileOutdatedLabel.TabIndex = 17;
            this.ux_technologiesFileOutdatedLabel.Text = "(The file on disk is newer than data in memory.)";
            this.ux_technologiesFileOutdatedLabel.Visible = false;
            this.ux_technologiesFileLabel.AutoSize = true;
            this.ux_technologiesFileLabel.Location = new System.Drawing.Point(8, 48);
            this.ux_technologiesFileLabel.Name = "ux_technologiesFileLabel";
            this.ux_technologiesFileLabel.Size = new System.Drawing.Size(92, 17);
            this.ux_technologiesFileLabel.TabIndex = 3;
            this.ux_technologiesFileLabel.Text = "Technologies file:";
            this.ux_parametersFileLabel.AutoSize = true;
            this.ux_parametersFileLabel.Location = new System.Drawing.Point(8, 88);
            this.ux_parametersFileLabel.Name = "ux_parametersFileLabel";
            this.ux_parametersFileLabel.Size = new System.Drawing.Size(83, 17);
            this.ux_parametersFileLabel.TabIndex = 6;
            this.ux_parametersFileLabel.Text = "Parameters file:";
            this.ux_emissionsRatesFileLabel.AutoSize = true;
            this.ux_emissionsRatesFileLabel.Location = new System.Drawing.Point(8, 128);
            this.ux_emissionsRatesFileLabel.Name = "ux_emissionsRatesFileLabel";
            this.ux_emissionsRatesFileLabel.Size = new System.Drawing.Size(107, 17);
            this.ux_emissionsRatesFileLabel.TabIndex = 9;
            this.ux_emissionsRatesFileLabel.Text = "Emissions-Rates file:";
            this.ux_scenariosFileLabel.AutoSize = true;
            this.ux_scenariosFileLabel.Location = new System.Drawing.Point(8, 168);
            this.ux_scenariosFileLabel.Name = "ux_scenariosFileLabel";
            this.ux_scenariosFileLabel.Size = new System.Drawing.Size(74, 17);
            this.ux_scenariosFileLabel.TabIndex = 12;
            this.ux_scenariosFileLabel.Text = "Scenarios file:";
            this.ux_marketDataFileLabel.AutoSize = true;
            this.ux_marketDataFileLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_marketDataFileLabel.Name = "ux_marketDataFileLabel";
            this.ux_marketDataFileLabel.Size = new System.Drawing.Size(88, 17);
            this.ux_marketDataFileLabel.TabIndex = 0;
            this.ux_marketDataFileLabel.Text = "Market-Data file:";
            this.Controls.Add(this.ux_inputFilesLabel);
            this.Controls.Add(this.ux_encryptionLabel);
            this.Controls.Add(this.ux_encryptionPanel);
            this.Controls.Add(this.ux_inputFilesPanel);
            this.Name = "InputPanel";
            this.Size = new System.Drawing.Size(400, 352);
            this.ux_encryptionPanel.ResumeLayout(false);
            this.ux_inputFilesPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
		#endregion
        #region 
        protected virtual void OnParsingChanged(EventArgs e)
        {
            if (this.ParsingChanged != null)
            {
                this.ParsingChanged(this, e);
            }
        }
        #endregion
        void PostInitialize()
        {
            this.InitializeInputPanelDragDrop();
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.DeInitializeCheckChangesDetector(this.ux_reloadAllFromDisk);
            this.ux_encryptInput            .CheckedChanged += new EventHandler(this.EncryptInput_CheckedChanged);
            this.ux_inputPassword           .TextChanged    += new EventHandler(this.InputPassword_TextChanged);
            this.ux_inputPasswordVerfiy     .TextChanged    += new EventHandler(this.InputPassword_TextChanged);
            this.ux_inputPassword           .EnabledChanged += new EventHandler(this.InputPassword_EnabledChanged);
            this.ux_inputPasswordVerfiy     .EnabledChanged += new EventHandler(this.InputPassword_EnabledChanged);
            this.ux_marketDataFile          .TextChanged    += new EventHandler(this.InputFile_TextChanged);
            this.ux_technologiesFile        .TextChanged    += new EventHandler(this.InputFile_TextChanged);
            this.ux_parametersFile          .TextChanged    += new EventHandler(this.InputFile_TextChanged);
            this.ux_emissionsRatesFile      .TextChanged    += new EventHandler(this.InputFile_TextChanged);
            this.ux_scenariosFile           .TextChanged    += new EventHandler(this.InputFile_TextChanged);
            this.ux_marketDataFile          .VisibleChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_technologiesFile        .VisibleChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_parametersFile          .VisibleChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_emissionsRatesFile      .VisibleChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_scenariosFile           .VisibleChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_marketDataFile          .EnabledChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_technologiesFile        .EnabledChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_parametersFile          .EnabledChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_emissionsRatesFile      .EnabledChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_scenariosFile           .EnabledChanged += new EventHandler(this.InputFile_VisibleOrEnabledChanged);
            this.ux_marketDataFileBrowse    .Click          += new EventHandler(this.InputFileBrowse_Click);
            this.ux_technologiesFileBrowse  .Click          += new EventHandler(this.InputFileBrowse_Click);
            this.ux_parametersFileBrowse    .Click          += new EventHandler(this.InputFileBrowse_Click);
            this.ux_emissionsRatesFileBrowse.Click          += new EventHandler(this.InputFileBrowse_Click);
            this.ux_scenariosFileBrowse     .Click          += new EventHandler(this.InputFileBrowse_Click);
            this.ux_marketDataFile    .Text = " ";
            this.ux_technologiesFile  .Text = " ";
            this.ux_parametersFile    .Text = " ";
            this.ux_emissionsRatesFile.Text = " ";
            this.ux_scenariosFile     .Text = " ";
            this._data          = new object[FileCount];
            this._verifiedFiles = new bool  [FileCount];
            this._visibleFiles  = new bool  [FileCount];
            for (int i = 0; i < FileCount; i++) { this._visibleFiles[i] = true; }
            this._parsing = 0;
            this._saveThread = null;
        }
        void EncryptInput_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_encryptInput.Checked;
            this.ux_inputPassword      .Enabled = enabled;
            this.ux_inputPasswordVerfiy.Enabled = enabled;
            this.ux_inputPasswordLabel1.Enabled = enabled;
            this.ux_inputPasswordLabel2.Enabled = enabled;
            this.ux_inputPasswordLabel3.Enabled = enabled;
        }
        void InputPassword_TextChanged(object sender, EventArgs e)
        {
            string pw1 = this.ux_inputPassword.Text;
            string pw2 = this.ux_inputPasswordVerfiy.Text;
            string errMessage = string.Empty;
            if (pw1 == "" && pw2 == "")
            {
                errMessage = "Please enter an input password and verify.";
            }
            else if (pw1 == pw2)
            {
                bool  pwChanged = pw1 != this._inputSettings.InputPassword;
                Color foreColor = (pwChanged && this._visualTracking) ? this._visualTrackingColor : Control.DefaultForeColor;
                this.ux_inputPassword      .ForeColor = foreColor;
                this.ux_inputPassword      .BackColor = Color.Empty;
                this.ux_inputPasswordVerfiy.ForeColor = foreColor;
                this.ux_inputPasswordVerfiy.BackColor = Color.Empty;
                this._messages.RemoveMessage(this.ux_inputPassword);
            }
            else
            {
                errMessage = "The specified input and \"verify\" passwords do not match.";
            }
            if (errMessage != string.Empty)
            {
                this._messages.AddMessage(errMessage, Color.Red, this.ux_inputPassword);
                this.ux_inputPassword      .BackColor = Color.Honeydew;
                this.ux_inputPassword      .ForeColor = Color.Red;
                this.ux_inputPasswordVerfiy.BackColor = Color.Honeydew;
                this.ux_inputPasswordVerfiy.ForeColor = Color.Red;
            }
        }
        void InputPassword_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.InputPassword_TextChanged(sender, e); }
            else
            {
                this._messages.RemoveMessage(this.ux_inputPassword);
                this.ux_inputPassword      .BackColor = Color.Empty;
                this.ux_inputPasswordVerfiy.BackColor = Color.Empty;
            }
        }
        void InputFile_TextChanged(object sender, EventArgs e)
        {
            TextBox tb             = (TextBox)sender;
            bool    isMarketData   = (tb == this.ux_marketDataFile);
            bool    isTechnologies = (tb == this.ux_technologiesFile);
            bool    isParameters   = (tb == this.ux_parametersFile);
            bool    isEmissions    = (tb == this.ux_emissionsRatesFile);
            bool    isScenarios    = (tb == this.ux_scenariosFile);
            int     fileID         =
                (isMarketData  ) ? MarketDataID :
                (isTechnologies) ? TechnologiesID :
                (isParameters  ) ? ParametersID :
                (isEmissions   ) ? EmissionsID :
                (isScenarios   ) ? ScenariosID : -1;
            Label   outdatedLbl    =
                (isMarketData  ) ? this.ux_marketDataFileOutdatedLabel :
                (isTechnologies) ? this.ux_technologiesFileOutdatedLabel :
                (isParameters  ) ? this.ux_parametersFileOutdatedLabel :
                (isEmissions   ) ? this.ux_emissionsRatesFileOutdatedLabel :
                (isScenarios   ) ? this.ux_scenariosFileOutdatedLabel : null;
            string filePath = tb.Text.Trim();
            if (filePath != string.Empty && File.Exists(filePath))
            {
                bool inputFilePathChanged =
                    (isMarketData   && !this.CompareFilePaths(this._inputSettings.MarketDataFile    , filePath)) ||
                    (isTechnologies && !this.CompareFilePaths(this._inputSettings.TechnologiesFile  , filePath)) ||
                    (isParameters   && !this.CompareFilePaths(this._inputSettings.ParametersFile    , filePath)) ||
                    (isEmissions    && !this.CompareFilePaths(this._inputSettings.EmissionsRatesFile, filePath)) ||
                    (isScenarios    && !this.CompareFilePaths(this._inputSettings.ScenariosFile     , filePath));
                tb.ForeColor = (this._visualTracking && inputFilePathChanged) ? this._visualTrackingColor : Control.DefaultForeColor;
                tb.BackColor = Color.Empty;
                this._messages.RemoveMessage(tb);
                if (inputFilePathChanged)
                {   
                    this.BeginParse();
                    if (this.VerifyFile(tb, fileID, this.GetCurrentPassword()))
                    {
                        tb.ForeColor = (this._visualTracking) ? this._visualTrackingColor : Control.DefaultForeColor;
                        tb.BackColor = Color.Empty;
                    }
                    this.EndParse();
                    outdatedLbl.Visible = false;
                } 
            }
            else
            {
                if (filePath == string.Empty)
                {
                    this._messages.AddMessage(
                        "Please select a " + FriendlyTitles[fileID] + " file you would like to use with the model.", Color.Red, tb);
                }
                else
                {
                    this._messages.AddMessage(
                        "The specified " + FriendlyTitles[fileID] + " file does not exist on disk.", Color.Red, tb);
                }
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
        }
        void InputFile_VisibleOrEnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled && tb.Visible) { this.InputFile_TextChanged(sender, e); }
            else                          { this._messages.RemoveMessage(sender); tb.BackColor = Color.Empty; }
        }
        void InputFileBrowse_Click(object sender, EventArgs e)
        {
            TextBox tb = null;
            int id = -1;
            if      (sender == this.ux_marketDataFileBrowse    ) { id = MarketDataID  ; tb = this.ux_marketDataFile    ; }
            else if (sender == this.ux_technologiesFileBrowse  ) { id = TechnologiesID; tb = this.ux_technologiesFile  ; }
            else if (sender == this.ux_parametersFileBrowse    ) { id = ParametersID  ; tb = this.ux_parametersFile    ; }
            else if (sender == this.ux_emissionsRatesFileBrowse) { id = EmissionsID   ; tb = this.ux_emissionsRatesFile; }
            else if (sender == this.ux_scenariosFileBrowse     ) { id = ScenariosID   ; tb = this.ux_scenariosFile     ; }
            OpenFileDialog dlg = new OpenFileDialog();
            if (id != -1) { dlg.Title = "Please select the " + FriendlyTitles[id] + " file you would like to use with the model:"; }
            if (File.Exists(tb.Text)) { dlg.FileName = tb.Text; }
            dlg.Multiselect = false;
            dlg.Filter = "Microsoft Excel Workbook Files (*.xls)|*.xls";
            if (dlg.ShowDialog() == DialogResult.OK) { tb.Text = dlg.FileName; }
        }
        bool CompareFilePaths(string path1, string path2)
        {
            if (File.Exists(path1)) { path1 = Path.GetFullPath(path1); }
            if (File.Exists(path2)) { path2 = Path.GetFullPath(path2); }
            return Global.StringCompare(path1, path2, false);
        }
        void InitializeInputPanelDragDrop()
        {
            this.ux_inputFilesPanel.AllowDrop = true;
            this.ux_inputFilesPanel.DragEnter += new DragEventHandler(this.InputFilePanel_DragEnter);
            this.ux_inputFilesPanel.DragDrop  += new DragEventHandler(this.InputFilePanel_DragDrop);
        }
        void InputFilePanel_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        void InputFilePanel_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            this.ParseFiles(files, this.GetCurrentPassword(), false);
        }
        void BeginParse()
        {
            this._parsing++;
            if (this._parsing == 1) { this.ChangeInputState(this, EventArgs.Empty); }
        }
        void EndParse()
        {
            if (this._parsing > 0)
            {
                this._parsing--;
                if (this._parsing == 0) { this.ChangeInputState(this, EventArgs.Empty); }
            }
        }
        void ChangeInputState(object sender, EventArgs e)
        {
            this.OnParsingChanged(e);
            if (this.Visible && this.IsHandleCreated)
            {
                if (this.InvokeRequired)
                {
                    this.Invoke(new EventHandler(this.ChangeInputState));
                }
                else
                {
                    bool enabled = (this._parsing == 0);
                    this.AllowDrop                             =  enabled;
                    this.ux_encryptionPanel         .Enabled   =  enabled;
                    this.ux_inputFilesPanel         .AllowDrop =  enabled;
                    this.ux_marketDataFile          .ReadOnly  = !enabled;
                    this.ux_technologiesFile        .ReadOnly  = !enabled;
                    this.ux_parametersFile          .ReadOnly  = !enabled;
                    this.ux_emissionsRatesFile      .ReadOnly  = !enabled;
                    this.ux_scenariosFile           .ReadOnly  = !enabled;
                    this.ux_marketDataFileBrowse    .Enabled   =  enabled;
                    this.ux_technologiesFileBrowse  .Enabled   =  enabled;
                    this.ux_parametersFileBrowse    .Enabled   =  enabled;
                    this.ux_emissionsRatesFileBrowse.Enabled   =  enabled;
                    this.ux_scenariosFileBrowse     .Enabled   =  enabled;
                } 
            } 
        }
        void ParseFile(string path, string password, bool keepExisting)
        {
            this.ParseFiles(new string[] {path}, password, keepExisting);
        }
        void ParseFiles(string[] paths, string password, bool keepExisting)
        {
            if (paths == null || paths.Length == 0) { return; }
            this.BeginParse();
            StringCollection scFiles = new StringCollection();
            StringCollection scDirs  = new StringCollection();
            for (int i = 0; i < paths.Length; i++)
            {
                if      (Directory.Exists(paths[i])) { scDirs .Add(paths[i]); }
                else if (File     .Exists(paths[i])) { scFiles.Add(paths[i]); }
            }
            string[] files = new string[scFiles.Count]; scFiles.CopyTo(files, 0);
            string[] dirs  = new string[scDirs .Count]; scDirs .CopyTo(dirs , 0);
            bool[] found = new bool[FileCount];
            if (keepExisting)
            {
                if (File.Exists(this.ux_marketDataFile    .Text)) { found[MarketDataID  ] = true; }
                if (File.Exists(this.ux_technologiesFile  .Text)) { found[TechnologiesID] = true; }
                if (File.Exists(this.ux_parametersFile    .Text)) { found[ParametersID  ] = true; }
                if (File.Exists(this.ux_emissionsRatesFile.Text)) { found[EmissionsID   ] = true; }
                if (File.Exists(this.ux_scenariosFile     .Text)) { found[ScenariosID   ] = true; }
            }
            this.ParseFilesHelper(files, dirs, found, password, 3);
            this.EndParse();
        }
        void ParseFilesHelper(string[] files, string[] dirs, bool[] found, string password, int recurseDepth)
        {
            int foundCount = 0;
            for (int i = 0; i < found.Length; i++)
            {
                if (found[i]) { foundCount++; }
            }
            for (int i = 0; i < files.Length; i++)
            {
                if (foundCount == FileCount) { return; }
                this._messages.AddMessage("Checking input file:  \"" + files[i] + "\"", Color.Blue, files[i]);
                Application.DoEvents();
                string wbTitle;
                try
                {   
                    Input input = new Input(files[i], password);
                    input.Close();
                    wbTitle = input.Title;
                } catch { continue; }
                for (int j = 0; j < FileCount; j++)
                {
                    if (this._visibleFiles[j] && !found[j] && Global.StringCompareAny(wbTitle, DesiredTitles[j], true))
                    {
                        found[j] = true;
                        foundCount++;
                        if      (j == MarketDataID  ) { this.ux_marketDataFile    .Text = files[i]; }
                        else if (j == TechnologiesID) { this.ux_technologiesFile  .Text = files[i]; }
                        else if (j == ParametersID  ) { this.ux_parametersFile    .Text = files[i]; }
                        else if (j == EmissionsID   ) { this.ux_emissionsRatesFile.Text = files[i]; }
                        else if (j == ScenariosID   ) { this.ux_scenariosFile     .Text = files[i]; }
                        break;
                    }
                }
                this._messages.RemoveMessage(files[i]);
                Application.DoEvents();
            } 
            for (int i = 0; i < dirs.Length; i++)
            {
                string[] recurseFiles = Directory.GetFiles(dirs[i], "*.xls");
                string[] recurseDirs  = (recurseDepth > 0) ? Directory.GetDirectories(dirs[i]) : new string[0];
                this.ParseFilesHelper(recurseFiles, recurseDirs, found, password, recurseDepth - 1);
            }
        }
        void VerifyFiles()
        {
            this.BeginParse();
            string password = this.GetCurrentPassword();
            this.VerifyFile(this.ux_marketDataFile    , MarketDataID  , password);
            this.VerifyFile(this.ux_technologiesFile  , TechnologiesID, password);
            this.VerifyFile(this.ux_parametersFile    , ParametersID  , password);
            this.VerifyFile(this.ux_emissionsRatesFile, EmissionsID   , password);
            this.VerifyFile(this.ux_scenariosFile     , ScenariosID   , password);
            this.EndParse();
        }
        bool VerifyFile(TextBox tb, int fileID, string password)
        {
            this._messages.AddMessage("Checking " + FriendlyTitles[fileID] + " input file ...", Color.Blue, tb);
            Application.DoEvents();
            bool verified = false;
            try
            {
                Input inputFile = new Input(tb.Text, password);
                inputFile.Close();
                verified = Global.StringCompareAny(inputFile.Title, DesiredTitles[fileID], true);
            }
            catch { verified = false; }
            this._messages.RemoveMessage(tb);
            Application.DoEvents();
            if (!verified)
            {
                this._messages.AddMessage("The selected " + FriendlyTitles[fileID] + " file could not be opened.", Color.Red, tb);
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
                Application.DoEvents();
            }
            return verified;
        }
        void LoadFiles()
        {
            this.BeginParse();
            string password = this.GetCurrentPassword();
            this.LoadFile(MarketDataID  , this.ux_marketDataFile    , password, ref this._inputSettings.MarketDataFile    , ref this._inputSettings.MarketDataTimestamp    );
            this.LoadFile(TechnologiesID, this.ux_technologiesFile  , password, ref this._inputSettings.TechnologiesFile  , ref this._inputSettings.TechnologiesTimestamp  );
            this.LoadFile(ParametersID  , this.ux_parametersFile    , password, ref this._inputSettings.ParametersFile    , ref this._inputSettings.ParametersTimestamp    );
            this.LoadFile(EmissionsID   , this.ux_emissionsRatesFile, password, ref this._inputSettings.EmissionsRatesFile, ref this._inputSettings.EmissionsRatesTimestamp);
            this.LoadFile(ScenariosID   , this.ux_scenariosFile     , password, ref this._inputSettings.ScenariosFile     , ref this._inputSettings.ScenariosTimestamp     );
            this.ux_reloadAllFromDisk.Checked = false;
            this.EndParse();
        }
        bool LoadFile(int fileID, TextBox tb, string password, ref string file, ref DateTime timestamp)
        {
            if (!this._visibleFiles[fileID]) { return false; }
            if (!(this.ux_reloadAllFromDisk.Checked || !this.CompareFilePaths(file, tb.Text))) { return false; }
            this._messages.AddMessage("Loading " + FriendlyTitles[fileID] + " input file ...", Color.Blue, tb);
            Application.DoEvents();
            bool fileLoaded = false;
            try
            {
                if      (fileID == MarketDataID  ) { this._data[fileID] = new Industry      (tb.Text, password); }
                else if (fileID == TechnologiesID) { this._data[fileID] = new Technologies  (tb.Text, password); }
                else if (fileID == ParametersID  ) { this._data[fileID] = new Parameters    (tb.Text, password); }
                else if (fileID == EmissionsID   ) { this._data[fileID] = new EmissionsRates(tb.Text, password); }
                else if (fileID == ScenariosID   ) { this._data[fileID] = new Scenarios     (tb.Text, password); }
                file       = tb.Text.Trim();
                timestamp  = File.GetLastWriteTime(file);
                fileLoaded = true;
            }
            catch { fileLoaded = false; }
            this._messages.RemoveMessage(tb);
            Application.DoEvents();
            if (!fileLoaded)
            {
                this._data[fileID] = null;
                this._messages.AddMessage("The selected " + FriendlyTitles[fileID] + " file could not be opened.", Color.Red, tb);
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
            return fileLoaded;
        }
        string GetCurrentPassword()
        {
            return (this.ux_encryptInput.Checked &&
                this.ux_inputPassword.Text == this.ux_inputPasswordVerfiy.Text) ? this.ux_inputPassword.Text : null;
        }
        void ShowHideFilePaths()
        {
            if (!this.Visible) { return; }
            int m = 8, t = 48, p = 88, e = 128, s = 168, r = 208;
            t = (this._visibleFiles[MarketDataID  ]) ? m + 40 : m;
            p = (this._visibleFiles[TechnologiesID]) ? t + 40 : t;
            e = (this._visibleFiles[ParametersID  ]) ? p + 40 : p;
            s = (this._visibleFiles[EmissionsID   ]) ? e + 40 : e;
            r = (this._visibleFiles[ScenariosID   ]) ? s + 40 : s;
            bool showAny = (this._visibleFiles[MarketDataID] || this._visibleFiles[TechnologiesID] || this._visibleFiles[ParametersID] || this._visibleFiles[EmissionsID] ||
                this._visibleFiles[ScenariosID]);
            this.ux_marketDataFileLabel     .Visible = this._visibleFiles[MarketDataID];
            this.ux_marketDataFile          .Visible = this._visibleFiles[MarketDataID];
            this.ux_marketDataFileBrowse    .Visible = this._visibleFiles[MarketDataID];
            this.ux_technologiesFileLabel   .Visible = this._visibleFiles[TechnologiesID];
            this.ux_technologiesFile        .Visible = this._visibleFiles[TechnologiesID];
            this.ux_technologiesFileBrowse  .Visible = this._visibleFiles[TechnologiesID];
            this.ux_technologiesFileLabel   .Top     = t;
            this.ux_technologiesFile        .Top     = t + 16;
            this.ux_technologiesFileBrowse  .Top     = t + 16;
            this.ux_parametersFileLabel     .Visible = this._visibleFiles[ParametersID];
            this.ux_parametersFile          .Visible = this._visibleFiles[ParametersID];
            this.ux_parametersFileBrowse    .Visible = this._visibleFiles[ParametersID];
            this.ux_parametersFileLabel     .Top     = p;
            this.ux_parametersFile          .Top     = p + 16;
            this.ux_parametersFileBrowse    .Top     = p + 16;
            this.ux_emissionsRatesFileLabel .Visible = this._visibleFiles[EmissionsID];
            this.ux_emissionsRatesFile      .Visible = this._visibleFiles[EmissionsID];
            this.ux_emissionsRatesFileBrowse.Visible = this._visibleFiles[EmissionsID];
            this.ux_emissionsRatesFileLabel .Top     = e;
            this.ux_emissionsRatesFile      .Top     = e + 16;
            this.ux_emissionsRatesFileBrowse.Top     = e + 16;
            this.ux_scenariosFileLabel      .Visible = this._visibleFiles[ScenariosID];
            this.ux_scenariosFile           .Visible = this._visibleFiles[ScenariosID];
            this.ux_scenariosFileBrowse     .Visible = this._visibleFiles[ScenariosID];
            this.ux_scenariosFileLabel      .Top     = s;
            this.ux_scenariosFile           .Top     = s + 16;
            this.ux_scenariosFileBrowse     .Top     = s + 16;
            this.ux_reloadAllFromDisk       .Visible = showAny;
            this.ux_reloadAllFromDisk       .Top     = r;
            this.ux_inputFilesPanel         .Height  = r + 24;
        }
        public void SetInitialState(InputSettings inputSettings)
        {
            this._inputSettings = inputSettings;
            bool forceReload = false;
            this.ux_doNotEncryptInput  .Checked = !inputSettings.EncryptInput;
            this.ux_encryptInput       .Checked =  inputSettings.EncryptInput;
            this.ux_inputPassword      .Text    =  inputSettings.InputPassword;
            this.ux_inputPasswordVerfiy.Text    =  inputSettings.InputPassword;
            this.SetInitialState_ProcessFile(inputSettings.MarketDataFile    , inputSettings.MarketDataTimestamp    , MarketDataID  , this.ux_marketDataFile    , this.ux_marketDataFileOutdatedLabel    , ref forceReload);
            this.SetInitialState_ProcessFile(inputSettings.TechnologiesFile  , inputSettings.TechnologiesTimestamp  , TechnologiesID, this.ux_technologiesFile  , this.ux_technologiesFileOutdatedLabel  , ref forceReload);
            this.SetInitialState_ProcessFile(inputSettings.ParametersFile    , inputSettings.ParametersTimestamp    , ParametersID  , this.ux_parametersFile    , this.ux_parametersFileOutdatedLabel    , ref forceReload);
            this.SetInitialState_ProcessFile(inputSettings.EmissionsRatesFile, inputSettings.EmissionsRatesTimestamp, EmissionsID   , this.ux_emissionsRatesFile, this.ux_emissionsRatesFileOutdatedLabel, ref forceReload);
            this.SetInitialState_ProcessFile(inputSettings.ScenariosFile     , inputSettings.ScenariosTimestamp     , ScenariosID   , this.ux_scenariosFile     , this.ux_scenariosFileOutdatedLabel     , ref forceReload);
            this.ux_reloadAllFromDisk.Checked = forceReload;
            this.ParseFile(inputSettings.DataPath, null, true);
            this.ShowHideFilePaths();
            base.SaveChanges();
        }
        void SetInitialState_ProcessFile(string file, DateTime timestamp, int fileID, TextBox tb, Label outdatedLbl, ref bool forceReload)
        {
            if (!this._visibleFiles[fileID]) { return; }
            tb.Text = file;
            Application.DoEvents();
            if (File.Exists(file))
            {
                DateTime dt = File.GetLastWriteTime(file);
                if (timestamp < dt)
                {
                    outdatedLbl.Visible = true;
                    forceReload = true;
                }
            }
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._inputSettings.EncryptInput = this.ux_encryptInput.Checked;
                if (this._inputSettings.EncryptInput)
                {
                    this._inputSettings.InputPassword = this.ux_inputPassword.Text;
                }
                this._saveThread = new Thread(new ThreadStart(this.SaveChangesThread));
                this._saveThread.Name = "InputPanelSaveThread";
                this._saveThread.Start();
            }
        }
        void SaveChangesThread()
        {
            this.LoadFiles();       
            base.SaveChanges();     
            this.PostSave();        
        }
        void PostSave()
        {
            if (this._visualTracking)
            {   
                this.ux_inputPassword      .ForeColor = Control.DefaultForeColor;
                this.ux_inputPassword      .BackColor = Color.Empty;
                this.ux_inputPasswordVerfiy.ForeColor = Control.DefaultForeColor;
                this.ux_inputPasswordVerfiy.BackColor = Color.Empty;
                this.ux_marketDataFile     .ForeColor = Control.DefaultForeColor;
                this.ux_marketDataFile     .BackColor = Color.Empty;
                this.ux_technologiesFile   .ForeColor = Control.DefaultForeColor;
                this.ux_technologiesFile   .BackColor = Color.Empty;
                this.ux_parametersFile     .ForeColor = Control.DefaultForeColor;
                this.ux_parametersFile     .BackColor = Color.Empty;
                this.ux_emissionsRatesFile .ForeColor = Control.DefaultForeColor;
                this.ux_emissionsRatesFile .BackColor = Color.Empty;
                this.ux_scenariosFile      .ForeColor = Control.DefaultForeColor;
                this.ux_scenariosFile      .BackColor = Color.Empty;
                this.ux_marketDataFileOutdatedLabel    .Visible = false;
                this.ux_technologiesFileOutdatedLabel  .Visible = false;
                this.ux_parametersFileOutdatedLabel    .Visible = false;
                this.ux_emissionsRatesFileOutdatedLabel.Visible = false;
                this.ux_scenariosFileOutdatedLabel     .Visible = false;
            }
        }
        #endregion
        #region 
        [Browsable(true)]
        [DefaultValue(true)]
        [Category("Appearance")]
        [Description("Specifies whether to display the Market-Data file prompt.")]
        public bool ShowMarketData
        {
            get { return this._visibleFiles[MarketDataID]; }
            set { this._visibleFiles[MarketDataID] = value; this.ShowHideFilePaths(); }
        }
        [Browsable(true)]
        [DefaultValue(true)]
        [Category("Appearance")]
        [Description("Specifies whether to display the Technologies file prompt.")]
        public bool ShowTechnologies
        {
            get { return this._visibleFiles[TechnologiesID]; }
            set { this._visibleFiles[TechnologiesID] = value; this.ShowHideFilePaths(); }
        }
        [Browsable(true)]
        [DefaultValue(true)]
        [Category("Appearance")]
        [Description("Specifies whether to display the Parameters file prompt.")]
        public bool ShowParameters
        {
            get { return this._visibleFiles[ParametersID]; }
            set { this._visibleFiles[ParametersID] = value; this.ShowHideFilePaths(); }
        }
        [Browsable(true)]
        [DefaultValue(true)]
        [Category("Appearance")]
        [Description("Specifies whether to display the Emissions-Rates file prompt.")]
        public bool ShowEmissions
        {
            get { return this._visibleFiles[EmissionsID]; }
            set { this._visibleFiles[EmissionsID] = value; this.ShowHideFilePaths(); }
        }
        [Browsable(true)]
        [DefaultValue(true)]
        [Category("Appearance")]
        [Description("Specifies whether to display the Scenarios file prompt.")]
        public bool ShowScenarios
        {
            get { return this._visibleFiles[ScenariosID]; }
            set { this._visibleFiles[ScenariosID] = value; this.ShowHideFilePaths(); }
        }
        [Browsable(false)]
        public Industry MarketData
        {
            get { return (this._data[MarketDataID] == null) ? null : (Industry)this._data[MarketDataID]; }
        }
        [Browsable(false)]
        public Technologies Technologies
        {
            get { return (this._data[TechnologiesID] == null) ? null : (Technologies)this._data[TechnologiesID]; }
        }
        [Browsable(false)]
        public Parameters Parameters
        {
            get { return (this._data[ParametersID] == null) ? null : (Parameters)this._data[ParametersID]; }
        }
        [Browsable(false)]
        public EmissionsRates EmissionsRates
        {
            get { return (this._data[EmissionsID] == null) ? null : (EmissionsRates)this._data[EmissionsID]; }
        }
        [Browsable(false)]
        public Scenarios Scenarios
        {
            get { return (this._data[ScenariosID] == null) ? null : (Scenarios)this._data[ScenariosID]; }
        }
        [Browsable(false)]
        public bool Parsing { get { return this._parsing > 0; } }
        [Browsable(false)]
        public InputSettings InputSettings { get { return this._inputSettings; } }
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (this.Parsing) { return false; }     
                if (this.ux_encryptInput.Checked &&
                    (this.ux_inputPassword.Text == string.Empty ||
                     this.ux_inputPassword.Text != this.ux_inputPasswordVerfiy.Text)) { return false; }
                if ((this._visibleFiles[MarketDataID  ] && !File.Exists(this.ux_marketDataFile    .Text)) ||
                    (this._visibleFiles[TechnologiesID] && !File.Exists(this.ux_technologiesFile  .Text)) ||
                    (this._visibleFiles[ParametersID  ] && !File.Exists(this.ux_parametersFile    .Text)) ||
                    (this._visibleFiles[EmissionsID   ] && !File.Exists(this.ux_emissionsRatesFile.Text)) ||
                    (this._visibleFiles[ScenariosID   ] && !File.Exists(this.ux_scenariosFile     .Text))) { return false; }
                return base.SettingsChanged ||
                    (this.ux_encryptInput.Checked && this.ux_inputPassword.Text != this._inputSettings.InputPassword) ||
                    this.ux_reloadAllFromDisk.Checked ||
                    (this._visibleFiles[MarketDataID  ] && !this.CompareFilePaths(this._inputSettings.MarketDataFile    , this.ux_marketDataFile    .Text)) ||
                    (this._visibleFiles[TechnologiesID] && !this.CompareFilePaths(this._inputSettings.TechnologiesFile  , this.ux_technologiesFile  .Text)) ||
                    (this._visibleFiles[ParametersID  ] && !this.CompareFilePaths(this._inputSettings.ParametersFile    , this.ux_parametersFile    .Text)) ||
                    (this._visibleFiles[EmissionsID   ] && !this.CompareFilePaths(this._inputSettings.EmissionsRatesFile, this.ux_emissionsRatesFile.Text)) ||
                    (this._visibleFiles[ScenariosID   ] && !this.CompareFilePaths(this._inputSettings.ScenariosFile     , this.ux_scenariosFile     .Text));
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.Label ux_encryptionLabel;
        System.Windows.Forms.Panel ux_encryptionPanel;
        System.Windows.Forms.RadioButton ux_encryptInput;
        System.Windows.Forms.RadioButton ux_doNotEncryptInput;
        System.Windows.Forms.TextBox ux_inputPassword;
        System.Windows.Forms.Label ux_inputPasswordLabel1;
        System.Windows.Forms.TextBox ux_inputPasswordVerfiy;
        System.Windows.Forms.Label ux_inputPasswordLabel2;
        System.Windows.Forms.Label ux_inputPasswordLabel3;
        System.Windows.Forms.Label ux_inputFilesLabel;
        System.Windows.Forms.Panel ux_inputFilesPanel;
        System.Windows.Forms.Label ux_marketDataFileLabel;
        System.Windows.Forms.Label ux_marketDataFileOutdatedLabel;
        System.Windows.Forms.TextBox ux_marketDataFile;
        System.Windows.Forms.Button ux_marketDataFileBrowse;
        System.Windows.Forms.Label ux_technologiesFileLabel;
        System.Windows.Forms.Label ux_technologiesFileOutdatedLabel;
        System.Windows.Forms.TextBox ux_technologiesFile;
        System.Windows.Forms.Button ux_technologiesFileBrowse;
        System.Windows.Forms.Label ux_parametersFileLabel;
        System.Windows.Forms.Label ux_parametersFileOutdatedLabel;
        System.Windows.Forms.TextBox ux_parametersFile;
        System.Windows.Forms.Button ux_parametersFileBrowse;
        System.Windows.Forms.Label ux_emissionsRatesFileLabel;
        System.Windows.Forms.Label ux_emissionsRatesFileOutdatedLabel;
        System.Windows.Forms.TextBox ux_emissionsRatesFile;
        System.Windows.Forms.Button ux_emissionsRatesFileBrowse;
        System.Windows.Forms.Label ux_scenariosFileLabel;
        System.Windows.Forms.Label ux_scenariosFileOutdatedLabel;
        System.Windows.Forms.TextBox ux_scenariosFile;
        System.Windows.Forms.Button ux_scenariosFileBrowse;
        System.Windows.Forms.CheckBox ux_reloadAllFromDisk;
        #endregion
        static readonly string[][] DesiredTitles =
            new string[][] {
                               new string[] {"CAFE Market Data"},
                               new string[] {"CAFE Technologies"},
                               new string[] {"CAFE Parameters"},
                               new string[] {"CAFE Emissions Rates", "CAFE Emissions"},
                               new string[] {"CAFE Scenarios"}
                           };
        static readonly string[] FriendlyTitles =
            new string[] {
                             "Market-Data",
                             "Technologies",
                             "Parameters",
                             "Emissions-Rates",
                             "Scenarios"
                         };
        const int FileCount      = 5;       
        const int MarketDataID   = 0;
        const int TechnologiesID = 1;
        const int ParametersID   = 2;
        const int EmissionsID    = 3;
        const int ScenariosID    = 4;
        int    _parsing;                    
        Thread _saveThread;                 
        bool  [] _visibleFiles;             
        bool  [] _verifiedFiles;            
        object[] _data;                     
        InputSettings _inputSettings;
        #endregion
	}
}

