using System;
using System.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class NamePlateCollection : CollectionBase, ICloneable
    {
        #region 
        public NamePlateCollection() : base()
        {
        }
        public NamePlateCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        #endregion
        #region 
        public int Add(NamePlate value)
        {
            return this.InnerList.Add(value);
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, NamePlate value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(NamePlate value)
        {
            this.InnerList.Remove(value);
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(NamePlate value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(NamePlate value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(NamePlate value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(NamePlate value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public void CopyTo(NamePlate[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(NamePlate[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public NamePlate[] ToArray()
        {
            NamePlate[] array = new NamePlate[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public NamePlateCollection Clone()
        {
            NamePlateCollection newCollection = new NamePlateCollection(this.Count);
            for (int i = 0; i < this.Count; i++)
            {
                newCollection.Add((NamePlate)(this[i].Clone()));
            }
            return newCollection;
        }
        #endregion
        #endregion
        #region 
        public NamePlate this[int index]
        {
            get { return (NamePlate)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        #endregion
    }
}

