using System;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public sealed class AggregateEffectsData : ICloneable
    {
        #region 
        public AggregateEffectsData()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public AggregateEffectsData Clone()
        {
            AggregateEffectsData ea = new AggregateEffectsData();
            ea.Sales       = this.Sales;
            ea.FuelEconomy = this.FuelEconomy;
            Type m6Type    = typeof(M6Double);
            ea.Vmt               = (M6Double[])Global.CloneArray(this.Vmt              , m6Type);
            ea.Gallons           = (M6Double[])Global.CloneArray(this.Gallons          , m6Type);
            ea.FuelTax           = (M6Double[])Global.CloneArray(this.FuelTax          , m6Type);
            ea.DiscFuelTax       = (M6Double[])Global.CloneArray(this.DiscFuelTax      , m6Type);
            ea.PreTaxFuel        = (M6Double[])Global.CloneArray(this.PreTaxFuel       , m6Type);
            ea.DiscPreTaxFuel    = (M6Double[])Global.CloneArray(this.DiscPreTaxFuel   , m6Type);
            ea.DriveSurplus      = (M6Double[])Global.CloneArray(this.DriveSurplus     , m6Type);
            ea.DiscDriveSurplus  = (M6Double[])Global.CloneArray(this.DiscDriveSurplus , m6Type);
            ea.RefuelSurplus     = (M6Double[])Global.CloneArray(this.RefuelSurplus    , m6Type);
            ea.DiscRefuelSurplus = (M6Double[])Global.CloneArray(this.DiscRefuelSurplus, m6Type);
            ea.CongestionCosts     = (M6Double[])Global.CloneArray(this.CongestionCosts    , m6Type);
            ea.DiscCongestionCosts = (M6Double[])Global.CloneArray(this.DiscCongestionCosts, m6Type);
            ea.AccidentCosts       = (M6Double[])Global.CloneArray(this.AccidentCosts      , m6Type);
            ea.DiscAccidentCosts   = (M6Double[])Global.CloneArray(this.DiscAccidentCosts  , m6Type);
            ea.NoiseCosts          = (M6Double[])Global.CloneArray(this.NoiseCosts         , m6Type);
            ea.DiscNoiseCosts      = (M6Double[])Global.CloneArray(this.DiscNoiseCosts     , m6Type);
            ea.EconomicCosts       = (M6Double[])Global.CloneArray(this.EconomicCosts      , m6Type);
            ea.DiscEconomicCosts   = (M6Double[])Global.CloneArray(this.DiscEconomicCosts  , m6Type);
            ea.COEmissions   = (M6Double[])Global.CloneArray(this.COEmissions  , m6Type);
            ea.CODamage      = (M6Double[])Global.CloneArray(this.CODamage     , m6Type);
            ea.CODiscDamage  = (M6Double[])Global.CloneArray(this.CODiscDamage , m6Type);
            ea.VOCEmissions  = (M6Double[])Global.CloneArray(this.VOCEmissions , m6Type);
            ea.VOCDamage     = (M6Double[])Global.CloneArray(this.VOCDamage    , m6Type);
            ea.VOCDiscDamage = (M6Double[])Global.CloneArray(this.VOCDiscDamage, m6Type);
            ea.NOXEmissions  = (M6Double[])Global.CloneArray(this.NOXEmissions , m6Type);
            ea.NOXDamage     = (M6Double[])Global.CloneArray(this.NOXDamage    , m6Type);
            ea.NOXDiscDamage = (M6Double[])Global.CloneArray(this.NOXDiscDamage, m6Type);
            ea.PMEmissions   = (M6Double[])Global.CloneArray(this.PMEmissions  , m6Type);
            ea.PMDamage      = (M6Double[])Global.CloneArray(this.PMDamage     , m6Type);
            ea.PMDiscDamage  = (M6Double[])Global.CloneArray(this.PMDiscDamage , m6Type);
            ea.SOXEmissions  = (M6Double[])Global.CloneArray(this.SOXEmissions , m6Type);
            ea.SOXDamage     = (M6Double[])Global.CloneArray(this.SOXDamage    , m6Type);
            ea.SOXDiscDamage = (M6Double[])Global.CloneArray(this.SOXDiscDamage, m6Type);
            ea.CO2Emissions  = (M6Double[])Global.CloneArray(this.CO2Emissions , m6Type);
            ea.CO2Damage     = (M6Double[])Global.CloneArray(this.CO2Damage    , m6Type);
            ea.CO2DiscDamage = (M6Double[])Global.CloneArray(this.CO2DiscDamage, m6Type);
            ea.RcGallons             = this.RcGallons;
            ea.RcPreTaxFuel          = this.RcPreTaxFuel;
            ea.RcDiscPreTaxFuel      = this.RcDiscPreTaxFuel;
            ea.RcDriveSurplus        = this.RcDriveSurplus;
            ea.RcDiscDriveSurplus    = this.RcDiscDriveSurplus;
            ea.RcRefuelSurplus       = this.RcRefuelSurplus;
            ea.RcDiscRefuelSurplus   = this.RcDiscRefuelSurplus;
            ea.RcCongestionCosts     = this.RcCongestionCosts;
            ea.RcDiscCongestionCosts = this.RcDiscCongestionCosts;
            ea.RcAccidentCosts       = this.RcAccidentCosts;
            ea.RcDiscAccidentCosts   = this.RcDiscAccidentCosts;
            ea.RcNoiseCosts          = this.RcNoiseCosts;
            ea.RcDiscNoiseCosts      = this.RcDiscNoiseCosts;
            ea.RcEconomicCosts       = this.RcEconomicCosts;
            ea.RcDiscEconomicCosts   = this.RcDiscEconomicCosts;
            ea.RcCODamage      = this.RcCODamage;
            ea.RcCODiscDamage  = this.RcCODiscDamage;
            ea.RcVOCDamage     = this.RcVOCDamage;
            ea.RcVOCDiscDamage = this.RcVOCDiscDamage;
            ea.RcNOXDamage     = this.RcNOXDamage;
            ea.RcNOXDiscDamage = this.RcNOXDiscDamage;
            ea.RcPMDamage      = this.RcPMDamage;
            ea.RcPMDiscDamage  = this.RcPMDiscDamage;
            ea.RcSOXDamage     = this.RcSOXDamage;
            ea.RcSOXDiscDamage = this.RcSOXDiscDamage;
            ea.RcCO2Damage     = this.RcCO2Damage;
            ea.RcCO2DiscDamage = this.RcCO2DiscDamage;
            ea.RcSocialBenefits     = this.RcSocialBenefits;
            ea.RcDiscSocialBenefits = this.RcDiscSocialBenefits;
            return ea;
        }
        #endregion
        public void Reset()
        {
            this.Sales      .Clear();
            this.FuelEconomy.Clear();
            this.Vmt               = new M6Double[Global.CY];
            this.Gallons           = new M6Double[Global.CY];
            this.FuelTax           = new M6Double[Global.CY];
            this.DiscFuelTax       = new M6Double[Global.CY];
            this.PreTaxFuel        = new M6Double[Global.CY];
            this.DiscPreTaxFuel    = new M6Double[Global.CY];
            this.DriveSurplus      = new M6Double[Global.CY];
            this.DiscDriveSurplus  = new M6Double[Global.CY];
            this.RefuelSurplus     = new M6Double[Global.CY];
            this.DiscRefuelSurplus = new M6Double[Global.CY];
            this.CongestionCosts     = new M6Double[Global.CY];
            this.DiscCongestionCosts = new M6Double[Global.CY];
            this.AccidentCosts       = new M6Double[Global.CY];
            this.DiscAccidentCosts   = new M6Double[Global.CY];
            this.NoiseCosts          = new M6Double[Global.CY];
            this.DiscNoiseCosts      = new M6Double[Global.CY];
            this.EconomicCosts       = new M6Double[Global.CY];
            this.DiscEconomicCosts   = new M6Double[Global.CY];
            this.COEmissions   = new M6Double[Global.CY];
            this.CODamage      = new M6Double[Global.CY];
            this.CODiscDamage  = new M6Double[Global.CY];
            this.VOCEmissions  = new M6Double[Global.CY];
            this.VOCDamage     = new M6Double[Global.CY];
            this.VOCDiscDamage = new M6Double[Global.CY];
            this.NOXEmissions  = new M6Double[Global.CY];
            this.NOXDamage     = new M6Double[Global.CY];
            this.NOXDiscDamage = new M6Double[Global.CY];
            this.PMEmissions   = new M6Double[Global.CY];
            this.PMDamage      = new M6Double[Global.CY];
            this.PMDiscDamage  = new M6Double[Global.CY];
            this.SOXEmissions  = new M6Double[Global.CY];
            this.SOXDamage     = new M6Double[Global.CY];
            this.SOXDiscDamage = new M6Double[Global.CY];
            this.CO2Emissions  = new M6Double[Global.CY];
            this.CO2Damage     = new M6Double[Global.CY];
            this.CO2DiscDamage = new M6Double[Global.CY];
            this.RcGallons            .Clear();
            this.RcPreTaxFuel         .Clear();
            this.RcDiscPreTaxFuel     .Clear();
            this.RcDriveSurplus       .Clear();
            this.RcDiscDriveSurplus   .Clear();
            this.RcRefuelSurplus      .Clear();
            this.RcDiscRefuelSurplus  .Clear();
            this.RcCongestionCosts    .Clear();
            this.RcDiscCongestionCosts.Clear();
            this.RcAccidentCosts      .Clear();
            this.RcDiscAccidentCosts  .Clear();
            this.RcNoiseCosts         .Clear();
            this.RcDiscNoiseCosts     .Clear();
            this.RcEconomicCosts      .Clear();
            this.RcDiscEconomicCosts  .Clear();
            this.RcCODamage     .Clear();
            this.RcCODiscDamage .Clear();
            this.RcVOCDamage    .Clear();
            this.RcVOCDiscDamage.Clear();
            this.RcNOXDamage    .Clear();
            this.RcNOXDiscDamage.Clear();
            this.RcPMDamage     .Clear();
            this.RcPMDiscDamage .Clear();
            this.RcSOXDamage    .Clear();
            this.RcSOXDiscDamage.Clear();
            this.RcCO2Damage    .Clear();
            this.RcCO2DiscDamage.Clear();
            this.RcSocialBenefits    .Clear();
            this.RcDiscSocialBenefits.Clear();
        }
        #endregion
        #region 
        public M6Double Sales;
        public M6Double FuelEconomy;
        public M6Double[] Vmt;
        public M6Double[] Gallons;
        public M6Double[] FuelTax;
        public M6Double[] DiscFuelTax;
        public M6Double[] PreTaxFuel;
        public M6Double[] DiscPreTaxFuel;
        public M6Double[] DriveSurplus;
        public M6Double[] DiscDriveSurplus;
        public M6Double[] RefuelSurplus;
        public M6Double[] DiscRefuelSurplus;
        public M6Double[] CongestionCosts;
        public M6Double[] DiscCongestionCosts;
        public M6Double[] AccidentCosts;
        public M6Double[] DiscAccidentCosts;
        public M6Double[] NoiseCosts;
        public M6Double[] DiscNoiseCosts;
        public M6Double[] EconomicCosts;
        public M6Double[] DiscEconomicCosts;
        public M6Double[] COEmissions;
        public M6Double[] CODamage;
        public M6Double[] CODiscDamage;
        public M6Double[] VOCEmissions;
        public M6Double[] VOCDamage;
        public M6Double[] VOCDiscDamage;
        public M6Double[] NOXEmissions;
        public M6Double[] NOXDamage;
        public M6Double[] NOXDiscDamage;
        public M6Double[] PMEmissions;
        public M6Double[] PMDamage;
        public M6Double[] PMDiscDamage;
        public M6Double[] SOXEmissions;
        public M6Double[] SOXDamage;
        public M6Double[] SOXDiscDamage;
        public M6Double[] CO2Emissions;
        public M6Double[] CO2Damage;
        public M6Double[] CO2DiscDamage;
        #region 
        public RCDouble RcGallons;
        public RCDouble RcPreTaxFuel;
        public RCDouble RcDiscPreTaxFuel;
        public RCDouble RcDriveSurplus;
        public RCDouble RcDiscDriveSurplus;
        public RCDouble RcRefuelSurplus;
        public RCDouble RcDiscRefuelSurplus;
        public RCDouble RcCongestionCosts;
        public RCDouble RcDiscCongestionCosts;
        public RCDouble RcAccidentCosts;
        public RCDouble RcDiscAccidentCosts;
        public RCDouble RcNoiseCosts;
        public RCDouble RcDiscNoiseCosts;
        public RCDouble RcEconomicCosts;
        public RCDouble RcDiscEconomicCosts;
        public RCDouble RcCODamage;
        public RCDouble RcCODiscDamage;
        public RCDouble RcVOCDamage;
        public RCDouble RcVOCDiscDamage;
        public RCDouble RcNOXDamage;
        public RCDouble RcNOXDiscDamage;
        public RCDouble RcPMDamage;
        public RCDouble RcPMDiscDamage;
        public RCDouble RcSOXDamage;
        public RCDouble RcSOXDiscDamage;
        public RCDouble RcCO2Damage;
        public RCDouble RcCO2DiscDamage;
        public RCDouble RcSocialBenefits;
        public RCDouble RcDiscSocialBenefits;
        #endregion
        #endregion
    }
}

