using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class EngineDescription : ICloneable
    {
        #region 
        public EngineDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EngineDescription Clone()
        {
            EngineDescription ed = new EngineDescription();
            ed.Code                  = this.Code;
            ed.Manufacturer          = this.Manufacturer;
            ed.Configuration         = this.Configuration;
            ed.Fuel                  = this.Fuel;
            ed.EngineOilViscosity    = this.EngineOilViscosity;
            ed.Cycle                 = this.Cycle;
            ed.FuelSystem            = this.FuelSystem;
            ed.Aspiration            = this.Aspiration;
            ed.ValvetrainDesign      = this.ValvetrainDesign;
            ed.ValveActuationTiming  = this.ValveActuationTiming;
            ed.ValveLift             = this.ValveLift;
            ed.Cylinders             = this.Cylinders;
            ed.ValvesPerCylinder     = this.ValvesPerCylinder;
            ed.Deactivation          = this.Deactivation;
            ed.Displacement          = this.Displacement;
            ed.Horsepower            = this.Horsepower;
            ed.Torque                = this.Torque;
            ed.UsedTechnologies      = (int[])Global.CloneArray(this.UsedTechnologies     , typeof(int));
            ed.AvailableTechnologies = (int[])Global.CloneArray(this.AvailableTechnologies, typeof(int));
            return ed;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return (this.Configuration + this.Cylinders.ToString("0") + " " + this.Displacement.ToString("0.0") + this.Fuel);
        }
        #endregion
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Configuration;
        public string Fuel;
        public string EngineOilViscosity;
        public char   Cycle;
        public string FuelSystem;
        public string Aspiration;
        public string ValvetrainDesign;
        public string ValveActuationTiming;
        public string ValveLift;
        public int    Cylinders;
        public int    ValvesPerCylinder;
        public double Deactivation;
        public double Displacement;
        public double Horsepower;
        public double Torque;
        public int[] UsedTechnologies;
        public int[] AvailableTechnologies;
        #endregion
    }
}

