using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class IndustryModelingData : ICloneable
    {
        #region 
        public IndustryModelingData()
        {
            this.EffectsData = new AggregateEffectsData();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public IndustryModelingData Clone()
        {
            IndustryModelingData imd = new IndustryModelingData();
            imd.EffectsData = this.EffectsData.Clone();
            if (this.BaselineInfo != null)
            {
                int biCount = this.BaselineInfo.Length;
                imd.BaselineInfo = new BaselineInfo[biCount];
                for (int i = 0; i < biCount; i++)
                {
                    imd.BaselineInfo[i] = this.BaselineInfo[i].Clone();
                }
            }
            imd.TechUsedSales = (RCDouble[])Global.CloneArray(this.TechUsedSales, typeof(RCDouble));
            return imd;
        }
        #endregion
        #endregion
        #region 
        public AggregateEffectsData EffectsData;
        public BaselineInfo[] BaselineInfo;
        public RCDouble[] TechUsedSales;
        #endregion
    }
}

