using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class VehicleDescription : ICloneable
    {
        #region 
        public VehicleDescription(double baseWeight)
            : base()
        {
            this.BaseWeight = baseWeight;
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public VehicleDescription Clone()
        {
            VehicleDescription vd = new VehicleDescription(this.BaseWeight);
            vd.Code                  = this.Code;
            vd.Manufacturer          = this.Manufacturer;
            vd.Model                 = this.Model;
            vd.Nameplate             = this.Nameplate;
            vd.FuelEconomy           = this.FuelEconomy;
            vd.EngineCode            = this.EngineCode;
            vd.TransmissionCode      = this.TransmissionCode;
            vd.Origin                = this.Origin;
            vd.Sales                 = (double[])Global.CloneArray(this.Sales, typeof(double));
            vd.Msrp                  = (double[])Global.CloneArray(this.Msrp , typeof(double));
            vd.Price                 = (double[])Global.CloneArray(this.Price, typeof(double));
            vd.RegulatoryIndicator   = this.RegulatoryIndicator;
            vd.TechnologyClass       = this.TechnologyClass;
            vd.Class                 = this.Class;
            vd.Style                 = this.Style;
            vd.Structure             = this.Structure;
            vd.Drive                 = this.Drive;
            vd.Footprint             = this.Footprint;
            vd.CurbWeight            = this.CurbWeight;
            vd.GVWR                  = this.GVWR;
            vd.Seating               = this.Seating;
            vd.FuelCapacity          = this.FuelCapacity;
            vd.HybridType            = this.HybridType;
            vd.PredecessorCode       = this.PredecessorCode;
            vd.RefreshYears          = (int[])Global.CloneArray(this.RefreshYears , typeof(int));
            vd.RedesignYears         = (int[])Global.CloneArray(this.RedesignYears, typeof(int));
            vd.Percent2Dr            = this.Percent2Dr;
            vd.EmploymentHours       = this.EmploymentHours;
            vd.UsedTechnologies      = (int[])Global.CloneArray(this.UsedTechnologies     , typeof(int));
            vd.AvailableTechnologies = (int[])Global.CloneArray(this.AvailableTechnologies, typeof(int));
            return vd;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return (this.Model + "(Eng: " + this.EngineCode + ", Trn: " + this.TransmissionCode + ")");
        }
        #endregion
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Model;
        public string Nameplate;
        public double FuelEconomy;
        public int    EngineCode;
        public int    TransmissionCode;
        public char   Origin;
        public double[] Sales;
        public double[] Msrp;
        public double[] Price;
        public string RegulatoryIndicator;
        public string TechnologyClass;
        public string Class;
        public string Style;
        public string Structure;
        public char   Drive;
        public double Footprint;
        readonly public double BaseWeight;
        public double CurbWeight;
        public double GVWR;
        public int    Seating;
        public double FuelCapacity;
        public string HybridType;
        public int   PredecessorCode;
        public int[] RefreshYears;
        public int[] RedesignYears;
        public double Percent2Dr;
        public double EmploymentHours;
        public int[] UsedTechnologies;
        public int[] AvailableTechnologies;
        #endregion
    }
}

