using System;
using System.ComponentModel;
using System.Globalization;
using System.IO;
using System.Reflection;
using Volpe.Cafe.Data;
namespace Volpe.Cafe
{
    public sealed class Global
    {
        #region 
        static Global()
        {
            ProcessorCount            = int.Parse(Environment.GetEnvironmentVariable("NUMBER_OF_PROCESSORS"));
            ProcessorArchitecture     = Environment.GetEnvironmentVariable("PROCESSOR_ARCHITECTURE");
            ProcessorArchitecture_x86 = (ProcessorArchitecture == "x86" || ProcessorArchitecture == "X86");
            Assembly exeAssembly = Assembly.GetExecutingAssembly();
            ApplicationVersion   = exeAssembly.GetName().Version.ToString();
            ApplicationTimestamp = (new FileInfo(exeAssembly.GetFiles()[0].Name)).LastWriteTime.ToString("M/dd/yy H:mm:ss");
        }
        #endregion
        #region 
        #region 
        public static bool ShowExcelApplication()
        {
            return Volpe.Utils.XlUtilities.ShowExcelApplication();
        }
        public static void HideExcelApplication()
        {
            Volpe.Utils.XlUtilities.HideExcelApplication();
        }
        #endregion
        #region 
        public static void Swap(ref int x, ref int y)
        {
            if (x != y) { int tmp = x; x = y; y = tmp; }
        }
        public static void Swap(ref double x, ref double y)
        {
            if (x != y) { double tmp = x; x = y; y = tmp; }
        }
        #endregion
        #region 
        public static bool IsNumeric(object value)
        {
            double result;
            return double.TryParse(Global.GetString(value), NumberStyles.Any, NumberFormatInfo.InvariantInfo, out result);
        }
        public static bool GetBool(object value)
        {
            return Global.GetString(value).Equals("TRUE");
        }
        public static byte GetByte(object value)
        {
            return (byte)Global.GetDouble(value, false);
        }
        public static short GetInt16(object value)
        {
            return (short)Global.GetDouble(value, false);
        }
        public static int GetInt32(object value)
        {
            return (int)Global.GetDouble(value, false);
        }
        public static long GetInt64(object value)
        {
            return (long)Global.GetDouble(value, false);
        }
        public static double GetDouble(object value)
        {
            return Global.GetDouble(value, true);
        }
        static double GetDouble(object value, bool checkNaN)
        {
            if (checkNaN) { if (Global.GetString(value).ToUpper() == "NAN") { return double.NaN; } }
            double result = 0;
            double.TryParse(Global.GetString(value), NumberStyles.Any, NumberFormatInfo.InvariantInfo, out result);
            return result;
        }
        public static char GetChar(object value)
        {
            string str = Global.GetString(value);
            return str.Equals(string.Empty) ? '\0' : str[0];
        }
        public static string GetString(object value)
        {
            return (value == null) ? string.Empty : value.ToString().Trim().ToUpper();
        }
        #endregion
        #region 
        [Obsolete("Use Volpe.Cafe.Global.CloneArray(System.Array, System.Type) instead.")]
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static Array CloneArray(Array value)
        {
            if      (value == null)     { return null; }
            else if (value.Length == 0) { return (Array)value.Clone(); }
            else
            {
                Array destination = Array.CreateInstance(value.GetValue(0).GetType(), value.Length);
                value.CopyTo(destination, 0);
                return destination;
            }
        }
        [EditorBrowsable(EditorBrowsableState.Always)]
        public static Array CloneArray(Array value, Type elementType)
        {
            if (value == null) { return null; }
            else
            {
                Array destination;
                if (value.Rank == 1) { destination = Array.CreateInstance(elementType, value.Length); }
                else
                {   
                    int[] lens = new int[value.Rank];
                    for (int i = 0, lenCount = value.Rank; i < lenCount; i++)
                    {
                        lens[i] = value.GetLength(i);
                    }
                    destination = Array.CreateInstance(elementType, lens);
                }
                Array.Copy(value, destination, value.Length);
                return destination;
            }
        }
        public static Array ResizeArray(Array arr, Type type, int newLength, bool preserve)
        {
            Array newArr = Array.CreateInstance(type, newLength);
            if (preserve)
            {   
                int arrLen = arr.Length;
                if (arrLen > newLength) { arrLen = newLength; }
                Array.Copy(arr, newArr, arrLen);
            }
            return newArr;
        }
        #endregion
        #region 
        public static bool StringCompare(string value1, string value2, bool fuzzy)
        {
            if (!fuzzy)
            {   
                if (value1.Length != value2.Length) { return false; }
                if (string.Equals(value1, value2) ) { return true ; }
            }
            if (fuzzy) { StringPrepareFuzzy(ref value1, ref value2); }
            return (string.Compare(value1, value2, true) == 0);
        }
        public static bool StringCompareAny(string value, string[] comparands, bool fuzzy)
        {
            if (comparands == null || comparands.Length == 0) { return false; }
            for (int i = 0; i < comparands.Length; i++)
            {   
                if (Global.StringCompare(value, comparands[i], fuzzy)) { return true; }
            }
            return false;
        }
        public static bool StringContains(string value, string substring, bool fuzzy)
        {
            if (fuzzy) { StringPrepareFuzzy(ref value, ref substring); }
            if (value.Length < substring.Length) { return false; }  
            if (string.Equals(value, substring)) { return true ; }  
            value     = value.ToUpper();
            substring = substring.ToUpper();
            return (value.IndexOf(substring) != -1);
        }
        public static bool StringStartsWith(string value, string substring, bool fuzzy)
        {
            if (fuzzy) { StringPrepareFuzzy(ref value, ref substring); }
            if (value.Length < substring.Length) { return false; }  
            if (string.Equals(value, substring)) { return true ; }  
            value     = value.ToUpper();
            substring = substring.ToUpper();
            return value.StartsWith(substring);
        }
        static void StringPrepareFuzzy(ref string value1, ref string value2)
        {
            value1 = Global.StringRemoveWhitespacePunctuationAndSpecialChars(value1);
            value2 = Global.StringRemoveWhitespacePunctuationAndSpecialChars(value2);
        }
        #endregion
        public static string GetTimeString(long value)
        {
            long sec = value / 1000;
            long s = sec % 60,
                 m = sec / 60 % 60,
                 h = sec / 3600 % 24,
                 d = sec / 86400;
            return ((d != 0) ? d.ToString() + "." : "") + h.ToString("00:") + m.ToString("00:") + s.ToString("00");
        }
        public static string GetTimeString(TimeSpan value)
        {
            return Global.GetTimeString(value.Ticks / 10000);
        }
        public static string RemoveSpecialChars(string value, char c)
        {
            int spCharCount = Global.SpecialChars.Length;
            for (int i = 0; i < spCharCount; i++)
            {
                if (value.IndexOf(Global.SpecialChars[i]) != -1)
                {
                    value = value.Replace(Global.SpecialChars[i], c);
                }
            }
            return value;
        }
        public static string GetTitleCase(string value)
        {
            char[] chars = value.ToCharArray();
            for (int i = 0, count = value.Length; i < count; i++)
            {
                bool isTitleChar = (i == 0 || ((chars[i - 1] < 48 || chars[i - 1] > 57) &&
                    (chars[i - 1] < 65 || chars[i - 1] > 90) && (chars[i - 1] < 97 || chars[i - 1] > 122)));
                int c = chars[i];
                if      (isTitleChar)         { if (c >= 97 && c <= 122) { chars[i] = (char)(c - 32); } }
                else if (c >= 65 && c <= 90 ) { chars[i] = (char)(c + 32); }
            }
            return new string(chars);
        }
        public static string GetTitleCase(string value, int minLength)
        {
            return (value.Length >= minLength) ? GetTitleCase(value) : value;
        }
        static bool IsLetterOrNumber(char c)
        {
            return (c >= 48 && c <= 57) || (c >= 65 && c <= 90) || (c >= 97 && c <= 122);
        }
        static bool IsNotLetterOrNumber(char c)
        {
            return (c < 48 || c > 57) && (c < 65 || c > 90) && (c < 97 || c > 122);
        }
        #region 
        public static string StringRemoveWhitespacePunctuationAndSpecialChars(string value)
        {
            return Global.StringRemove(Global.StringRemove(value, Global.BaseRemove), Global.ExtRemove );
        }
        static string StringRemove(string value, string[] chars)
        {
            for (int i = 0; i < chars.Length; i++)
            {
                value = value.Replace(chars[i], "");
            }
            return value;
        }
        #endregion
        #endregion
        #region 
        private static readonly string[] BaseRemove = new string[] {" ", "\t", "\r", "\n", "-", "_"};
        private static readonly string[] ExtRemove =
            new string[] {
                             ".", ",", "!", "?", "@", "#", "$", "%", "^", "&", "*",
                             "(", ")", "{", "}", "[", "]", "'", "\"", "/", "\\", "|"
                         };
        private static readonly char[] SpecialChars = new char[] {'/', '\\', ':', '*', '?', '"', '<', '>', '|'};
        public static readonly int ProcessorCount;
        public static readonly string ProcessorArchitecture;
        public static readonly bool ProcessorArchitecture_x86;
        public const int CY = 36;
        public static readonly string ApplicationVersion;
        public static readonly string ApplicationTimestamp;
        #endregion
    }
}

