using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
using Volpe.Utils;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct OutputSettings
    {
        #region 
        public OutputSettings(string outputPath)
        {
            this.OutputPath                    = outputPath;
            this.EncryptOutput                 = false;
            this.OutputPassword                = string.Empty;
            this.UseStrongEncryption           = false;
            this.GenerateReports               = false;
            this.ReportIndustry                = false;
            this.ReportManufacturers           = false;
            this.ReportVehicles                = false;
            this.ReportScenarioSummary         = false;
            this.ReportEffects                 = false;
            this.ReportEnvironmentalAssessment = false;
            this.ReportOptimizedIndustry       = false;
        }
        #endregion
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Output Settings ---"    +
                "\n  OutputPath="                      + this.OutputPath                    +
                "\n  EncryptOutput="                   + this.EncryptOutput                 +
                "\n    OutputPassword="                + this.MaskOutputPassword('*')       +
                "\n    UseStrongEncryption="           + this.UseStrongEncryption           +
                "\n  GenerateReports="                 + this.GenerateReports               +
                "\n    ReportIndustry="                + this.ReportIndustry                +
                "\n    ReportManufacturers="           + this.ReportManufacturers           +
                "\n    ReportVehicles="                + this.ReportVehicles                +
                "\n    ReportScenarioSummary="         + this.ReportScenarioSummary         +
                "\n    ReportEffects="                 + this.ReportEffects                 +
                "\n    ReportEnvironmentalAssessment=" + this.ReportEnvironmentalAssessment +
                "\n    ReportOptimizedIndustry="       + this.ReportOptimizedIndustry;
            writer.Summary.WriteLine(outStr + "\n");
        }
        string MaskOutputPassword(char pwMask)
        {
            return (this.OutputPassword == null || this.OutputPassword == string.Empty) ? "" : new string(pwMask, 8);
        }
        #endregion
        #region 
        public static readonly XlCryptoSettings DefaultWeakEncryption = XlCryptoSettings.OfficeXor;
        public static readonly XlCryptoSettings DefaultStrongEncryption = XlCryptoSettings.RC4_MsftRSASChannel;
        public string OutputPath;
        public bool EncryptOutput;
        public string OutputPassword;
        public bool UseStrongEncryption;
        public bool GenerateReports;
        public bool ReportIndustry;
        public bool ReportManufacturers;
        public bool ReportVehicles;
        public bool ReportScenarioSummary;
        public bool ReportEffects;
        public bool ReportEnvironmentalAssessment;
        public bool ReportOptimizedIndustry;
        #endregion
    }
}

