using System;
using System.Globalization;
namespace Volpe
{
    public class Information
    {
        public static bool IsNumeric(string value)
        {
            double d;
            return double.TryParse(value, NumberStyles.Any, NumberFormatInfo.InvariantInfo, out d);
        }
        public static bool IsNumeric(object value)
        {
            return IsNumeric(GetString(value));
        }
        public static bool GetBool(object value)
        {
            return GetString(value).Equals("TRUE");
        }
        public static int GetInt32(object value)
        {
            return (int)GetDouble(value);
        }
        public static double GetDouble(object value)
        {
            double d = 0;
            double.TryParse(GetString(value), NumberStyles.Any, NumberFormatInfo.InvariantInfo, out d);
            return d;
        }
        public static char GetChar(object value)
        {
            string str = GetString(value);
            return str.Equals(string.Empty) ? '\0' : str[0];
        }
        public static string GetString(object value)
        {
            return (value == null) ? string.Empty : value.ToString().Trim().ToUpper();
        }
    }
}

