using System;
namespace Volpe.Utils
{
    [Serializable]
    public struct XlCell
    {
        #region 
        public XlCell(int row, int column)
        {
            this.Row    = row;
            this.Column = column;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return ("(" + this.Row.ToString() + ", " + this.Column.ToString() + ")");
        }
        #endregion
        #region 
        public bool IsEmpty { get { return (this.Row == 0 && this.Column == 0); } }
        public bool IsValid { get { return (this.Row >  0 && this.Column >  0); } }
        #endregion
        #region 
        public static readonly XlCell Empty = new XlCell(0, 0);
        public int Row;
        public int Column;
        #endregion
    }
}

