using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlChartTypeInfo
    {
        private static bool Compare(XlChartType type, params int[] types)
        {
            int t = (int)type;
            for (int i = 0, count = types.Length >> 1; i < count; i+=2)
            {
                if (t >= types[i] && t <= types[i + 1]) { return true; }
            }
            return false;
        }
        public static bool IsSupported(XlChartType type)
        {
            return !Compare(type, 15, 15, 81, 91, -4151, -4151);
        }
        public static bool Is3D(XlChartType type)
        {
            return Compare(type, -4102, -4100, -4098, -4098, 54, 56, 60, 62, 70, 70, 78, 79, 83, 84, 87, 87, 92, 112);
        }
        public static bool IsArea(XlChartType type)
        {
            return Compare(type, -4098, -4098, 1, 1, 76, 79);
        }
        public static bool IsBar(XlChartType type)
        {
            return Compare(type, 57, 62);
        }
        public static bool IsBubble(XlChartType type)
        {
            return Compare(type, 15, 15, 87, 87);
        }
        public static bool IsColumn(XlChartType type)
        {
            return Compare(type, 51, 56, -4100, -4100);
        }
        public static bool IsCone(XlChartType type)
        {
            return Compare(type, 99, 105);
        }
        public static bool IsCylinder(XlChartType type)
        {
            return Compare(type, 92, 98);
        }
        public static bool IsDoughnut(XlChartType type)
        {
            return Compare(type, 80, 80, -4120, -4120);
        }
        public static bool IsLine(XlChartType type)
        {
            return Compare(type, 4, 4, 63, 67, -4101, -4101);
        }
        public static bool IsPie(XlChartType type)
        {
            return Compare(type, 5, 5, 68, 71, -4102, -4102);
        }
        public static bool IsPyramid(XlChartType type)
        {
            return Compare(type, 106, 112);
        }
        public static bool IsRadar(XlChartType type)
        {
            return Compare(type, 81, 82, -4151, -4151);
        }
        public static bool IsStock(XlChartType type)
        {
            return Compare(type, 88, 91);
        }
        public static bool IsSurface(XlChartType type)
        {
            return Compare(type, 83, 86);
        }
        public static bool IsXYScatter(XlChartType type)
        {
            return Compare(type, 72, 75, -4169, -4169);
        }
    }
}

