using System;
namespace Volpe.Utils
{
    [Serializable]
    public struct XlCryptoSettings
    {
        #region 
        public bool IsEmpty { get { return this._isEmpty; } }
        public static XlCryptoSettings Empty
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto._isEmpty = true;
                return crypto;
            }
        }
        public static XlCryptoSettings OfficeXor
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "";
                crypto.EncryptionAlgorithm = "OfficeXor";
                crypto.EncryptionKeyLength = -1;
                crypto.EncryptDocumentProperties = false;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings OfficeStandard
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "";
                crypto.EncryptionAlgorithm = "OfficeStandard";
                crypto.EncryptionKeyLength = 40;
                crypto.EncryptDocumentProperties = false;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings RC4_MsftDHSChannel
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "Microsoft DH SChannel Cryptographic Provider";
                crypto.EncryptionAlgorithm = "RC4";
                crypto.EncryptionKeyLength = 128;
                crypto.EncryptDocumentProperties = true;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings RC4_MsftRSASChannel
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "Microsoft RSA SChannel Cryptographic Provider";
                crypto.EncryptionAlgorithm = "RC4";
                crypto.EncryptionKeyLength = 128;
                crypto.EncryptDocumentProperties = true;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings RC4_MsftBase
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "Microsoft Base Cryptographic Provider v1.0";
                crypto.EncryptionAlgorithm = "RC4";
                crypto.EncryptionKeyLength = 56;
                crypto.EncryptDocumentProperties = true;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings RC4_MsftEnhanced
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "Microsoft Enhanced Cryptographic Provider v1.0";
                crypto.EncryptionAlgorithm = "RC4";
                crypto.EncryptionKeyLength = 128;
                crypto.EncryptDocumentProperties = true;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings RC4_MsftStrong
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "Microsoft Strong Cryptographic Provider";
                crypto.EncryptionAlgorithm = "RC4";
                crypto.EncryptionKeyLength = 128;
                crypto.EncryptDocumentProperties = true;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        #endregion
        #region 
        public string EncryptionProvider;
        public string EncryptionAlgorithm;
        public int EncryptionKeyLength;
        public bool EncryptDocumentProperties;
        private bool _isEmpty;
        #endregion
    }
}

