using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlRange
    {
        #region 
        public XlRange(XlCell cell1, XlCell cell2)
        {
            this.Cell1 = cell1;
            this.Cell2 = cell2;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return ("{" + this.Cell1.ToString() + ", " + this.Cell2.ToString() + "}");
        }
        #endregion
        #region 
        public bool IsEmpty { get { return (this.Cell1.IsEmpty && this.Cell2.IsEmpty); } }
        public bool IsValid { get { return (this.Cell1.IsValid && this.Cell2.IsValid); } }
        #endregion
        #region 
        public XlCell Cell1;
        public XlCell Cell2;
        #endregion
    }
}

