using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public class OperatingModes : ISettings, ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        ISettings ISettings.Clone()
        {
            return this.Clone();
        }
        OperatingModes Clone()
        {
            OperatingModes value = new OperatingModes();
            Clone(this, value);
            return value;
        }
        static void Clone(OperatingModes src, OperatingModes dst)
        {
            dst.ModelingApproach                  = src.ModelingApproach;
            dst.AutoToggleApproach                = src.AutoToggleApproach;
            dst.MergedFleet                       = src.MergedFleet;
            dst.NoFines                           = src.NoFines;
            dst.Overcomply                        = src.Overcomply;
            dst.OvercomplyInBaseline              = src.OvercomplyInBaseline;
            dst.OvercomplyCostEffectiveOnly       = src.OvercomplyCostEffectiveOnly;
            dst.OvercomplyLookAheadYears          = src.OvercomplyLookAheadYears;
            dst.MultiYearModeling                 = src.MultiYearModeling;
            dst.MultiYearStartYear                = src.MultiYearStartYear;
            dst.AllowCreditTrading                = src.AllowCreditTrading;
            dst.DynamicFleetShare                 = src.DynamicFleetShare;
            dst.FleetAnalysis                     = src.FleetAnalysis;
            dst.TechnologyInheriting              = src.TechnologyInheriting;
            dst.Backfill                          = src.Backfill;
            dst.IgnoreYearAvailable               = src.IgnoreYearAvailable;
            dst.IgnorePhaseIn                     = src.IgnorePhaseIn;
            dst.IgnoreRefreshRedesign             = src.IgnoreRefreshRedesign;
            dst.IgnoreWeightInMsApplication       = src.IgnoreWeightInMsApplication;
            dst.FuelPriceEstimates                = src.FuelPriceEstimates;
            dst.CO2Estimates                      = src.CO2Estimates;
            dst.ConsumerBenefitsScale             = src.ConsumerBenefitsScale;
        }
        #endregion
        #region 
        void ISettings.SetDefaultSettings()
        {
            this.ModelingApproach            = ModelingApproach.LowCostFirst;
            this.AutoToggleApproach          = false;
            this.MergedFleet                 = false;
            this.NoFines                     = true;
            this.Overcomply                  = true;
            this.OvercomplyInBaseline        = true;
            this.OvercomplyCostEffectiveOnly = true;
            this.OvercomplyLookAheadYears    = 0;
            this.MultiYearModeling           = true;
            this.MultiYearStartYear          = 2016;
            this.AllowCreditTrading          = true;
            this.DynamicFleetShare           = false;
            this.FleetAnalysis               = false;
            this.TechnologyInheriting        = true;
            this.Backfill                    = true;
            this.IgnoreYearAvailable         = false;
            this.IgnorePhaseIn               = false;
            this.IgnoreRefreshRedesign       = false;
            this.IgnoreWeightInMsApplication = true;
            this.FuelPriceEstimates          = Estimates.Average;
            this.CO2Estimates                = Estimates.Average;
            this.ConsumerBenefitsScale       = 1.0;
        }
        void ISettings.UpdateSettings(ISettings newSettings)
        {
            this.UpdateSettings((OperatingModes)newSettings);
        }
        public void UpdateSettings(OperatingModes newSettings)
        {
            Clone(newSettings, this);
        }
        public void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Operating Modes ---" +
                "\n  ModelingApproach="               + this.ModelingApproach            +
                "\n  AutoToggleApproach="             + this.AutoToggleApproach          +
                "\n  MergedFleet="                    + this.MergedFleet                 +
                "\n  NoFines="                        + this.NoFines                     +
                "\n  Overcomply="                     + this.Overcomply                  +
                    ((!this.Overcomply) ? "" :
                "\n    OvercomplyInBaseline="         + this.OvercomplyInBaseline        +
                "\n    OvercomplyCostEffectiveOnly="  + this.OvercomplyCostEffectiveOnly +
                "\n    OvercomplyLookAheadYears="     + this.OvercomplyLookAheadYears)   +
                "\n  MultiYearModeling="              + this.MultiYearModeling           +
                                                        ((this.MultiYearModeling) ? " (" + this.MultiYearStartYear + ")" : "") +
                "\n  AllowCreditTrading="             + this.AllowCreditTrading          +
                "\n  DynamicFleetShare="              + this.DynamicFleetShare           +
                "\n  FleetAnalysis="                  + this.FleetAnalysis               +
                "\n  TechnologyInheriting="           + this.TechnologyInheriting        +
                "\n  Backfill="                       + this.Backfill                    +
                "\n  IgnoreYearAvailable="            + this.IgnoreYearAvailable         +
                "\n  IgnorePhaseIn="                  + this.IgnorePhaseIn               +
                "\n  IgnoreRefreshRedesign="          + this.IgnoreRefreshRedesign       +
                "\n  IgnoreWeightInMsApplication="    + this.IgnoreWeightInMsApplication +
                "\n  FuelPriceEstimates="             + this.FuelPriceEstimates          +
                "\n  CO2Estimates="                   + this.CO2Estimates                +
                "\n  ConsumerBenefitsScale="          + this.ConsumerBenefitsScale;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #endregion
        #region 
        #region 
        public ModelingApproach ModelingApproach;
        public bool AutoToggleApproach;
        public bool MergedFleet;
        public bool NoFines;
        public bool Overcomply;
        public bool OvercomplyInBaseline;
        public bool OvercomplyCostEffectiveOnly;
        public int OvercomplyLookAheadYears;
        public bool MultiYearModeling;
        public int MultiYearStartYear;
        public bool AllowCreditTrading;
        public bool DynamicFleetShare;
        public bool FleetAnalysis;
        #endregion
        #region 
        public bool TechnologyInheriting;
        public bool Backfill;
        #endregion
        #region 
        public bool IgnoreYearAvailable;
        public bool IgnorePhaseIn;
        public bool IgnoreRefreshRedesign;
        public bool IgnoreWeightInMsApplication;
        #endregion
        #region 
        public Estimates FuelPriceEstimates;
        public Estimates CO2Estimates;
        public double ConsumerBenefitsScale;
        #endregion
        #endregion
    }
}

