% BridgeSpikes -- A routine to remove obvious spikes by interpolating between two known good points.
% In use with S7D VERSION 2.1  -  1/25/2008
%    This code was written as a function to be called by Roll_Der5 so the
%    operator can remove obvious spikes that interfere with a good fit in
%    the ultrasonics filter.  It may, however, be used for any purpose
%    requiring a linear interpolation between two noncontiguous points.

%  --By Dave Dashner, 05/11/2005.
%
% Revision history:
%   05/11/2005--Original implementation.--DD
%   01/10/2007--Update Code with GUI, Devin Elsasser
%

% The data channel with the spikes eliminated, Despiked_Channel, is
% returned to the calling routine along with the number of spikes removed.

%
% Variables from calling routine:
%
%	Spikey_Channel	= Raw data channel containing undesired spikes
%	Original_File = Raw data file from which the noisey channel came
%	Number_of_Spikes	 = Number of spikes bridged previously
%
% Variables returned to calling routine:
%
%	Despiked_Channel = Data channel returned with spikes bridged
%

function [Despiked_Channel] = BridgeSpikes_v2(Spikey_Channel);

Despiked_Channel = Spikey_Channel;
%%%%%%%
figure(3); clf
plot(Despiked_Channel,'r.')
hold
grid
xlabel('Count No.')
ylabel('Raw Channel')
title('Current View of Raw Channel')
scrsz = get(0,'ScreenSize');
set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
moregaps='y';
while moregaps=='y';
    zoom on
    ll=questdlg('Do you see a gap you wish to bridge? [Yes]','Bridging','Yes','No','Restart','Yes');
    if isempty(ll) || strcmp(ll , 'Yes')
        ll='Y';
    end
    if (ll == 'Y') | (ll == 'y')
        zzz=0;
%         str{1} = 'Zoom in on a spike until you identify the last valid point and';
%         str{2} = 'the next valid point.  Place the crosshairs on the two points';
%         str{3} = 'in succession and left-click the mouse once on each point.';
        title('DIRECTIONS:  FIGURE PAUSED, ZOOM IN Then Hit Enter to Continue');
%         h = text(1,1,0,char(str));
%         set(h,'FontSize',12,'units','normalized','position',[0.05 0.9],'BackgroundColor',[.7 .9 .7]);
        NSpks = {'1'};
        pause
%         NSpks = inputdlg('Enter number of spikes to remove','User
%         Input',1,{'1'});
        if isfloat(double(NSpks{1})) && double(NSpks{1}) > 0 
            NumSpikes =  str2double(NSpks{1});
        elseif isempty(NSpks{:})
            NumSpikes = 1;
        end
        title('DIRECTIONS:  Use CROSSHAIRS to Select valid Spikes BEGIN and END Points');
        [X,Y] = ginput(2); %Where N= number of points (x,y pairs) to be collected -- unless Enter is pressed sooner.
        %        StartPt=input('Enter the count number of the last valid point before the gap: ');
        %        EndPt=input('Enter the count number of the first valid point after the gap: ');
        if numel(X)==2
            if X(2)-X(1)>=0.7;
                StartPt=round(X(1));
                EndPt=round(X(2));
                slope=(Despiked_Channel(EndPt)-Despiked_Channel(StartPt))/(EndPt-StartPt);
                for i=StartPt+1:EndPt-1
                    Despiked_Channel(i)=Despiked_Channel(i-1)+slope;
                end
            end
        end
        if exist('StartPt','var') & exist('EndPt','var')
            plot(StartPt:EndPt,Spikey_Channel(StartPt:EndPt),'g.')
            plot(StartPt:EndPt,Despiked_Channel(StartPt:EndPt),'r.')
            plot(StartPt:EndPt,Despiked_Channel(StartPt:EndPt),'b--')
            zoom on
            NumSpikes=NumSpikes+1;
        end
    elseif strcmp(ll , 'Restart')
        moregaps='y';
        NumSpikes=0;
        Despiked_Channel = Spikey_Channel;
        figure(3); clf
        plot(Despiked_Channel,'r.')
        hold
        grid
        xlabel('Count No.')
        ylabel('Raw Channel')
        title('Current View of Raw Channel')
        scrsz = get(0,'ScreenSize');
        set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
    elseif strcmp(ll , 'No')
        moregaps='n';
    end
end