function varargout = MatrixPlot(varargin)
% MATRIXPLOT Application M-file for MatrixPlot.fig
% MATRIXPLOT, is a Graphical User Interfaces.  It is used to plot data
% channels of .Mat files.  
% It can plot multi channels of one file, or one same channel that is in multi files  
% To modify or add new features,
% See also: GUIDE, GUIDATA, GUIHANDLES
% Last Modified by GUIDE v2.5 07-Mar-2005 15:45:12
% By: GX, DD

% Edit the above text to modify the response to help MatrixPlot
%clear_globalsPlot
clc
globalsPlot;
clear chnList

% Begin initialization code - DO NOT EDIT
d1 = pwd;
addpath(d1);

gui_Singleton = 1;
gui_State = struct('gui_Name',          mfilename, ...
                   'gui_Singleton',     gui_Singleton, ...
                   'gui_OpeningFcn',    @MatrixPlot_OpeningFcn, ...
                   'gui_OutputFcn',     @MatrixPlot_OutputFcn, ...
                   'gui_LayoutFcn',     [], ...
                   'gui_Callback',      []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    varargout{1:nargout} = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before MatrixPlot is made visible.
function MatrixPlot_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to MatrixPlot (see VARARGIN)

% Choose default command line output for MatrixPlot
handles.output = hObject;
handles.idxSel = 1;

set(handles.nrows,'String', '');
set(handles.ncols,'String', '1');

% Update handles structure
guidata(hObject, handles);

if nargin == 3,
    initial_dir = pwd;
elseif nargin > 4
    if strcmpi(varargin{1},'dir')
        if exist(varargin{2},'dir')
            initial_dir = varargin{2};
        else
            errordlg('Input argument must be a valid directory','Input Argument Error!')
            return
        end
    else
        errordlg('Unrecognized input argument','Input Argument Error!');
        return;
    end
end

% Populate the listbox
load_listbox(initial_dir,handles)
set(handles.text1,'String', 'Double click to open folder. Single click to open file');

% Return figure handle as first output argument
    
% UIWAIT makes MatrixPlot wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = MatrixPlot_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% ------------------------------------------------------------
% Callback for list box - open .fig with guide, otherwise use open
% ------------------------------------------------------------
function varargout = listbox1_Callback(h, eventdata, handles)   %=================================
globalsPlot;

sel = get(handles.figure1,'SelectionType');
if strcmp(get(handles.figure1,'SelectionType'),'open')
% open new directory ---
	index_selected = get(handles.listbox1,'Value');
	file_list = get(handles.listbox1,'String');	
	filename = file_list{index_selected};
	handles.selFile = filename;
	guidata(handles.figure1,handles);

	if  handles.is_dir(index_selected)
		cd (filename)
      load_listbox(pwd,handles)
      handles = guidata(gcbo);
      load_ChnListBox('', handles);
      handles = guidata(gcbo);
		set(handles.text1,'String', 'Double click to open folder. Single click to open file');
	else
	   [path,name,ext,ver] = fileparts(filename);
	   switch ext
	   case '.fig'
		   guide (filename)
         load_ChnListBox('', handles);
			handles = guidata(gcbo);
	   case '.mat'
           load_ChnListBox(filename, handles)
			  handles = guidata(gcbo);
 			  set(handles.text1,'String', 'Can select: m-files & n-channels');
     otherwise 
		try
	    	open(filename)
		catch
			errordlg(lasterr,'File Type Error','modal')
		end
	   end	
   end
else % not double click, open and load channels ---
	index_selected = get(handles.listbox1,'Value');
	nSelFiles = length(index_selected);
   if (isempty(nSelFiles))
		return;
	end

	file_list = get(handles.listbox1,'String');	
	for i = 1: nSelFiles
		selFiles(i) = file_list( index_selected(i));
      CurrentFileName = selFiles(i);
        
      icm = strfind(char(selFiles(i)), '.mat');	% all are .mat files
      if (isempty(icm))
			return;
		end
   end

	i = 1;%get 1st file channels to show in channel list
	fileStruct = load(char(selFiles(i)));
	ChnNames = fieldnames(fileStruct);
	handles.ChnStruct = fileStruct;

	[Chns,ChnsIdx] = sortrows(ChnNames);
	nChns = length(Chns);


	handles.chn_names = Chns;
	guidata(handles.figure1,handles);
	sz3 = length(handles.idxSel);
	if(sz3 > 0) | handles.idxSel< nChns
        sz3 = handles.idxSel;
    else
 		sz3 = 1;
   end
    
   set(handles.chanListbox,'String',handles.chn_names,'Value',sz3);
	%set list items and selected index 

   set(handles.text1,'String', 'Can select: m-files & n-channels');
end

% ------------------------------------------------------------
% Read the current directory and sort the names
% ------------------------------------------------------------
function load_listbox(dir_path,handles)
cd (dir_path)
dir_struct = dir(dir_path);
[sorted_names,sorted_index] = sortrows({dir_struct.name}');
sz = length(sorted_names);
ct = 0;
for i = 1:sz
    nm1 = sorted_names(i);
    nmch = char(nm1);
    len = length(nmch);
    if(len > 2)
        icm = strfind(nmch, '.');
          if (~isempty(icm))
             icm = strfind(nmch, '.mat');
             if (~isempty(icm))  %mat file add on list
                 ct = ct + 1;
                 selStructCell(ct) = dir_struct(i);
                 selName(ct) = nm1;
  %               selIdx(ct) = sorted_index(i);
              end
          else  %directory
                ct = ct + 1;        
                 selStructCell(ct) = dir_struct(i);
                 selName(ct) = nm1;
   %              selIdx(ct) = sorted_index(i);
          end
                
    else    %parent directory
        ct = ct + 1;        
        selStructCell(ct) = dir_struct(i);
        selName(ct) = nm1;
 %       selIdx(ct) = sorted_index(i);
    end
end

handles.file_names = selName;
handles.is_dir = [selStructCell.isdir];
guidata(handles.figure1,handles)
set(handles.listbox1,'String', handles.file_names, 'Value',1)
set(handles.MyDir,'String',pwd)
set(handles.Fsec,'Value',1)
set(handles.Fxy,'Value',1)


% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.
usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes during object creation, after setting all properties.
function chanListbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to chanListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in chanListbox.	%======================================
function load_ChnListBox(File, handles)
len = length(File);
if(len > 1)
	handles.ChnStruct = load(File);
	ChnNames = fieldnames(handles.ChnStruct);
	[Chns,ChnsIdx] = sortrows(ChnNames);
else
	handles.ChnStruct = '';
	Chns = '';
	ChnsIdx = 0;
end

selNames(1) = cellstr('NULL');
nSelChns = length(Chns);
ct = 0;
for i = 1:nSelChns
		chs = char(Chns(i));
		chr = ['handles.ChnStruct.' chs];
% 		cmd = (['dim = size(', chr, ', 1);']);
% 		eval(cmd);		
% 		if(dim >  1)
% 			cmd = ['tf = isnumeric('  chr   ');'];
% 			eval(cmd);	
% 			if (tf )
				ct = ct + 1;
				selNames(ct) = Chns(i);
% 			end
% 		end
end

handles.chn_names = selNames;
guidata(handles.figure1,handles);

sz3 = length(handles.idxSel);
if(sz3 > 0) | handles.idxSel< nChns
    sz3 = handles.idxSel;
else
 	 sz3 = 1;
end
    
set(handles.chanListbox,'String',handles.chn_names,'Value',sz3)
%======================

% --- Executes on selection change in chanListbox.%======================================
function chanListbox_Callback(hObject, eventdata, handles)
% hObject    handle to chanListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns chanListbox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from chanListbox
% sel = get(handles.figure1,'SelectionType');
%if strcmp(get(handles.figure1,'SelectionType'),'open')
    globalsPlot
	[selChn, sz] = get_var_names(handles);
    nChans = sz;
    handles = guidata(gcbo);

	chs = char(selChn(1));
	chr = ['handles.ChnStruct.' chs];
	cmd = (['[s1, s2] = size(', chr ');']);
	eval(cmd);	
	if (isempty(s1) | isempty(s2) ) 
		return;
	end

	%display dimesion
    if s1 > 1 & s2 > 1
        str2=['dimension=' num2str(s1)  ' x '  num2str(s2) '; e.g. Select Row="100-200", Column= "1,3" to plot colum 1,3 and points from 100 to 200'];
    else
        str2=['dimension=' num2str(s1)  ' x '  num2str(s2)];
   end 
	set(handles.text1,'String', str2);
%======================


% --- Executes on button press in Dir.
function Dir_Callback(hObject, eventdata, handles)
% hObject    handle to Dir (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in Path1.
%=======================================================================
function Path1_Callback(hObject, eventdata, handles)

handles.directory_name = uigetdir;
if( handles.directory_name  == 0)
    return;
end

cd (handles.directory_name);
load_listbox(pwd,handles);
handles = guidata(gcbo);
set(handles.text1,'String', 'Double click to open folder. Single click to open file');
load_ChnListBox('', handles);

%=============================================
function [vlist, sz] = get_var_names(handles)  % Returns the names of the two variables to plot

	list_entries = get(handles.chanListbox,'String');
	if isempty(list_entries)
		sz = 0;
		vlist = 0;
		 return
	end
	index_selected = get(handles.chanListbox,'Value');
	handles.idxSel = index_selected;
	guidata(handles.figure1,handles);

	sz = length(index_selected);
	for i = 1:sz
		 var1 = list_entries{index_selected(i)};
		 vlist(i) = cellstr(var1);
	end
return ; %------------------------------------


%=============================================
% Returns .mat file names
function [flist, sz] = get_file_names(handles)  
	flist = cellstr('');
	list_entries = get(handles.listbox1,'String');
	if isempty(list_entries)
		sz = 0;
		flist = 0;
		 return
	end
	index_selected = get(handles.listbox1,'Value');
	sz = length(index_selected);
	ct = 0;
	for i = 1:sz
		var1 = list_entries{index_selected(i)};
		icm = strfind(var1, '.mat');
		if (~isempty(icm))  %mat file add on list
			ct = ct + 1;
			flist(ct) = cellstr(var1);
		end
	end
	sz = ct;

return; %---------------------------

% --- Executes on button press in pushbutton3.==========================================
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.Fxsec = get(handles.Fsec,'Value');
handles.FdifLine = get(handles.Fline,'Value');
handles.FdifMark = get(handles.Fmark,'Value');
handles.Fgrid = get(handles.Grid,'Value');
handles.Fsxy = get(handles.Fxy,'Value');


[selChn, nChns] = get_var_names(handles);
handles = guidata(gcbo);

if(nChns < 1)
	set(handles.text1,'String','No channel is selected !')
	return
end


%-----------------lineStyle array
ls(1) = cellstr('-');
ls(2) = cellstr('-.');
ls(3) = cellstr(':');
ls(4) = cellstr('--');
nLines = 4;
%marker array
mk(1) = '.';
mk(2) = 'o';
mk(3) = '*';
mk(4) = 'x';
mk(5) = 's';
mk(6) = 'd';
mk(7) = '^';
mk(8) = '+';
mk(9) = '>';
mk(10) = '<';
mk(11) = 'p';
mk(12) = 'h';
nMarkers =12;

[flist, nFiles] = get_file_names(handles);
if(nFiles < 1) 
	return;
end


%chn = struct('dt',{}, 'name',{});

chStru(1) = handles.ChnStruct;
[chnList, chStru] = loadChans(hObject, handles, selChn, nChns, flist, nFiles);
nchannels = length(chnList);


TitleStr = 'File: ';
if(nFiles == 1)
	[pureName, Flag] = getPureFilename(char(flist(1)));
	TitleStr = [TitleStr  pureName];
else
	for i = 1:nFiles
		[pureName, Flag] = getPureFilename(char(flist(i)));
		if(i == 1)
			TitleStr = [TitleStr num2str(i) '-' pureName];
		else
			TitleStr = [TitleStr ', ' num2str(i) '-' pureName];
		end
	end
end

%find min-size of channels
minSz = 0;
sz1 = 0;
mChnStr = '';
d1 = 0;
for i = 1:nchannels
	chs = char(chnList(i).name);
	chr = ['chnList(' num2str(i) ').dt'];
	cmd = (['sz1 = size(', chr, ', 1);']);
	eval(cmd);	
	if(i == 1) 
		minSz = sz1;
	else
		if( minSz > sz1)
			minSz = sz1;
		end
	end
end

FdtT = isfield(chStru(1),'XIncr') ;
if FdtT == 1
	dtT = chStru(1).XIncr;
end

%  Calculate tChn channel time
%
pts = minSz;
if(isfield(chStru(1), 'Time'))
	tChn = chStru(1).Time(1: pts);
elseif isfield(chStru(1), 'time')
	tChn = chStru(1).time(1: pts);
else
	if FdtT == 1
		t1 = (1:pts);
		tChn = t1 * dtT;
	else
		% no XIncr var
   		tChn = (1:pts);
		dtT = 1;
        
        handles.Fxsec = 0; 
        
% 		disp('No XIncr var!!!');
% 		return
	end
end

ptChn = (1:pts);

for i = 1:nchannels
	chnList(i).dt = chnList(i).dt(1: pts); 
end

legendStr = '';

LineType='';
MarkType ='';
for i = 1:nchannels
	if(handles.FdifLine)		% use different line type
		ii = (i-1)  / nLines ;
		res1 = (i-1) - floor(ii) * nLines + 1 ;
		LineType = char(ls(res1)); 
	end
	if(handles.FdifMark)		% use different marker type
		ii = (i-1)  / nMarkers;
		res2 = (i-1) - floor(ii) * nMarkers + 1 ;
		MarkType = mk(res2);
	end

	chs = char(chnList(i).name);
	chr = ['chnList(' num2str(i)  ').dt'];
    
	if(handles.Fxsec)		% x use second unit
		if(handles.FdifLine | handles.FdifMark )		% use different line type
			s2 = ['tChn'  ','   chr ','   ''''  MarkType, LineType   ''''];
		else
			s2 = ['tChn'  ','   chr ];
		end
		xstr = ['Time(sec)'];
	else
		if(handles.FdifLine | handles.FdifMark )		% use different line type
			s2 = ['ptChn'  ','   chr ','   ''''  MarkType,  LineType  ''''];
		else
			s2 = ['ptChn'  ','   chr ];
		end
		xstr = ['(Count)'];
	end
	if( i == 1)
 		mChnStr = s2 ;
 		legendStr =[ ''''  chs  ''''];
	else 
		mChnStr =[mChnStr ','  s2];
		legendStr =[legendStr  ','  ''''  chs  ''''];
	end
end
cmd = ['plot(' mChnStr ');'];
eval(cmd);		

xlabel(xstr);
ylabel(selChn(1));
title(TitleStr);
cmd = ['legend(' legendStr ');'];
eval(cmd);		
if(handles.Fgrid)
	grid on;
else
	grid off
end

str2 = [num2str(nchannels)  '-channel plot'];
set(handles.text1,'String', str2);

%----------------------------------------------------------


%===========================================================
%load same channels from muti-files
function [chn,ChnStruct ] = loadChans(hObject, handles, selChn,nChns, flist, nFiles)
	
	if (nFiles == 1)
		ChnStruct(1) = load(char(flist(1)));
		for i = 1: nChns
			chs = char(selChn(i));
			chr = [chs];
			rct = isfield(ChnStruct(1), chr) ;
			if rct == 1
				chr  = [ 'ChnStruct(1).', chs];    
				cmd = [ 'chn(', num2str(i), ').dt = ', chr, ';'];    
				eval(cmd);	
				chn(i).name = [chs];	
			else
				return;	%error
			end		
		end
		return;
	end

	for i = 1: nFiles
		ChnStruct = load(char(flist(i)));
		chs = char(selChn(1));
		chr = [chs];
		rct = isfield(ChnStruct, chr) ;
		if rct == 1
			chr  = [ 'ChnStruct(', num2str(i), ').', chs];    
			cmd = [ 'chn(', num2str(i), ').dt = ', chr ';'];    
			eval(cmd);	
			chn(i).name = [chs '-' num2str(i)];	
		else
			return;	%error
		end		
	end
return


%===========================================================
% load same channels from muti-files, the data is matrix
% rowStr, colStr like: rowStr = 1, 100, colStr = 2
% select column 2, points 1 to 100;
% 
function [chn,ChnStruct ] = loadChans_matrix(hObject, handles, selChn,nChns, flist, nFiles, RowStr, ColStr)
	chn = [];
	ChnStruct = [];
	%parse rowStr, colStr
	[iRowAry, FRowScope] = str_2numAry(RowStr);
	[iColAry, FColScope] = str_2numAry(ColStr);
	nCols = length(iColAry);
	nRows = length(iRowAry);
	igood = 0;
	if FColScope % the row vector ---
		for i = 1: nFiles % select multi channel in multi files
			ChnStruct = load(char(flist(i)));
			for j = 1: nChns
				chs = char(selChn(j));
				chr = [chs];
				rct = isfield(ChnStruct, chr) ;
			
				if rct ~= 1 %error
					clc 
					disp([ 'Channel ', chs, ' is not in file ', char(flist(i)), ';']);
					continue; %next channel	
				end	
					
				% check iRow < max-Row
				cmd= [ '[nDtRows, nDtCols] = size(ChnStruct.' chs  ');' ];
				eval(cmd);					  
				
				for k = 1:nRows
					iRow = iRowAry(k);
					if iRow > nDtRows
						clc
						disp(['Error: Row ' num2str(iRow) ' exceeds channel ' chs ' dimensions !']);
						continue;
						%return;
					end
		
					chr  = [ 'ChnStruct.', chs];    
					cmd = ['data = ' chr '(:,' num2str(iRow) ') ;'];    
					eval(cmd);	
			
					npts = length(data);
					if iColAry(1) == 0 % all columns ---
						iColSt = 1;
						iColEd = npts;
					elseif nCols > 1	% part Cols
						iColSt = iColAry(1);
						iColEd = iColAry(2);
						if iColSt > 0 & iColEd > iColSt 
							if iColSt > npts
								clc 
								disp(['Channel =',chr , ': Starting index of Col =', num2str(iColSt), ' is bigger than Col size = ', num2str(npts), ';']);
								continue;
							esleif iColEnd > npts
								disp(['Channel =',chr , ': Starting index of Col =', num2str(iColEnd), ' is bigger than Col size = ', num2str(npts), ', It is cut shorter;']);
								iColEnd = npts
							end
						elseif iColSt > 0 % "123 -" from 123 to end
							iColEd = npts;

						elseif iColSt > 0 % "-123 " from 1 to 123
							iColSt = 1;
						else % error
								clc 
								disp(['Error of selection of Matrix Col or column: ColStr =', ColStr, ',  ColStr=', ColStr, ';']);
								return;
						end
					end
					igood = igood + 1;
                    if nDtRows == 1
                        chn(igood).name = [num2str(i) '.' chs ];	
                    else
        				chn(igood).name = [num2str(i) '.' chs '(' num2str(iRow) ',:)'];	               
                    end
					cmd = [ 'chn(' num2str(igood) ').dt = '  'data(' num2str(iColSt) ':'  num2str(iColEd) ')' ';'];  
					eval(cmd);					  
				end
			end
		end
	elseif FRowScope  % the Col vector ---
		for i = 1: nFiles % select multi channel in multi files
			ChnStruct = load(char(flist(i)));
			for j = 1: nChns
				chs = char(selChn(j));
				chr = [chs];
				rct = isfield(ChnStruct, chr) ;
				if rct ~= 1 %error
					clc 
					disp([ 'Channel ', chs, ' is not in file ', char(flist(i)), ';']);
					continue; %next channel	
				end	
					
				% check iCol < max-Col
                cmd= [ '[nDtRows, nDtCols] = size(ChnStruct.' chs  ');' ];
				eval(cmd);					  
				
				for k = 1:nCols
					iCol = iColAry(k);
					if iCol > nDtCols
						clc
						disp(['Error: Column ' num2str(iCol) ' exceeds channel ' chs ' dimensions !']);
						continue;
						%return;
					end
		
					chr  = [ 'ChnStruct.', chs];    
					cmd = ['data = ' chr '(:,' num2str(iCol) ') ;'];    
					eval(cmd);	
		
					npts = length(data);
					if iRowAry(1) == 0 % all rows ---
						iRowSt = 1;
						iRowEd = npts;
					elseif nRows > 1	% part Rows
						iRowSt = iRowAry(1);
						iRowEd = iRowAry(2);
						if iRowSt > 0 & iRowEd > iRowSt 
							if iRowSt > npts
								clc 
								disp(['Channel =',chr , ': Starting index of Row =', num2str(iRowSt), ' is bigger than Row size = ', num2str(npts), ';']);
								continue;
							esleif iRowEnd > npts
								disp(['Channel =',chr , ': Starting index of Row =', num2str(iRowEnd), ' is bigger than Row size = ', num2str(npts), ', It is cut shorter;']);
								iRowEnd = npts
							end
						elseif iRowSt > 0 % "123 -" from 123 to end
							iRowEd = npts;
						elseif iRowSt > 0 % "-123 " from 1 to 123
							iRowSt = 1;
						else % error
								clc 
								disp(['Error of selection of Matrix Row or column: RowStr =', RowStr, ',  ColStr=', ColStr, ';']);
								return;
						end
					end
					igood = igood + 1;
                    if nCols == 1
                        chn(igood).name = [num2str(i) '.' chs ];	
                    else
                        chn(igood).name = [num2str(i) '.' chs '(:,' num2str(iCol) ')'];	
                    end
					cmd = [ 'chn(' num2str(igood) ').dt = '  'data(' num2str(iRowSt) ':'  num2str(iRowEd) ')' ';'];  
					eval(cmd);					  
				end
			end
		end
	else
		clc
		disp('Matrix row or column selection error !');
		return;
	end
return

%===========================================================
%load same X Y channels from muti-files for X Y plot
% nChns should be 2
function [chn,ChnStruct ] = loadChansXY(hObject, handles, selChn,nChns, flist, nFiles)
	
	if (nFiles == 1)
		ChnStruct(1) = load(char(flist(1)));
		for i = 1: nChns
			chs = char(selChn(i));
			chr = [chs];
			rct = isfield(ChnStruct(1), chr) ;
			if rct == 1
				chr  = [ 'ChnStruct(1).', chs];    
				cmd = [ 'chn(1). dt', num2str(i)', ' = ', chr, ';'];    
				eval(cmd);
				if(i == 1)	
					chn(1).name1 = [chs];	
				else
					chn(1).name2 = [chs];	
				end
			else
				return;	%error
			end		
		end
		return;
	end

	for j = 1: nFiles
		ChnStruct(j) = load(char(flist(j)));
		for i = 1: nChns
			chs = char(selChn(i));
			chr = [chs];
			rct = isfield(ChnStruct(j), chr) ;
			if rct == 1
				chr  = [ 'ChnStruct(j).', chs];    
				cmd = [ 'chn(', num2str(j), '). dt', num2str(i)', ' = ', chr, ';'];    
				eval(cmd);	
				if(i == 1)	
					chn(j).name1 = [chs];	
				else
					chn(j).name2 = [chs];	
				end
			else
				return;	%error
			end		
		end
	end
return

%----------------------------------------------------------

% --- Executes on button press in Fsec.
function Fsec_Callback(hObject, eventdata, handles)
% hObject    handle to Fsec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Fsec
 handles.Fxsec = get(handles.Fsec,'Value');


% --- Executes during object creation, after setting all properties.
function Fsec_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Fsec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function MyDir_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MyDir (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function MyDir_Callback(hObject, eventdata, handles)
% hObject    handle to MyDir (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MyDir as text
%        str2double(get(hObject,'String')) returns contents of MyDir as a double

%not used
% Callback subfunction header defines two input arguments
function myCallback(obj,eventdata)% Create a figure and specify a callback
[xi,yi,but] = ginput(1);
disp('callback-----------------------')
disp(['but = ', num2str(but), '(' , num2str(xi), ', ',  num2str(yi), ')'])
v = axis 


% --- Executes on button press in Fline.
function Fline_Callback(hObject, eventdata, handles)
% hObject    handle to Fline (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Fline


% --- Executes on button press in Fmark.
function Fmark_Callback(hObject, eventdata, handles)
% hObject    handle to Fmark (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Fmark

% --- Executes on button press in Grid.
function Grid_Callback(hObject, eventdata, handles)
% hObject    handle to Grid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Grid



%============================
function [fileName, Flag] = getPureFilename(path)
	fileName = '';
	Flag = 0;
   idot = strfind(path, '.');	% all are .mat files
   if (isempty(idot))
		return;
	end
   isls = strfind(path, '\');	% all are .mat files
   if (isempty(isls))
		iLast = 0;
	else
		sz = length(isls);
		iLast = isls(sz);
	end

	fileName = path ((iLast + 1) : (idot - 1));
    Flag = 1;
return



% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- Executes on button press in GetIndex.
function GetIndex_Callback(hObject, eventdata, handles)
% hObject    handle to GetIndex (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

globalsPlot;
global chnList FxyPlot;
F_x_y = get(handles.Fxy,'Value');

[x,y] = ginput(1);
nchannels = length(chnList);
if FxyPlot
	% Transfer to XyChnList 
	ixy = 0;
	for i = 1:2:nchannels
		ixy = ixy + 1;
		if F_x_y 
			ix = i;
			iy = i + 1;
		else
			ix = i + 1;
			iy = i;
		end
		XyChnList(ixy).x = chnList(ix);
		XyChnList(ixy).y = chnList(iy);
	end
	[Lestr, index, x0, y0] = FindNearChnPt_XY(XyChnList, x, y);
else
	[Lestr, index, x0, y0] = FindNearChnPt(chnList, x, y);
end

str2 = ['Channel="' Lestr '"; idx=' num2str(index) '; (' num2str(x0) ', ' num2str(y0) ')'];
set(handles.text1,'String', str2);

%=========================================================================
% --- Executes on button press in XYplot.
function XYplot_Callback(hObject, eventdata, handles)
% hObject    handle to XYplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%XYplot;
%XYplot.m this is a subroutine of MatrixPlot
FdifLine = get(handles.Fline,'Value');
FdifMark = get(handles.Fmark,'Value');
FHoldOn = get(handles.HoldOn,'Value');

rowstr = get(handles.nrows, 'String');
colstr = get(handles.ncols, 'String');

F_x_y = get(handles.Fxy,'Value');
Flegend = get(handles.Legend,'Value');

global chnList FxyPlot;
FxyPlot = 1; 

[selChn, nChns] = get_var_names(handles);
handles = guidata(gcbo);

if(nChns < 1)
	set(handles.text1,'String','No channel is selected !')
	return
end

[flist, nFiles] = get_file_names(handles);
if(nFiles < 1) 
	return;
end

[NewChnList, chStru] = loadChans_matrix(hObject, handles, selChn, nChns, flist, nFiles, rowstr, colstr );

if isempty(NewChnList)
	return
end

nNewChns = length(NewChnList);
if FHoldOn % hold on all old channels to replot all
    chnList = Link2ChnList(NewChnList, chnList)
else % only plot new channel
    hold off;
	chnList = NewChnList;
end

nchannels = length(chnList);
% Is even number of channels
[rest] = GetRest(nchannels, 2);
if rest ~= 0
	disp([num2str(nchannels) ' channels are selected.  It is not even number !']);
	return;
end 

% Transfer to XyChnList 
ixy = 0;
for i = 1:2:nchannels
	ixy = ixy + 1;
	if F_x_y 
		ix = i;
		iy = i + 1;
	else
		ix = i + 1;
		iy = i;
	end
	XyChnList(ixy).x = chnList(ix);
	XyChnList(ixy).y = chnList(iy);
end

if ixy < 1 
	disp('No channel is selected to do "X-Y Polt" !');
	return;
end

XyPlot(XyChnList, FdifLine, FdifMark, Flegend );

%----------------------------------------------------------



% --- Executes on button press in Fxy.
function Fxy_Callback(hObject, eventdata, handles)
% hObject    handle to Fxy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Fxy

% --- Executes on button press in Dist.
function Dist_Callback(hObject, eventdata, handles)
% hObject    handle to Dist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

globalsPlot;
[x1,y1] = ginput(1);
[x2,y2] = ginput(1);
dx = x1 - x2;
dy = y1 - y2;
[dist] = dist2Points(x1,y1,x2,y2);
str2 = ['dist=', num2str(dist) ';  (' num2str(dx) ', ', num2str(dy) ')' ];
set(handles.text1,'String', str2);



% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over listbox1.
function listbox1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press over listbox1 with no controls selected.
function listbox1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)





function nrows_Callback(hObject, eventdata, handles)
% hObject    handle to nrows (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of nrows as text
%        str2double(get(hObject,'String')) returns contents of nrows as a double

aa = get(handles.nrows, 'String');

% --- Executes during object creation, after setting all properties.
function nrows_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nrows (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ncols_Callback(hObject, eventdata, handles)
% hObject    handle to ncols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ncols as text
%        str2double(get(hObject,'String')) returns contents of ncols as a double

% --- Executes on button press in HoldOn.
function HoldOn_Callback(hObject, eventdata, handles)
% hObject    handle to HoldOn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of HoldOn


%=============================================================================
% --- Executes on button press in MatrixPlot.
function MatrixPlot_Callback(hObject, eventdata, handles)
% hObject    handle to MatrixPlot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.Fxsec = get(handles.Fsec,'Value');
FdifLine = get(handles.Fline,'Value');
FdifMark = get(handles.Fmark,'Value');
Fgrid = get(handles.Grid,'Value');
Flegend = get(handles.Legend,'Value');
FHoldOn = get(handles.HoldOn,'Value');


rowstr = get(handles.nrows, 'String');
colstr = get(handles.ncols, 'String');

global chnList FxyPlot;

FxyPlot = 0;

[selChn, nChns] = get_var_names(handles);
handles = guidata(gcbo);

if(nChns < 1)
	set(handles.text1,'String','No channel is selected !')
	return
end

[flist, nFiles] = get_file_names(handles);
if(nFiles < 1) 
	return;
end

[NewChnList, chStru] = loadChans_matrix(hObject, handles, selChn, nChns, flist, nFiles, rowstr, colstr );

if isempty(NewChnList)
	return
end

nchannels = length(chnList); % fortest+++
nNewChns = length(NewChnList);
if FHoldOn % hold on all old channels to replot all
    chnList = Link2ChnList(NewChnList, chnList)
else % only plot new channel
    hold off
	chnList = NewChnList;
end
nchannels = length(chnList);

PlotChnList_1D_v3(chnList, FdifLine, FdifMark, Flegend)

if(Fgrid)
	grid on;
else
	grid off
end

str2 = [num2str(nchannels)  '-channel plot'];
set(handles.text1,'String', str2);

%----------------------------------------------------------



% --- Executes during object creation, after setting all properties.
function ncols_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ncols (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%===========================================================
%add channel list ChnLst from New channel List = NewList
% if not existing
function [ChnLst_big] = Link2ChnList(NewList, ChnLst)
	nNewChns = length(NewList);
	nOld = length(ChnLst);
	ct = nOld;
	for i = 1: nNewChns
		%check if already exsiting in ChnLst
		Fexist = 0;
		for j = 1:nOld
			if strcmp(ChnLst(j).name, NewList(i).name)
				Fexist = 1;
				break;
			end			
		end
		if Fexist
			continue;
		end

		ct = ct +1;
		ChnLst(ct) = NewList(i);
	end
	ChnLst_big = ChnLst;
return
%----------------------------------



function [] = Help1()
clc
disp('File selection in upper list box: ');
disp('Double clicking to open a folder');
disp('Single clicking to select a mat file');
disp('Ctrl+ clicking to Multi files');
disp('------ ');
disp('Data selection in lower list box:');
disp('Single clicking to select a data channel');
disp('Ctrl+ clicking to Multi channles');
disp('------ ');
disp(['Example of row or column selection for M-Plot:']);
disp('1.Row=empty, Column= "2,5,7" means plot column 2, 5, 7 all points');
disp('2.Row="100-200", Column= "1,3" means plot colum 1,3 and points from 100 to 200');
disp('3.Row="1,3", Colum= "100-"  meas plot row 1,3 and points from 100 to end');
disp('------ ');
disp('Buttons: ');
disp('M-Plot - plot data channels ');
disp('X-Y Plot - Plot data channels in X-Y format.  First selected channel as X and second as Y');
disp('Distance - measure the distance of two points in the plotted figure ');
disp('Get Index - find the index of a point by clicking in the plotted figure' );
disp('------ ');
disp('Check Boxes:');
disp('Switch X-Y - to switch X and Y for X-Y plot' );
disp('Hold On - hold the current selected channels');
disp('X=second - use second as X unit, but channel "XIncr" must exists');

return;

% --- Executes on button press in Help.
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Help1();



% --- Executes on button press in Legend.
function Legend_Callback(hObject, eventdata, handles)
% hObject    handle to Legend (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Legend





function MarkIndex_Callback(hObject, eventdata, handles)
% hObject    handle to MarkIndexValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MarkIndexValue as text
%        str2double(get(hObject,'String')) returns contents of MarkIndexValue as a double


% --- Executes during object creation, after setting all properties.
function MarkIndexValue_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MarkIndexValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%=================================================================================
% --- Executes on button press in PlotMark.
function PlotMark_Callback(hObject, eventdata, handles)
% hObject    handle to PlotMark (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
globalsPlot;
global chnList FxyPlot;
F_x_y = get(handles.Fxy,'Value');

ptIdxStr = get(handles.MarkIndexValue,'String');
ptIdx = str2num(ptIdxStr);

nchannels = length(chnList);
if FxyPlot
	% Transfer to XyChnList 
	ixy = 0;
	for i = 1:2:nchannels
		ixy = ixy + 1;
		if F_x_y 
			ix = i;
			iy = i + 1;
		else
			ix = i + 1;
			iy = i;
		end
		XyChnList(ixy).x = chnList(ix);
		XyChnList(ixy).y = chnList(iy);
	end
	MarkIndexPtOfChnList_XY(XyChnList, ptIdx);
else
	MarkIndexPtOfChnList_1D(chnList, ptIdx)
end



function MarkIndexValue_Callback(hObject, eventdata, handles)
% hObject    handle to MarkIndexValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of MarkIndexValue as text
%        str2double(get(hObject,'String')) returns contents of MarkIndexValue as a double


