%VERSION 2.1  -  1/25/2008
function varargout = S7D(varargin)
% S7D M-file for S7D.fig
%      S7D, by itself, creates a new S7D or raises the existing
%      singleton*.
%
%      H = S7D returns the handle to a new S7D or the handle to
%      the existing singleton*.
%
%      S7D('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in S7D.M with the given input arguments.
%
%      S7D('Property','Value',...) creates a new S7D or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before S7D_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to S7D_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help S7D

% Last Modified by GUIDE v2.5 28-Jan-2008 07:01:09

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @S7D_OpeningFcn, ...
    'gui_OutputFcn',  @S7D_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before S7D is made visible.
function S7D_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to S7D (see VARARGIN)

% Choose default command line output for S7D
handles.output = hObject;
%Determine location of S7D program
handles.s7d_location = mfilename('fullpath');
prognamelength = length(mfilename); %Length of program name
handles.s7d_location = handles.s7d_location(1:end-prognamelength); 
%Determine temperorary directory location on users CPU to store application information.
handles.tmp_dir = tempdir;
defaultpathname = [handles.tmp_dir,'namedata.mat'];
A = eval([ 'exist(''' defaultpathname ''');' ]);
if A == 2
    load([handles.tmp_dir 'namedata.mat']);
else
    load([handles.s7d_location,'namedata.mat']);
end
%Needed subroutines need to be in search path
addpath(handles.s7d_location, '-begin');
addpath([handles.s7d_location 'GxMatLabLib'], '-begin');
%Determine if default directory exists
if isdir(app.defaultdir)==0
    app.defaultdir = cd;
end
%Set application information
set(handles.defdir_txt13,'string',app.defaultdir);
set(handles.Vehicles_ppm3,'string',char([{'Select Vehicle'},app.vehicle_cg{:,1}]));
set(handles.Vehicles_ppm3,'value',1);
% Vehicles_ppm3_Callback(hObject, eventdata, handles)

% Update handles structure
guidata(hObject, handles);
global rawdata %#ok<NUSED>
if isdir(app.workingdirectory)==0
    app.workingdirectory = cd;
end
save([handles.tmp_dir,'namedata.mat'],'app'); %Save Application Data
clear app
% UIWAIT makes S7D wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = S7D_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in NHTSA_Data_checkbox1.
function NHTSA_Data_checkbox1_Callback(hObject, eventdata, handles)
% hObject    handle to NHTSA_Data_checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of NHTSA_Data_checkbox1


% --- Executes on button press in StaticSelect_pb1.
function StaticSelect_pb1_Callback(hObject, eventdata, handles)
% hObject    handle to StaticSelect_pb1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global rawdata
load([handles.tmp_dir,'namedata.mat']);
%Load  Static File Variable from raw data [extension .dx3]
dx3names = {};
if get(handles.NHTSA_Data_checkbox1,'value')==1 %NHTSA data .dx3 extension
    DXload
    if exist('dx3file') && isstruct(Dt) %#ok<EXIST>
        fullname = [];
        fields = fieldnames(Dt);
        for kk = 1:length(fields)
            fullname = [fullname; {['Dt' '.' fields{kk}]}];
        end
        dx3names = [dx3names; fullname];
    end
else %is a file with *.mat extension
    [dx3file,pathname] = uigetfile('*.mat','Select Data Files For Processing',app.workingdirectory,'MultiSelect','off');
    if ischar(dx3file) && isdir(pathname)
        app.workingdirectory = pathname;
        save([handles.tmp_dir,'namedata.mat'],'app');
        filename = cellstr(dx3file);
        file2process = [deblank(pathname),deblank(filename{:})];
        load(file2process);
        vars = who('-file',file2process);
        dx3names = vars;
        for k = 1:length(vars)
            if isstruct(eval(vars{k}))
                fullname = [];
                fields = fieldnames(eval(vars{k}));
                for kk = 1:length(fields)
                    fullname = [fullname; {[vars{k} '.' fields{kk}]}];
                end
                dx3names = [dx3names; fullname];
            end
            if eval([ 'isnumeric(' deblank(char(vars(k)))  ')'])
                eval([deblank(char(vars(k))) ' = double(' deblank(char(vars(k))) ');' ]);
            end
        end

        clear k vars kk fullname fields
    else
        return
    end

end

if exist('dx3file')
    rawdata.dx3names = dx3names;
    %Save Static File Name to the handles structure.
    varnames;
    rawdata.staticfile = dx3file;
    set(handles.StaticFile_txt2,'string',['File: ', dx3file]);
    %Determine appropriate static sensor offset correction domain.
    %if ride hieght sensors exist then enter the distance between them.
    if exist('rawdata') && isfield(rawdata,'newha') &&...
            isempty(cell2mat(strfind(rawdata.newha(:,6), 'rh1')))==0 &&...
            isempty(cell2mat(strfind(rawdata.newha(:,6), 'rh2')))==0
        rawdata.dis1to2 = [];
        while isempty(rawdata.dis1to2)
            rawdata.dis1to2 = inputdlg('Enter distance between ride height sensors [Inches]','User Input For Roll Angle Calculation');
        end
        set(handles.rhs_distance_txt7,'string',['Distance Between Ride Height Sensors ', rawdata.dis1to2]);
    end
    %     VarsToZero
    result = 'Yes';
    while strcmp(result, 'Yes') || strcmp(result, 'Remove')
        qstring = [{'Would you like to alter list of variables to offset correct to zero'};...
            {'Choose Remove button to remove a varable from list to offset'};...
            app.vars2offset(:,1)];
        result =  questdlg(char(qstring),'Processing Settings','Yes','No','Remove','No');
        if isempty(result)
            return
        end
        if strcmp(result, 'Yes')
            [Selection,ok] = listdlg('liststring',rawdata.newha(:,1),...
                'PromptString','Select Variables To Offset',...
                'SelectionMode','multiple');
            if length(Selection)>=1 && ok==1
                app.vars2offset = [app.vars2offset; rawdata.newha(Selection,1:2)];
                clear Selection ok
            end
        end
        if strcmp(result, 'Remove')
            [Selection,ok] = listdlg('liststring',app.vars2offset(:,1),...
                'PromptString','Select Variables To Offset',...
                'SelectionMode','multiple');
            if length(Selection)>=1 && ok==1
                app.vars2offset(Selection,:) = [];
                clear Selection ok
            end
        end
        if length(app.vars2offset)>=1 % remove any repeated vars
            for v2o = 1:length(app.vars2offset(:,1))
                xxx = strmatch(app.vars2offset{v2o,1} ,char(app.vars2offset{:,1}),'exact');
                if length(xxx) > 1.5
                    app.vars2offset(xxx,:) = [];
                end
            end
        end
    end
    clear qstring result
    figure(2);
    scrsz = get(0,'ScreenSize');
    set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
    str{1} = 'Cycle through plots and determine best offset domain.';
    msgbox(char(str),'Static Sensor Offset Correction Domain')
    uiwait
    for k = 1:length(app.vars2offset(:,1))
        if max(strcmp(app.vars2offset(k,1),rawdata.newha(:,1)))==1
            eval(['plot(' app.vars2offset{k,1} ')']);
            eval([ 'ylabel('''  app.vars2offset{k,2} ''')' ]);
            xlabel('Data Count')
            title(['Static Sensor Offset Correction From File:   ' dx3file],'Interpreter','none')
            grid on;zoom on;figure(2);
            pause
            validvar = k;
        end
    end
    dlg_title = 'Interval For Mean Offset';
    prompt = {'Enter Start Count                                          |';...
        'Enter End Count                                            |'};

    if exist('validvar')
        defAns = {'1' ;num2str(length(eval([app.vars2offset{validvar,1}])))};
    else
        defAns = {'1' ;'1'};
    end

    num_lines = 1;
    options.Resize='on';
    options.WindowStyle='normal';
    rawdata.meananswer = inputdlg(prompt,dlg_title,num_lines,defAns,options);
    rawdata.meananswer = str2double(rawdata.meananswer);
    rawdata.vars2offset = [];
    %Comput offsets and store in a cell array for later use
    if isempty('rawdata.meananswer') == 0 && length(rawdata.meananswer(1))>=1 && length(rawdata.meananswer(2))>=1
        if rawdata.meananswer(2)>rawdata.meananswer(1) && rawdata.meananswer(1) > 0 && rawdata.meananswer(2)<=length(eval([app.vars2offset{validvar,1}]))
            for i = 1:length(app.vars2offset(:,1))
                if max(strcmp(app.vars2offset(i,1),rawdata.newha(:,1)))==1
                    rawdata.vars2offset = [rawdata.vars2offset; app.vars2offset(i,1)];
                    eval(['rawdata.MeanOffset{i} = mean(' app.vars2offset{i,1} '(rawdata.meananswer(1):rawdata.meananswer(2)));']);
                end
            end
            set(handles.ZeroStart_txt4,'string',['Mean Start Count: ' , num2str(rawdata.meananswer(1))]);
            set(handles.ZeroEnd_txt5,'string',['Mean End Count: ' , num2str(rawdata.meananswer(2))]);
        else
            errordlg([{'Interval Start or End Count Error.'}, {'Numbers must be positive and less than array length. Retry'}]);
        end
    else
        errordlg('Interval Start or End Count Error. Retry');
    end
    clear i
    for i = 1:length(dx3names(:,1))
        eval(['rawdata.' char(deblank(dx3names(i))) '= ' char(deblank(dx3names(i))) ';'])
    end
    clear str
    str{1} = 'Static offsets have been calculted from file';
    str{2} = rawdata.staticfile;
    str{3} = 'this step is complete.';
    msgbox(char(str),'Static Processing Status')
end
clear i k xxx prompt num_lines defAns validvar
close(figure(2))
save([handles.tmp_dir,'namedata.mat'],'app');


% --- Executes on button press in filter_button.
function filter_button_Callback(hObject, eventdata, handles)
% hObject    handle to filter_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global rawdata
load([handles.tmp_dir,'namedata.mat'],'app');

if isfield(rawdata,'staticfile')
    qstring = [{'Do you want to process files using information from '}, {char(rawdata.staticfile)}];
    result =  questdlg(char(qstring),'Processing Settings','Yes','No','Yes');
    if strcmp(result , 'Yes') && get(handles.NHTSA_Data_checkbox1,'value')==1
        [filename,pathname] = uigetfile('*.dx3','Select Data Files For Processing',app.workingdirectory,'MultiSelect','on');
    elseif strcmp(result , 'Yes') && get(handles.NHTSA_Data_checkbox1,'value')==0
        [filename,pathname] = uigetfile('*.mat','Select Data Files For Processing',app.workingdirectory,'MultiSelect','on');
    end
else
    msgbox('Press button labeled [Push to Select Static File] in program','YOU HAVE NOT SELECTED A STATIC FILE','modal')
    result = 'No';
end
clear qstring

%check to see if files were selected
if strcmp(result , 'Yes') && isfloat(filename)==0
    if iscell(filename)
        filename = sort(filename);
    end
    app.workingdirectory = pathname;
    save([handles.tmp_dir,'namedata.mat'],'app');
    filename = cellstr(filename);

    %Loop to filter and offset correct each file
    for i = 1:length(filename)
        Over_Range1 = 0;
        Over_Range_Start1 = 0;
        Over_Range_End1 = 0;
        Out_Dist1=0.25;
        Out_Width=10;
        set(handles.fileprocess_txt6,'string',['Processing ',deblank(filename{:,i})])
        file2process = [deblank(pathname),deblank(filename{:,i})];
        [pathstr, name, ext] = fileparts(file2process);
        if strcmp(ext, '.DX3') || strcmp(ext, '.Dx3') || strcmp(ext, '.dX3')
            ext='.dx3';
        end
        if strcmp(ext, '.MAT') || strcmp(ext, '.Mat') || strcmp(ext, '.MaT')
            ext='.dx3';
        end
        dx3names = {};
        switch ext
            case '.dx3' 
                [Dt] = LoadDxChannels(file2process);
                if isstruct(Dt)
                    fullname = [];
                    fields = fieldnames(Dt);
                    for kk = 1:length(fields)
                        fullname = [fullname; {['Dt' '.' fields{kk}]}];
                    end
                    dx3names = [dx3names; fullname];
                end
            case '.mat'
                vars = who('-file',file2process);
                dx3names = vars;
                load(file2process);
                for k = 1:length(vars)
                    if isstruct(eval(vars{k}))
                        fullname = [];
                        fields = fieldnames(eval(vars{k}));
                        for kk = 1:length(fields)
                            fullname = [fullname; {[vars{k} '.' fields{kk}]}];
                        end
                        dx3names = [dx3names; fullname];
                    end
                    if eval([ 'isnumeric(' deblank(char(vars(k)))  ')'])
                        eval([deblank(char(vars(k))) ' = double(' deblank(char(vars(k))) ');' ]);
                    end
                end

                clear k vars kk fullname fields ext name
        end
        % Determine time and samplerate = 1/p.XIncr
        rawdata.dx3names = dx3names;
        varnames;
        xxxx = strfind(rawdata.newha(:,6),'time');
        if isempty(xxxx)
            xxxx = strfind(rawdata.newha(:,6),'Time');
        end
        if isempty(xxxx) == 0
            xxxxx = find(cellfun('isempty', xxxx)<0.5,1);
            eval(['XIncr = ' rawdata.newha{xxxxx,1} '(4) - ' rawdata.newha{xxxxx,1} '(3);'])
            p.XIncr = XIncr;
        end
        if isempty(XIncr)
            samplerate = inputdlg('Enter Sampling Rate',...
                'Cannot Determine Sampling Rate',1,200);
            if isempty(str2double(samplerate))==0
                XIncr = 1/str2double(samplerate);
                p.XIncr = XIncr;
            else
                msgbox('Program Terminated','Invalid Sampling Rate','modal');
                return
            end
        end
        clear xxxx xxxxx samplerate

        for j = 1:length(rawdata.newha(:,1))
            eval(['rawdata.' rawdata.newha{j,1} ' = ' rawdata.newha{j,1} ';' ]);

            if iscell(rawdata.vars2offset)==1 && isempty(rawdata.vars2offset)==0
                offsetnum = strmatch(rawdata.newha{j,1} ,rawdata.vars2offset(:,1));
            else
                offsetnum = [];
            end

            if isempty(offsetnum) && rawdata.newha{j,5} == '0' && length(rawdata.newha{j,6}) >= 1
                eval(['p.' rawdata.newha{j,6} '= ' rawdata.newha{j,1} ';']);
            elseif isempty(offsetnum) && rawdata.newha{j,5} == '1' && length(rawdata.newha{j,6}) >= 1 && length(rawdata.newha{j,4}) >= 1
                eval(['p.' rawdata.newha{j,6} '= ButterFilter(' rawdata.newha{j,1} ',12, str2double(rawdata.newha{j,4}) ,1/XIncr) ;']);
            elseif isempty(offsetnum) == 0 && rawdata.newha{j,5} == '1' && length(rawdata.newha{j,6}) >= 1 && length(rawdata.newha{j,4}) >= 1
                if  strcmp(rawdata.newha{j,6}, 'rh1') || strcmp(rawdata.newha{j,6}, 'rh2')
                    button = 'No';
                    if isfield(p,'rh_spec')==0
                        p.rh_spec = [];
                    end
                    Bridge = {'No'};
                    while strcmp(button , 'No') || strcmp(button , 'Bridge')
                        eval(['[p.' rawdata.newha{j,6} ',no.outliers] = out_filt(' rawdata.newha{j,1} ',Out_Dist1,Out_Width,Over_Range1,Over_Range_Start1,Over_Range_End1);']);
                        eval(['p.' rawdata.newha{j,6} '= ButterFilter(p.' rawdata.newha{j,6} ',12, str2double(rawdata.newha{j,4}) ,1/XIncr) ;']);
                        figure(2);clf;
                        scrsz = get(0,'ScreenSize');
                        set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
                        grid on;hold on;zoom on;box on;
                        title(['Ride Height Sensor Filtering and Spike Removal For File: ' deblank(filename{:,i})],'Interpreter','none')
                        eval(['plot(' rawdata.newha{j,1} ');'])
                        eval(['plot(p.' rawdata.newha{j,6} ',''r'');'])
                        xlabel('Data Count')
                        ylabel(rawdata.newha{j,2})
                        qstring = ['If filtering is good Select Yes        ';...
                            'To increase outlier filter select No   ';...
                            'To Manually Bridge Spikes select Bridge'];
                        pause
                        button =  questdlg(qstring,'Ride Height Sensor Filtering','Yes','No','Bridge','Yes');
                        if strcmp(button , 'Bridge')
                            eval(['[' rawdata.newha{j,1} '_o]=' rawdata.newha{j,1} ';']);
                            eval(['[' rawdata.newha{j,1} ']=BridgeSpikes_v2(' rawdata.newha{j,1} ');']); %Remove obvious spikes by interpolating between two known good points.
                            button = 'No';
                            Out_Dist1 = 0;
                            Bridge = {'Bridged'};
                        elseif strcmp(button , 'No')
                            Out_Dist1=Out_Dist1+0.25;
                        end
                    end
                    p.rh_spec = [p.rh_spec; rawdata.newha(j,6) {Out_Dist1},Bridge];
                else
                    eval(['p.' rawdata.newha{j,6} '= ButterFilter(' rawdata.newha{j,1} ',12, str2double(rawdata.newha{j,4}) ,1/XIncr) - rawdata.MeanOffset{offsetnum};']);
                    if strcmp(rawdata.newha{j,6}, 'az_f')
                        p.az_f = p.az_f + 1; %offset vertical acc. to 1g
                    end
                end


            end
        end
        close(figure(2));
        %Calculate Roll Angle if p.rh1 and p.rh2 are defined rh = ride hieght+
        %Dis1to2 = distance that seperates the ride hieght sensors.
        %Does not compensate for overanging of sensors.  Happens at roll
        %angels typically above 25 degrees
        if isfield(p,'rh1') && isfield(p,'rh2') && isfield(rawdata,'dis1to2')
            p.rolla = 180/pi*atan((p.rh1-p.rh2)/str2double(char(rawdata.dis1to2)));
        end
        %If the variable p.swaf exists calculate steering wheel rate
        %Steering wheel rate and filter provided by General Motors
        if isfield(p,'swaf') && isfield(p,'XIncr')
            swr = gradient(p.swaf)./p.XIncr;     % steer velocity
            % Filter steer velocity with .10 sec  moving mean phaseless filter (filtfilt)
            span=fix(1/p.XIncr*.100);  %sample rate * time span = sample span
            b=ones(span,1);     % Filter coeffs
            a=length(b);           % Filter coeffs
            p.swrf=filtfilt(b,a,swr);
            % get rid of end effect artifacts of filter
            p.swrf(1:span)=0;
            p.swrf(end-span:end)=0;
            clear a b span swr
        end
        %Calculate Roll Acceleration from Roll Rate (rad/sec)
        if isfield(p,'rvx_f') && isfield(p,'XIncr')
            p.rax = diff(p.rvx_f*2*pi/360)/p.XIncr;
            % Pad the derivatives so they will be the same length as other vectors:
            p.rax = [p.rax; p.rax(end)];
        end
        %Calculate Pitch Acceleration from Pitch Rate (rad/sec)
        if isfield(p,'rvy_f') && isfield(p,'XIncr')
            p.ray = diff(p.rvy_f*2*pi/360)/p.XIncr;
            % Pad the derivatives so they will be the same length as other vectors:
            p.ray = [p.ray; p.ray(end)];
        end
        %Calculate Yaw Acceleration from Yaw Rate (rad/sec)
        if isfield(p,'rvz_f') && isfield(p,'XIncr')
            p.raz = diff(p.rvz_f*2*pi/360)/p.XIncr;
            % Pad the derivatives so they will be the same length as other vectors:
            p.raz = [p.raz; p.raz(end)];
        end

        p.date = date;
        file2save = [pathname 'p_' char(deblank(filename{:,i}))];
        save(file2save(1:end-4),'rawdata','p');
        clear i Dt Out_Dist1 OutWidth Over_Range1 Over_Range_End1 Over_Range_Start1...
            ans button k j no offsetnum p file2process qstring XIncr
        if exist('rawdata')
            fdnames = fieldnames(rawdata);
            rawdata = rmfield(rawdata, fdnames(8:end,1));
            rawdata.dx3names = {};
            rawdata.newha = {};
        end
    end
    clear str
    str{1} = 'Steps 1 through 3 are complete on files';
    str{2} = [deblank(char(filename{1})) ' through ' deblank(char(filename{end}))];
    str{3} = ['Original File path = ' pathname];
    msgbox(char(str),'Processing Status')
end








% --- Executes on button press in nameedit_pb3.
function nameedit_pb3_Callback(hObject, eventdata, handles)
% hObject    handle to nameedit_pb3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global rawdata
rawdata.edit = 1;
if isfield(rawdata,'newha')
    rawdata = rmfield(rawdata, {'newha'});
end
if isfield(rawdata,'dx3names')
    rawdata = rmfield(rawdata, {'dx3names'});
end

varnames;

if isfield(rawdata,'edit')
rawdata = rmfield(rawdata,'edit');
end




% --- Executes on button press in vehicleselection_pb5.
function vehicleselection_pb5_Callback(hObject, eventdata, handles)
% hObject    handle to vehicleselection_pb5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
load([handles.tmp_dir,'namedata.mat']);
collabels = {'Vehicle Description','Long. C.G.[in]','Lat. C.G.[in]','Vert. C.G.[in]','Long. Sensor Offset[in]','Lat Sensor Offset[in]','Vert. Sensor Offset[in]'};
colwidth = [10 10 10 10 10 10 10];
if isfield(app,'vehicle_cg') == 1
    newline = [{'Enter New Vehicle'},cell([1,6])];
    qstring = ['To Enter New Or To Change Vehicle         ';...
        'Information Press Yes Button              ';];
    button =  questdlg(qstring,'Vehicle List Update','Yes','View List','Yes');
    if strcmp(button ,'Yes')
        app.vehicle_cg = [newline;app.vehicle_cg];
    end
    P = struct('modal',1, 'nVisibleRows',19,'nVisibleCols',4,'colWidth',colwidth );
    P.colLabels = collabels;
    set(figure(2),'CloseRequestFcn','my_closereq');
    haxes = axes('units','pixels','position',[10 10 525 400]);
    app.vehicle_cg = uitable(haxes,app.vehicle_cg,P);
    if isempty(app.vehicle_cg)
        errordlg('Information NOT SAVED!');
        return
    end
    set(handles.Vehicles_ppm3,'string',char([{'Select Vehicle'},app.vehicle_cg{:,1}]));
    set(handles.Vehicles_ppm3,'value',1);
elseif isfield(app,'vehicle_cg') == 0 % No vehicle information has been stored
    vehicle_cg = cell([40,7]);
    P = struct('modal',1, 'nVisibleRows',19,'nVisibleCols',4,'colWidth',colwidth );
    P.colLabels = collabels;
    set(figure(2),'CloseRequestFcn','my_closereq');
    haxes = axes('units','pixels','position',[10 10 525 400]);
    app.vehicle_cg = uitable(haxes,vehicle_cg,P);
end
A = cellfun('isempty',app.vehicle_cg(:,1));
vehicle_cg = {};
for k = 1:length(A(:,1))
    if A(k,1) == 0
        vehicle_cg = [vehicle_cg; app.vehicle_cg(k,:)];
    end
end
clear newline
% if length(vehicle_cg(:,1)) < 50
%     app.vehicle_cg = [vehicle_cg; cell([(50-length(vehicle_cg(:,1))),7])];
% end
app.vehicle_cg = vehicle_cg;
save([handles.tmp_dir,'namedata.mat'], 'app');
save([handles.s7d_location,'namedata.mat'], 'app');
clear k newline A vehicle_cg P button qstring collabels colwidth haxes
% clear app haxes P colwidth collabels vehicle_cg newline



% --- Executes on button press in filecorrecton_pb6.
function filecorrecton_pb6_Callback(hObject, eventdata, handles)
% hObject    handle to filecorrecton_pb6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% global rawdata
if isfield(handles,'vehlistnum')
    load([handles.tmp_dir,'namedata.mat']);

    %Offsets Obtained from vehicle list
    %Check to make sure there are entries for the offsets
    if isempty(app.vehicle_cg{handles.vehlistnum-1,5})==0 || isempty(app.vehicle_cg{handles.vehlistnum-1,2})
        LongitOffset = (str2double(app.vehicle_cg{handles.vehlistnum-1,5})-str2double(app.vehicle_cg{handles.vehlistnum-1,2}))/12;
    else
        errordlg('One of the boxes for the offsets is empty [X Direction]. Retry');
        return
    end

    if isempty(app.vehicle_cg{handles.vehlistnum-1,6})==0 || isempty(app.vehicle_cg{handles.vehlistnum-1,3})
        LatOffset = (str2double(app.vehicle_cg{handles.vehlistnum-1,6})-str2double(app.vehicle_cg{handles.vehlistnum-1,3}))/12;
    else
        errordlg('One of the boxes for the offsets is empty [Y Direction]. Retry');
        return
    end

    if isempty(app.vehicle_cg{handles.vehlistnum-1,7})==0 || isempty(app.vehicle_cg{handles.vehlistnum-1,4})
        if str2double(app.vehicle_cg{handles.vehlistnum-1,7})==0 && str2double(app.vehicle_cg{handles.vehlistnum-1,4})==0
            VertOffset = 0;
        else %Below was commented out on 11-2-2007 - statement is incorrect
%             qstring = ['One or both of the values used to calculate vertical      ';...
%                 'offset is non-zero.  Do you wish to use the nonzero value?';...
%                 'FOR NHTSA COMPLIANCE PROCEDURE SELECT NO !               ';];
%             button =  questdlg(qstring,'Offset Entry','Yes','No','Yes');
%             if strcmp(button , 'Yes')
                VertOffset = (str2double(app.vehicle_cg{handles.vehlistnum-1,7})-str2double(app.vehicle_cg{handles.vehlistnum-1,4}))/12;
%             else
%                 VertOffset = 0;
%             end
        end

    else
        errordlg('One of the boxes for the offsets is empty [Z Direction]. Retry');
        return
    end



    [filename,pathname] = uigetfile('*.mat','Select Data Files For Correction',app.workingdirectory,'MultiSelect','on');

    if isfloat(filename)==0
        if iscell(filename)
            filename = sort(filename);
        end
        app.workingdirectory = pathname;
        save([handles.tmp_dir,'namedata.mat'],'app');
        filename = cellstr(filename);
        for i = 1:length(filename)
            file2process = [deblank(pathname),deblank(filename{:,i})];
            load(file2process,'p');
            set(handles.fileprocess_txt10,'string',['Processing ',deblank(filename{:,i})]);
            pause(0.05);
            if exist('p') && isfield(p,'ay_f') && isfield(p,'ax_f') &&...
                    isfield(p,'rvx_f') && isfield(p,'rvz_f') && isfield(p,'rolla')
                % Convert degrees to radians:
                RVX = p.rvx_f/(360/(2*pi));
                RVY = p.rvy_f/(360/(2*pi));
                RVZ = p.rvz_f/(360/(2*pi));
                % Acceleration is in radians
                RAX = p.rax;
                RAY = p.ray;
                RAZ = p.raz;
                % Acceleration in g's
                AXCG_F = p.ax_f;
                AYCG_F = p.ay_f;
                if isfield(p,'az_f') == 1
                    AZCG_F = p.az_f;
                else
                    AZCG_F = ones([length(p.ay_f),1]);
                end
                %Check to see if p.axcg or p.aycg or p.azcg exist
                if isfield(p,'axcg') || isfield(p,'aycg') || isfield(p,'azcg')
                    str = [{'p.axcg or p.aycg or p.axcg'};{'Where found in this file.'};...
                        {'Do you wish to continue processing file'};{deblank(filename{:,i})}];
                    button =  questdlg(str,'Continue Processing','Yes','No','Yes');
                    if strcmp(button, 'No') || isempty(button)
                        clear str button p RAX RAY RAZ AXCG_F AYCG_F AZCG_F RVX RVZ RVY
                        continue
                    end
                end
                %Correction are made to acceleration channels for sensor offset
                %for C.G.
                p.axcg = AXCG_F - (RVY.^2 + RVZ.^2) * LongitOffset/32.17417 + (RVY .* RVX - RAZ) * LatOffset/32.17417 + (RVZ .* RVX + RAY) * VertOffset/32.17417;  % Longitudinal acceleration of displaced CG
                p.aycg = AYCG_F + (RVY .* RVX + RAZ) * LongitOffset/32.17417 - (RVX.^2 + RVZ.^2) * LatOffset/32.17417 + (RVZ .* RVY - RAX) * VertOffset/32.17417;  % Lateral acceleration of displaced CG
                p.azcg = AZCG_F + (RVZ .* RVX - RAY) * LongitOffset/32.17417 + (RVZ .* RVY + RAX) * LatOffset/32.17417 - (RVX.^2 + RVY.^2) * VertOffset/32.17417;  % Vertical acceleration of displaced CG
                %Correct lateral acceleration for roll angle.
                deg2rad=pi/180;
                p.aycg=p.aycg.*cos(deg2rad.*p.rolla)+p.azcg.*sin(deg2rad.*p.rolla);
                p.aycr=p.ay_f.*cos(deg2rad.*p.rolla)+p.az_f.*sin(deg2rad.*p.rolla);
                if isfield(p,'snsoffsetcg')
                    p.snsoffsetcg = [p.snsoffsetcg; LongitOffset, LatOffset,  VertOffset];
                else
                    p.snsoffsetcg = [LongitOffset, LatOffset,  VertOffset];
                end
                save(file2process,'-append','p');
                clear p RVX RVY RVY RAX RAY RAZ AXCG_F AZCG_F AYCG_F str button
            else
                errordlg(['You are missing or miss-labeled one or more of the following variables [p, p.ax_f, p.ay_f, p.rvx_f, p.rvz_f, p.rolla]. Skipping Test  ',deblank(filename{:,i})]);
                continue
            end
            
        end
        str{1} = 'Steps 4 and 5 are complete on files';
        str{2} = [deblank(char(filename{1})) ' through ' deblank(char(filename{end}))];
        str{3} = ['Original File path = ' pathname];
        msgbox(char(str),'Processing Status')
    end

else
    errordlg('Please select a vehicle from the list in the popup menu.');
end
clear app LatOffset LongitOffset VertOffset filename pathname i str



% --- Executes on selection change in Vehicles_ppm3.
function Vehicles_ppm3_Callback(hObject, eventdata, handles)
% hObject    handle to Vehicles_ppm3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Vehicles_ppm3 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Vehicles_ppm3

handles.vehlistnum = get(handles.Vehicles_ppm3,'Value');
if handles.vehlistnum == 1
    errordlg('Please select a vehicle from the list in the popup menu.');
    return
end
guidata(hObject, handles);
load([handles.tmp_dir,'namedata.mat'])
list = [{app.vehicle_cg{handles.vehlistnum-1,1}};...
    ['CG [xyz]       ',app.vehicle_cg{handles.vehlistnum-1,2} '  ',...
    app.vehicle_cg{handles.vehlistnum-1,3},'  ',...
    app.vehicle_cg{handles.vehlistnum-1,4}];...
    ['Sensor [xyz]   ',app.vehicle_cg{handles.vehlistnum-1,5} '  ',...
    app.vehicle_cg{handles.vehlistnum-1,6},'  ',...
    app.vehicle_cg{handles.vehlistnum-1,7}]];
set(handles.vehicleselection_txt8,'string',char(list))
guidata(hObject, handles);
% --- Executes during object creation, after setting all properties.
function Vehicles_ppm3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Vehicles_ppm3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in s7dmetrics_pb7.
function s7dmetrics_pb7_Callback(hObject, eventdata, handles)
% hObject    handle to s7dmetrics_pb7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% global rawdata
load([handles.tmp_dir,'namedata.mat'],'app');

if isfield(handles,'vehlistnum')==0
    errordlg('Please select a vehicle from the list in the popup menu.');
    return
end
%Determin Vehicle being evaluated.
vehiclelist = get(handles.Vehicles_ppm3,'string');
vehicle = vehiclelist(handles.vehlistnum,:);
if strcmp(vehicle ,'Select Vehicle')
    errordlg('Please select a vehicle from the list in the popup menu.');
    return
end

load([handles.tmp_dir,'namedata.mat']);
[filename,pathname] = uigetfile('*.mat','Select Data Files To Calculate Metrics',app.workingdirectory,'MultiSelect','on');

if isfloat(filename)==0
    if iscell(filename)
        filename = sort(filename);
    end
    app.workingdirectory = pathname;
    save([handles.tmp_dir,'namedata.mat'],'app');
    filename = cellstr(filename);
    OutputValuesM = [];
    for i = 1:length(filename)
        file2process = [deblank(pathname),deblank(filename{:,i})];
        load(file2process,'p');
        set(handles.File_txt11,'string',['Processing ',deblank(filename{:,i})]);
        pause(0.05);
        %check for needed variables
        if exist('p')==0
            errordlg(['Missing Variables [p.aycg,p.swaf,p.swrf,p.time,p.XIncr,p.rvz_f]. Skipping Test  ',deblank(filename{:,i})]);
            continue
        elseif exist('p')==1 && isfield(p,'aycg')==0
            errordlg(['Missing Variable [p.aycg]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        elseif exist('p')==1 && isfield(p,'swaf')==0
            errordlg(['Missing Variables [p.swaf,p.swrf]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        elseif exist('p')==1 && isfield(p,'time')==0
            errordlg(['Missing Variables [p.time]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        elseif exist('p')==1 && isfield(p,'XIncr')==0
            errordlg(['Missing Variables [p.XIncr]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        elseif exist('p')==1 && isfield(p,'rvz_f')==0
            errordlg(['Missing Variables [p.rvz_f]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        elseif exist('p')==1 && isfield(p,'spd')==0
            errordlg(['Missing Variables [p.spd]. Skipping Test  ',deblank(filename{:,i})]);
            clear p
            continue
        end
        %Begin Search for 1st instance that steering rate reaches 75deg/sec
        %and is sustanined for atleast 175ms.
        swar75 = 1; %Default swar75 count number
        while abs(p.swrf(swar75+round(0.175/p.XIncr)))<75 && swar75+round(0.175/p.XIncr)<length(p.swaf)
            swar75 = swar75+round(0.150/p.XIncr);
            trackpt = swar75;
            swar75 = find(abs(p.swrf(trackpt:end)) >= 75);
            swar75 = swar75(1)+trackpt-1;
        end
        %If swar75 cannot be determined terminate the program
        if isempty(swar75)
            str{1} = 'COULD NOT DETERMINE TIME';
            str{2} = 'STEERING RATE IS AT 75 deg/sec';
            str{3} = ['Skipping File  ',deblank(filename{:,i})];
            h = msgbox(char(str),'Start Steering Error');
            uiwait(h);
            clear p swar75 h
            continue
        end
        
        %Dynamic Zeroing
        if swar75(1)>1.0/p.XIncr+1
            swaf = p.swaf - mean(p.swaf(swar75(1)-round(1.0/p.XIncr):swar75(1)));
            rvz_f = p.rvz_f - mean(p.rvz_f(swar75(1)-round(1.0/p.XIncr):swar75(1)));
            aycg = p.aycg - mean(p.aycg(swar75(1)-round(1.0/p.XIncr):swar75(1)));
            MES = mean(p.spd(swar75(1)-round(0.5/p.XIncr):swar75(1))); % Maneuver Entrance Speed - 500ms Interval
            meanstart = swar75(1)-round(1.0/p.XIncr);            
        else
            swaf = p.swaf - mean(p.swaf(1:swar75(1)));
            rvz_f = p.rvz_f - mean(p.rvz_f(1:swar75(1)));
            aycg = p.aycg - mean(p.aycg(1:swar75(1)));
            MES = mean(p.spd(1:swar75(1))); % Maneuver Entrance Speed
            meanstart = 1;
        end

        % Refine search for beginning of steering input to nearest point to 5 degrees
        SWA5 = find((swaf(swar75(1):swar75(1)+round(0.4/p.XIncr)))*sign(swaf(swar75(1)+round(0.4/p.XIncr))) >= 5);
        if isempty(SWA5)
            str{1} = 'COULD NOT DETERMINE TIME';
            str{2} = 'THAT STEERING REACHES 5 DEGREES';
            str{3} = ['Skipping File  ',deblank(filename{:,i})];
            h = msgbox(char(str),'Start Steering Error                         ');
            uiwait(h);
            clear p swar75 str h
            continue
        end
        % Correct for count offset
        SWA5 = SWA5(1) + swar75(1) - 1;
        % Begin 5 degree interpolation - linear fit
        time5 = interp1([abs(swaf(SWA5-1)) abs(swaf(SWA5))],[p.time(SWA5-1) p.time(SWA5)],5);
        % EventPt is defined as time or count number closest to SWA passing
        % through 5 degrees.
        EventPt = SWA5;
        % Time at 1.07s after Steer begin
        time107 = time5+1.070;
        % Nearest Count number to time107
        count107 = SWA5+round(1.070/p.XIncr);
        % Begin search for Completion on Steer (COS) event.  End of sine curve
        % that overshoots zero.  When Steering rate drops below 45 deg/sec
        cos45 = find(sign(p.swrf(SWA5))*p.swrf(count107:count107+round(1.15/p.XIncr)) >= 45);
        if isempty(cos45)
            str{1} = 'COULD NOT DETERMINE';
            str{2} = 'END OF STEERING INPUT';
            str{3} = ['Skipping File  ',deblank(filename{:,i})];
            h = msgbox(char(str),'Steering Error');
            uiwait(h);
            clear ptcos cos45 count107 EventPt time5 SWA5 p swar75 str h
            continue            
        end
        cos45 = cos45(end)+count107-1;
        meanswa45 = mean(swaf(cos45:cos45+round(0.10/p.XIncr)))+sign(swaf(count107))*0.1; % 200ms interval
        cos = find(sign(swaf(count107))*swaf(cos45-round(0.25/p.XIncr):cos45+round(0.025/p.XIncr)) <= 0, 1);
        %COS = time at 0degree for cases where the average SWA opposite the
        %SWA at count107 or time = 1.07s into maneuver.
        if isequal(sign(meanswa45), sign(swaf(count107))) == 0  || isempty(cos)==0
            meanswa45 = 0;
        end
        
        cos = find(sign(swaf(count107))*swaf(count107:cos45+round(0.25/p.XIncr)) <= sign(swaf(count107))*meanswa45);
        if isequal(sign(meanswa45), sign(swaf(count107))) == 1 && abs(meanswa45)>0
%             swaendmean = mean(swaf(EventPt+round(2.00/p.XIncr):EventPt+round(2.15/p.XIncr)));
%             cos = find(sign(swaf(count107))*swaf(count107:EventPt+round(2.3/p.XIncr)) <= sign(swaf(count107))*swaendmean+0.1);
            str{1} = 'COULD NOT DETERMINE COS AT';
            str{2} = ['ZERO FOR FILE:  ', char(deblank(filename{:,i}))];
            str{3} = ' ';
            str{4} = 'USED MEAN SWA @ SWA45 deg/sec';
            str{5} = ['MEAN SWA USED:  ' , num2str(meanswa45)];
            str{6} = 'HIT ENTER TO CONTINUE';
            h = msgbox(char(str),'Completion of Steer (COS) Error');
            uiwait(h);
            clear str h 
        end
        cos = cos(1) + count107 - 1;        
        % Exact Time at COS event - Interpolated
        timecos = interp1([(swaf(cos-1)) (swaf(cos))],[p.time(cos-1) p.time(cos)],meanswa45);
        targetswa = 0;
        while isnan(timecos) && abs(targetswa)<10
            timecos = interp1([(swaf(cos-2)) (swaf(cos+1))],[p.time(cos-2) p.time(cos+1)],targetswa);
            targetswa = targetswa+0.05*sign(swaf(cos));
        end
        %If timecos could not be determined let user know and then continue
        %with next test
        if isnan(timecos)
            str = [{'COULD NOT DETERMINE'};{'END OF STEERING INPUT'};...
                {['Skipping File  ',deblank(filename{:,i})]}];
            h = msgbox(char(str),'Steering Error');
            uiwait(h);
            clear ptcos cos45 count107 EventPt time5 SWA5 p swar75...
                str h timecos cos targetswa meanswa45 cos45
            continue
        end
        %reset cos(count number) to within one data count of timecos if
        %initial interpolation of timecos resulted in an NaN.
        if abs(targetswa) > 0.025
            cos = find(p.time > timecos);
            cos = cos(1);
        end
        % Determine Steering Angles - based on count numbers
        %1st Steering Peak
        [intswapeak intswapeak_ct] = max(abs(swaf(SWA5:SWA5+round(0.65/p.XIncr))));
        intswapeak_ct = intswapeak_ct + SWA5 - 1;
        %2nd Steering Input Average - Average is taken in the middle of
        %the Dwell
        revswamean125equal = sign(swaf(count107))*mean(swaf(SWA5+round(1.196/p.XIncr):SWA5+round(1.446/p.XIncr)));
        %Determine SWA zero crossing in the middle of steering profile
        mos = find(sign(swaf(EventPt))*swaf(EventPt+round(0.05/p.XIncr):count107) <= 0);
        mos = mos(1) + EventPt+round(0.05/p.XIncr) - 1;
        mostime = interp1([swaf(mos-1) swaf(mos)],[p.time(mos-1) p.time(mos)],0);
           
        %Determine the times for YRR metrics and the nearest count numbers
        %to them.
        timeyrr1 = timecos+1.00; %YRR 1.00s Time
        timeyrr175 = timecos+1.75; %YRR 1.75s Time
        countyrr1 = cos + round(1.00/p.XIncr); %Nearest count number at YRR1
        countyrr175 = cos + round(1.75/p.XIncr); %Nearest count number at YRR175
%         countyrr1 = round(timeyrr1/p.XIncr); %Nearest count number at YRR1
%         countyrr175 = round(timeyrr175/p.XIncr); %Nearest count number at YRR175
        %In event that there was not enough data collected to determine YRR1
        if countyrr1+2 > length(p.rvz_f)
            str = [{'File Length Is Too Short'};{'To Determine YRR1'};...
                {['Skipping Test ',deblank(filename{:,i})]}];
            h = msgbox(char(str),'Yaw Rate Ratio Error');
            uiwait(h);
            continue
        end
        %In event that there was not enough data collected to determine YRR175
        if countyrr175+2 > length(p.rvz_f)
            countyrr175 = length(p.rvz_f)-3;
            timeyrr175 = p.time(countyrr175);
            str{1} = 'File Length Is Too Short';
            str{2} = 'To Determine YRR175';
            h = msgbox(char(str),'Yaw Rate Ratio Error');
            uiwait(h);
        end
                       
        %determine 2nd yaw peak (1st local peak that results from the
        %reversal steering input)
        raz = ButterFilter(p.raz,12,6,1/p.XIncr); %filter Rot. Accel about Z axis
        %Search raz to find zero after the reversal steering input has begun
        raz_zero = find(sign(rvz_f(cos-round(0.5/p.XIncr)))*raz(count107-round(0.2/p.XIncr):cos) <= 0);
        if isempty(raz_zero)
            raz_zero = cos;
        else
            raz_zero = raz_zero(1) + count107 - round(0.2/p.XIncr) - 1; %Correct for narrowing search domain
        end
        %Determine Yaw Peak 2
        [yp2 yp2_ct] = max(sign(rvz_f(cos-round(0.5/p.XIncr)))*(rvz_f(count107-round(0.2/p.XIncr):raz_zero+round(0.075/p.XIncr))));
        yp2_ct = yp2_ct + count107-round(0.2/p.XIncr) - 1;
        yp2 = sign(rvz_f(cos-round(0.5/p.XIncr)))*yp2;
        
        %Interpolate to determine YRR1 and YRR175
        %YRR1
        yr1 = interp1([p.time(countyrr1-2) p.time(countyrr1+2)],[rvz_f(countyrr1-2) rvz_f(countyrr1+2)],timeyrr1); %Linear Interpolation Function
        yrr1 = interp1([p.time(countyrr1-2) p.time(countyrr1+2)],[rvz_f(countyrr1-2) rvz_f(countyrr1+2)],timeyrr1)/yp2*100; %Linear Interpolation Function
        %YRR175
        %yrr175 = interp1(p.time(1:length(rvz_f)),rvz_f,timeyrr175)/yp2*100; %Linear Interpolation Function
        yr175 = interp1([p.time(countyrr175-2) p.time(countyrr175+2)],[rvz_f(countyrr175-2) rvz_f(countyrr175+2)],timeyrr175); %Linear Interpolation Function
        yrr175 = interp1([p.time(countyrr175-2) p.time(countyrr175+2)],[rvz_f(countyrr175-2) rvz_f(countyrr175+2)],timeyrr175)/yp2*100; %Linear Interpolation Function
        
        
        %Calculate Lateral Displacement from corrected Lateral Acceleration
        %Lateral Velocity
        LatVelCalc_CD2 = cumtrapz(aycg*32.17417)*p.XIncr; %Feet Conversion
        %LatVelCalc_CD2 = cumtrapz(aycg/9.80665*32.17417)*XIncr; %Metric to Feet Conversion
        %Zero using interpolation ime at 5 degrees
        LatVelCalc_CD2 = LatVelCalc_CD2 - interp1(p.time(1:length(swaf)),LatVelCalc_CD2,time5);
        %Lateral Displacement
        LatdispCalc_CD2 = cumtrapz(LatVelCalc_CD2)*p.XIncr;
        %Zero using interpolation time at 5 degrees
        LatdispCalc_CD2 = LatdispCalc_CD2 - interp1(p.time(1:length(swaf)),LatdispCalc_CD2,time5);
        %Interpolate Lateral Displacement at time107
        latdisp107 = interp1(p.time(1:length(swaf)),LatdispCalc_CD2,time107);
        %Interpolate Lateral Acceleration at time107
        latacc107 = interp1(p.time(1:length(swaf)),aycg,time107); 

        %Plot Results
        figure(4);clf;
        scrsz = get(0,'ScreenSize'); %returns size of users computer screen
        set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]); %set figure to 90% of users screen size
        subplot(2,2,1:2);
        plot(p.time(1:length(swaf)),swaf,'linewidth',2)
        hold on;grid on;
        plot(p.time(SWA5),swaf(SWA5),'go','MarkerEdgeColor','k',...
            'MarkerFaceColor','g','MarkerSize',8,'linewidth',2)
        plot(timecos,interp1(p.time(1:length(swaf)),swaf,timecos),'ro','MarkerEdgeColor','k',...
            'MarkerFaceColor','r','MarkerSize',8,'linewidth',2)
        plot(p.time(SWA5+round(1.196/p.XIncr):SWA5+round(1.446/p.XIncr)),swaf(SWA5+round(1.196/p.XIncr):SWA5+round(1.446/p.XIncr)),'k','linewidth',5)
        axis([p.time(meanstart) p.time(countyrr175)+0.5 min(swaf(meanstart:meanstart+round(2.8/p.XIncr)))-30 max(swaf(meanstart:meanstart+round(2.8/p.XIncr)))+30]);
        legend('SWA','SWA5deg','COS','Mean SWA','location','best')
        h = title('','Interpreter','none');set(h,'string',file2process)
        xlabel('Time (s)');
        ylabel('Angle (deg)');

        subplot(2,2,3:4);
        plot(p.time(1:length(swaf)),rvz_f,'linewidth',2)
        hold on;grid on;
        plot(p.time(yp2_ct),rvz_f(yp2_ct),'go','MarkerEdgeColor','k',...
            'MarkerFaceColor','g','MarkerSize',8,'linewidth',2)
        plot(p.time(countyrr1),rvz_f(countyrr1),'ro','MarkerEdgeColor','k',...
            'MarkerFaceColor','r','MarkerSize',8,'linewidth',2)
        plot(p.time(countyrr175),rvz_f(countyrr175),'bo','MarkerEdgeColor','k',...
            'MarkerFaceColor','b','MarkerSize',8,'linewidth',2)
        axis([p.time(meanstart) p.time(countyrr175)+0.5 min(rvz_f(meanstart:cos+round(0.5/p.XIncr)))-10 max(rvz_f(meanstart:cos+round(0.5/p.XIncr)))+10]);
        legend('Yaw','YP2','YRR1','YRR175','location','best')
        xlabel('Time (s)');
        ylabel('Yaw Rate (deg/sec)')
        pause
        
        figure(4);clf;
        subplot(2,2,2)
        plot(p.time(1:length(swaf)),swaf,'linewidth',2);
        hold on;grid on;
        plot(p.time(swar75(1)),swaf(swar75(1)),'k*','linewidth',3)
        plot(p.time(SWA5),swaf(SWA5),'g*','linewidth',3)
        axis([p.time(meanstart) p.time(meanstart+round(2.0/p.XIncr)) min(p.swaf(EventPt:cos))-30 max(p.swaf(EventPt:cos))+30]);
        legend('SWA','time@75deg/sec','time@5deg');
        xlabel('Time (s)');
        ylabel('Angle (deg)');

        subplot(2,2,1)
        plot(p.time(1:length(swaf)),LatdispCalc_CD2,'linewidth',2);
        hold on;grid on;zoom on;
        plot(p.time(EventPt),LatdispCalc_CD2(EventPt),'g*','linewidth',2)
        plot(p.time(count107),LatdispCalc_CD2(count107),'r*','linewidth',2)
        axis([p.time(meanstart) p.time(SWA5+round(2.0/p.XIncr)) -25 25]);
        xlabel('time (s)');
        ylabel('Lateral Position (ft)');
        h = title('','Interpreter','none');set(h,'string',file2process)
        legend('Lateral Position','time@5deg','Pos. @ 1.07s')

        subplot(2,2,3:4)
        %     plot(x.time,x.swaf,'linewidth',2);
        hold on;grid on;
        plot(p.time(1:length(swaf)),swaf,'linewidth',2);
        plot(p.time(SWA5),swaf(SWA5),'g*','linewidth',3)
        plot(p.time(swar75(1)),swaf(swar75(1)),'k*','linewidth',3)
        axis([p.time(meanstart) p.time(SWA5+round(0.5/p.XIncr)) -30 30]);
        legend('SWA','time@5deg','time@75deg/sec');
        xlabel('Time (s)');
        ylabel('Angle (deg)');
        drawnow


        %Create Output Matrix
        OutputValuesM = [OutputValuesM; filename(i) {vehicle}...
            EventPt MES time5 cos timecos mos mostime yrr1 yr1 countyrr1...
            yrr175 yr175 countyrr175 yp2 yp2_ct latdisp107 latacc107 intswapeak intswapeak_ct...
            revswamean125equal];
        
        %Rename Calculated Lateral Displacement as a field in structure p
        p.dx_calc = LatdispCalc_CD2;
        %Alphabetically order fields of structure p
        p = orderfields(p);
        %Save Calculated Lateral Displacement to structure p
        save(file2process,'-append','p');

        pause
        clear EventPt time5 cos timecos mos mostime yrr1 countyrr1...
            yrr175 countyrr175 yp2 yp2_ct latdisp107 intswapeak intswapeak_ct...
            revswamean125equal p LatdispCalc_CD2 cout107 trackpt swar75...
            SWA5 time5 time107 count107 ptcos swaendmean timeyrr1 timeyrr175...
            LatVelCalc_CD2 meanswa45 cos45 MES yr1 yr175 latacc107
    end

    %Create Header Line for output file
    MnemonicsString = {'File      ';'Vehicle';'SWA @ 5deg Ct';'MES';'Time@5deg';'COS';'Time@COS';...
        'MOS';'Time@MOS';'YRR1(%)';'YR1 (deg/sec)';'YRR1 Ct';'YRR175(%)';'YR175 (deg/sec)';'YRR175 Ct';'2nd Yaw Peak(deg/sec)';'2nd Yaw Peak Ct';...
        'Lat Disp (ft)';'Lat. Acc. 1.07s (g)';...
        '1st SWA Peak(deg)';'1st SWA Peak Ct';'2nd SWA Mean(deg)';}; %...

    strt = char(filename{1});
    stp = char(filename{end});

    % OutName=['N:\ESCHandling\S7D_Metrics_Output_11-16-06\S7D_Metrics____' char(vehicle) '____' strt(1:(end-4)) '-' stp(1:(end-4))];
    %     OutName=['N:\ESCHandling\S7D_Metrics_Output_11-16-06\FromNewProgram\S7D_MetricsV2____' char(vehicle) '____' strt(1:(end-4)) '-' stp(1:(end-4))];
    OutName=[app.defaultdir '\S7D_V2__' deblank(char(vehicle)) '__' strt(1:(end-4)) '-' stp(1:(end-4))];

    % OutName=['N:\ESCHandling\_2005VariabilityStudy\S7D_OuputMetrics\S7D_Metrics____' char(vehicle) '____' strt(1:(end-4)) '-' stp(1:(end-4))];
    % N:\ESCHandling\_2005VariabilityStudy\S7D_OuputMetrics
    OutNameCheck = [OutName '.xls'];
    [FName,PName] = uiputfile('*.xls','Save As',OutName);
    OutName = [PName,FName];
    if ischar(OutName)
        if exist(OutNameCheck)
            XlsMatrixClear = {'-'};
            xlswrite(OutName, XlsMatrixClear);%Erase previous file with the same file name
        end

        XlsMatrix(1,1) = {'NHTSA 0.7hz Sine With Dwell Metrics - S7D Program Written 1/2007:'}; %Row 1
        XlsMatrix(1,6) = {OutName}; %Row 1
        XlsMatrix(2,1) = {cd}; %Row 2
        XlsMatrix(3,1) = {'Date Created'}; %Row 3
        XlsMatrix(3,3) = {date}; %Row 3
        XlsMatrix(4,1) = {'----------------------------------------------------------------------------------------------'}; %Row 4
        XlsMatrix(9,1) = {'----------------------------------------------------------------------------------------------'}; %Row 9

        % For First Data Matrix
        [x,y] = size(OutputValuesM);
        for i = 1:1:y;
            XlsMatrix(12,i) = MnemonicsString(i,:);%Row 12, Dispays the names of each output variable into columns
            for n = 1:1:x;
                XlsMatrix(12+n,i) = OutputValuesM(n,i);%Creates the columns of output data in excel
            end
        end

        xlswrite(OutName, XlsMatrix); % Saves XlsMatrix to an Excel File

        % Message to Program User That Processing Has Finished
        clear str
        str{1} = 'SAVED Lateral Stability Metrics Table';
        str{2} = ['CONTAINING FILES: ' char(filename{1}) '-' char(filename{end})];
        str{3} = '--------------------------------------------------------------------------';
        str{4} = 'CAUTION:  Make Sure You Have Selected';
        str{5} = 'The Correct Vehicle Parameters!!';
        str{6} = '--------------------------------------------------------------------------';
        msgbox(char(str),'Data Spreadsheet Has Been Saved')
    else
        msgbox('DATA TABLE NOT SAVED','SAVE ERROR')
    end

else
    errordlg('No file selected');
end
clear app filename pathname i str
close(figure(2));
close(figure(4));

% --- Executes on button press in chngdir_pb8.
function chngdir_pb8_Callback(hObject, eventdata, handles)
% hObject    handle to chngdir_pb8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Allows User to select directory in which output spreadsheets will be
%stored.  
directory_name = uigetdir;
% [FileName,PathName,FilterIndex] = uigetfile(cd);
if length(directory_name) > 1
    load([handles.tmp_dir,'namedata.mat']);
    app.defaultdir = directory_name;
    save([handles.tmp_dir,'namedata.mat'], 'app');
    set(handles.defdir_txt13,'string',directory_name);
end

% --- Executes on button press in SIS_out_pb9.
function SIS_out_pb9_Callback(hObject, eventdata, handles)
% hObject    handle to SIS_out_pb9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Call Subroutine to process Slowly Increasing Steer Tests
sis_out_s7d;
%Routine generates plots of each test and then compiles a table
%of metrics that is saved as an excel spreadsheet that determines the
%steering scalars.  


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
closereq;
tempapp = load([handles.tmp_dir 'namedata.mat'],'app');
mainapp = load([handles.s7d_location 'namedata.mat'],'app');

% update main masterlist
lng_temp_mstr = length(tempapp.app.masterlist(:,1)); % Determine the length of the vehicle list
for i = 1:lng_temp_mstr
    xxxx1 = strmatch(tempapp.app.masterlist{i,2}, mainapp.app.masterlist(:,2), 'exact');
    if isempty(xxxx1)
        mainapp.app.masterlist = [mainapp.app.masterlist; tempapp.app.masterlist(i,:)];
    end
end
clear i
% update temp masterlist
lng_main_mstr = length(mainapp.app.masterlist(:,1)); % Determine the length of the vehicle list
for i = 1:lng_main_mstr
    xxxx2 = strmatch(mainapp.app.masterlist{i,2}, tempapp.app.masterlist(:,2), 'exact');
    if isempty(xxxx2)
        tempapp.app.masterlist = [tempapp.app.masterlist; mainapp.app.masterlist(i,:)];
    end
end
clear i
% Sort both tempmasterlist and mainmasterlist
tempapp.app.masterlist = sortrows(tempapp.app.masterlist,2);
mainapp.app.masterlist = sortrows(mainapp.app.masterlist,2);

% update main vehicle_cg
AAAA3 = cellfun('isempty',tempapp.app.vehicle_cg(:,1)); %Number of valid entries
AAAA4 = cellfun('isempty',mainapp.app.vehicle_cg(:,1)); %Number of valid entries
for i = 1:length(find(AAAA3<1))
    xxxx3 = strmatch(tempapp.app.vehicle_cg{i,1}, mainapp.app.vehicle_cg(1:length(find(AAAA4<1)),1), 'exact');
    if isempty(xxxx3)
        mainapp.app.vehicle_cg = [tempapp.app.vehicle_cg(i,:); mainapp.app.vehicle_cg ];
    elseif length(xxxx3)>1.5
        mainapp.app.vehicle_cg(xxxx3(2:end),:) = {''};
    end
end
clear i
% Sort mainmasterlist
mainapp.app.vehicle_cg = sortrows(mainapp.app.vehicle_cg,-1);
% update temp vehicle_cg
AAAA4 = cellfun('isempty',mainapp.app.vehicle_cg(:,1)); %Number of valid entries
for i = 1:length(find(AAAA4<1)) %Loop throup and keep only valid entries
    xxxx4 = strmatch(mainapp.app.vehicle_cg{i,1}, tempapp.app.vehicle_cg(1:length(find(AAAA3<1)),1), 'exact');
    if isempty(xxxx4)
        tempapp.app.vehicle_cg = [mainapp.app.vehicle_cg(i,:); tempapp.app.vehicle_cg];
    elseif length(xxxx4)>1.5
        tempapp.app.vehicle_cg(xxxx4(2:end),:) = {''};
    end
end
% Sort tempmasterlist
tempapp.app.vehicle_cg = sortrows(tempapp.app.vehicle_cg,-1);

% Update app structure
app = tempapp.app; %#ok<NASGU>
A = cellfun('isempty',app.vehicle_cg(:,1));
vehicle_cg = {};
for k = 1:length(A(:,1))
    if A(k,1) == 0
        vehicle_cg = [vehicle_cg; app.vehicle_cg(k,:)];
    end
end
save([handles.s7d_location,'namedata.mat'], 'app');
save([handles.tmp_dir 'namedata.mat'],'app');
% delete(hObject);
clear i tempapp mainapp xxxx1 lng_main_mstr lng_temp_mstr xxxx2 xxxx4 xxxx3...
    AAAA3 AAAA4 A vehicle_cg app k
clear all

