
global rawdata

load([handles.tmp_dir,'namedata.mat']);

edit = 0;
unknown = 0;
noinfo = [{''},{''},{'10'},{'0'},{''}];
if isfield(rawdata, 'dx3names') == 0 && isfield(rawdata, 'edit')
    rmfield(rawdata, 'edit');
    edit = 1;
    unknown = 1;
    newhalines = inputdlg('Enter number of Variables to Define','User Input');
    if isempty(newhalines) || isempty(newhalines{:})
        newhalines = '0';
    end
    info = cell([str2double(char(newhalines)),5]);
    info(:,3) = {10};
    info(:,4) = {0};
    nameinfo = [app.masterlist; info];
    colwidth = [10 10 10 10 10];
    colLabels = {'Defined Channels','Raw Data Name','Fitler Cutoff Frequency','Filt. On/Off = 1/0','Filtered Name [p."name"]'};
else
    nameinfo = {};
    edit = 1;
    cycles = 0;
    for k = 1:length(rawdata.dx3names(:,1))
        xxx = strmatch(rawdata.dx3names{k,:} ,char(app.masterlist{:,2}),'exact');
        if isempty(xxx) == 0
            xxx = xxx(1);
            nameinfo = [nameinfo; rawdata.dx3names(k,:), app.masterlist(xxx,:)];
        else
            nameinfo = [nameinfo; rawdata.dx3names(k,:), noinfo(1,1),rawdata.dx3names(k,:), noinfo(1,3:end)];
            unknown = 1;
            str{1} = 'Enter New Variable Information';
            msgbox(char(str),'New Variable Found','modal')
            uiwait
            P = struct('modal',1, 'nVisibleRows',8,'nVisibleCols',4,'colWidth',[10 10 10 10 10 10]);
            P.colLabels = {'From File','Defined Channels','Raw Data Name','Fitler Cutoff Frequency','Filt. On/Off = 1/0','Filtered Name [p."name"]'};
            figure(2);
            set(gcf,'CloseRequestFcn','my_closereq');
            haxes = axes('units','pixels','position',[10 10 525 200]);
            newhaline = uitable(haxes,nameinfo(end,:),P);
            nameinfo(k,:) = newhaline(1,1:6);
            app.ha = [app.ha; newhaline(1,2:6)];
            app.masterlist = [app.masterlist; newhaline(1,2:6)];
            delete(figure(2));
%             clear newhaline
            cycles = cycles+1;
        end
        
    end
    clear newhaline
    newhalines = {num2str(cycles)};
    colwidth = [10 10 10 10 10 10];
    colLabels = {'From File','Defined Channels','Raw Data Name','Fitler Cutoff Frequency','Filt. On/Off = 1/0','Filtered Name [p."name"]'};
end


if unknown == 1 && edit == 1

    newha = [];
    while isempty(newha)
        P = struct('modal',1, 'nVisibleRows',19,'nVisibleCols',4,'colWidth',colwidth );
        P.colLabels = colLabels;
        % haxes = axes('units','normalized');
        figure(2);
        set(gcf,'CloseRequestFcn','my_closereq');
        haxes = axes('units','pixels','position',[10 10 525 400]);
        newha = uitable(haxes,nameinfo,P);
        if isempty(newha)
            errordlg('Information NOT SAVED!');
            return
        end
        app.ha = newha(:,end-4:end);
    end
    delete(figure(2));
    A = cellfun('isempty',app.ha);
    ha = {};
    masterlist = {};
    for k = 1:length(A(:,1))
        if A(k,1) == 0 && A(k,2) == 0
            ha = [ha; app.ha(k,:)];
        end
        if A(k,1) == 0 && A(k,2) == 0 && length(A(:,1)) == length(app.masterlist(:,1))
            masterlist = [masterlist; app.ha(k,:)];
        elseif k>length(app.masterlist(:,1)) && A(k,1) == 0 && A(k,2) == 0
            app.masterlist = [app.masterlist;  app.ha(k,:)];
        end
    end
    
    app.ha = ha;
    if isempty(masterlist) == 0;
        app.masterlist = masterlist;
    end
    save([handles.tmp_dir,'namedata.mat'], 'app');
else
    newha = nameinfo;
end
rawdata.newha = newha;
clear colLabels colwidth edit ha nameinfo newha noinfo unknown xxx k masterlist B KK...
    cycles newhalines


