function [Fc] = CutOff(Fh,Npoles,Npasses)
%
% compute the required cutoff frequency for each pass of a multiple pass filter
%
%  Fh      Desired overall cutoff frequency (-3dB) (Hz)
%  Fc      Required cutoff frequency (-3dB) for each pass (Hz)
%  Npoles  Number of poles for each pass
%  Npasses Number of passes
%
%  April 7, 1994
%
%  Jeffrey P. Chrstos
%
Fc=Fh/((2^(1/Npasses)-1)^(1/(2*Npoles)));
