% Base on the routine --- CGFix.m written by  Mark Heitz, Al Dunn & Dave Dashner, 9/18/01
% gx - 18/05/06 
function [AX_f, AY_f, AZ_f] = FixMotionPkOffset(AX,AY,AZ,RVX,RVY,RVZ,P0,P)
% Inputs:
% AX,AY,AZ - array of acceleration in X Y Z axes
% RVX,RVY,RVZ - angle speed, roll,pitch,yaw (rad)
% P0 - coordinates [x y z] of MotionPack, 
% P - point to calculate its accelerations(ft), normally the CG of vehicle
% all array are column vectors

% Calculate derivatives of roll, pitch and yaw rates:
RAX = diff(RVX);   % Roll acceleration
RAY = diff(RVY);   % Pitch acceleration
RAZ = diff(RVZ);   % Yaw acceleration

% Pad the derivatives so they will be the same length as other vectors:
RAX = [RAX(1); RAX]; %add a cell
RAY = [RAY(1); RAY];
RAZ = [RAZ(1); RAZ];

dP = P - P0 ;
LongitOffset_ft = dP(1);
LatOffset_ft = dP(2);
VertOffset_ft = dP(3);

% Calculate accelerations of displaced CG:
AX_f = AX - (RVY.^2 + RVZ.^2) * LongitOffset_ft + (RVY .* RVX - RAZ) * LatOffset_ft + (RVZ .* RVX + RAY) * VertOffset_ft;  % Longitudinal acceleration of displaced CG
AY_f = AY + (RVY .* RVX + RAZ) * LongitOffset_ft - (RVX.^2 + RVZ.^2) * LatOffset_ft + (RVZ .* RVY - RAX) * VertOffset_ft;  % Lateral acceleration of displaced CG
AZ_f = AZ + (RVZ .* RVX - RAY) * LongitOffset_ft + (RVZ .* RVY + RAX) * LatOffset_ft - (RVX.^2 + RVY.^2) * VertOffset_ft;  % Vertical acceleration of displaced CG
  
