function [Ay_f, Az_f, Ry_f,Rz_f] = FixMotionPkRollAngle(Ay, Az,Ry,Rz, RollAngle)
% Fix the motion pack has a roll angle
% Ay_f,Az_f - are horiaontal, and vertical exactly
% Ay, Ay - is fixed with vehicle body
% Ry, Rz - pitch rate, yaw rate;
% Ry_f, Rz_f - fixed pitch rate, yaw rate;
% RollAngle - vehicle roll angle in radian
% ignore pitch, yaw installation angles
n1 = length(RollAngle);
Ay_f = zeros(n1,1);
Az_f = zeros(n1,1);
Ry_f = zeros(n1,1);
Rz_f = zeros(n1,1);
for i = 1:n1
     Ay_f(i) = -Az(i) * sin(RollAngle(i)) + Ay(i) * cos(RollAngle(i));

%     g  = 32.17417; % same as above
%     Ay_f(i) = (Ay(i) + g * sin(RollAngle(i))) / cos(RollAngle(i)); %fortest ++++++++++++++

    Az_f(i) =  Az(i) * cos(RollAngle(i)) + Ay(i) * sin(RollAngle(i));

    Ry_f(i) = -Rz(i) * sin(RollAngle(i)) + Ry(i) * cos(RollAngle(i));
    Rz_f(i) =  Rz(i) * cos(RollAngle(i)) + Ry(i) * sin(RollAngle(i));
end

% %fortest +++++++++++++++
% figure
% plot(Az,'b')
% hold on 
% plot(Az_f,'r');
% hold off
% title('Az')
% 
% figure
% plot(Ay,'b')
% hold on 
% plot(Ay_f,'r');
% hold off
% title('Ay')
% 
% figure
% plot(RollAngle,'b')
% title('Roll angle')
% disp('pause -----------------')
% pause