function [Dt] = LoadDx3(Dx3File, FieldAry)
% Load some channels of DX3 file 
% FieldAry - cell array of names of data channels
% Dt - struct of data including data channel in FieldAry and:
% time0 - time channel
% XIncr - sample interval
%
%
% Example:
% addpath U:\SHARED\gxu\GxMatLabLib 
% Dx3File = 'D:\gps\TEST_1_sync_proc.dx3';
% FieldAry = {'TRL_ROLL_f','TRL_YAW_f'};
% Dt = LoadDx3(File, FieldAry);
%==============================================

Dt = [];
n1 = length(FieldAry);
i = 1;
instr = ['''',Dx3File, '''', ',', '''',FieldAry{i}, ''''];
rtstr = ['Dt.',FieldAry{i}]; 
for i = 2:n1
    instr = [instr, ',', '''', FieldAry{i},'''']; 
    rtstr = [rtstr, ',Dt.', FieldAry{i}]; 
end

instr = [instr, ',2'];
rtstr = [rtstr, ',Dt.time0, Dt.XIncr'];

cmstr = [ '[', rtstr, ']= LoadDxChannels(', instr, ');'];
eval(cmstr);
