function [varargout] = LoadDxChannels(File, varargin)
%---------------------------------------------------------------------------------------
% LoadDxChannels: Load DX3 channels
%
% Syntax:
% %Load all channels into struct Dt.
% [Dt] = LoadDxChannels('DX3_File');
%
%
% %load some channels:
% %Load channels
% [Chn1, Chn2, ...] = LoadDxChannels('DX3_File','channel_1','channel_2',...)
%
% %Load channels and sample time XIncr
% [Chn1, Chn2, ..., XIncr] = LoadDxChannels('DX3_File','channel_1','channel_2',..., 1)
%
% %Load channels,sample time XIncr, and time channel
% [Chn1, Chn2, ..., TimeChn, XIncr] = LoadDxChannels('DX3_File','channel_1','channel_2',..., 2)
%
%
%Examples:
%DX3_File = 'D:\FAT\EIVD\00095.dx3';
%addpath E:\Application\GxMatLabLib; %add Lib path
%%load some channels
%[Brake, F1, PDT] = LoadDxChannels(DX3_File, 'Brake_Light', 'FTC', 'PDT_Button');
%[Brake, F1, PDT, Xinc] = LoadDxChannels(DX3_File, 'Brake_Light', 'FTC', 'PDT_Button', 1);
%[Brake, F1, PDT, time, Xinc] = LoadDxChannels(DX3_File, 'Brake_Light', 'FTC', 'PDT_Button', 2);
%
%%Loda all channels into Dt struct
%[Dt] = LoadDxChannels(DX3_File);% Dt has all data channels
%[Dt, XIncr] = LoadDxChannels(DX3_File, 1); %Dt has all data channels
%[Dt, XIncr] = LoadDxChannels(DX3_File, 2); %Dt has all data channels and time channel
%
% * Note: It is better to load all channels you need once as to save times
% * If 'Out of memory' happens, try to use LoadDxChannels_big, or quit
% MatLab and run the program again.  Loading big DX file needs bigger
% continous memory block.  
%
% See also: LoadDxChannels_big, getDxChnNames,  getDxInfo
% 5/23/06 - GX added
% Return Data structure Dt also contains EventPts (pre-trigger points) and XIncr (sample time interval)
%---------------------------------------------------------------------------------------

nIns = nargin;
nOuts = nargout;

fid=fopen(File,'r'); % existing ?
if fid == -1
    mstr = ['Loading DX Error: Failed to open file ', File, '!'];
    msgbox( mstr, 'Error','error');
    return;
else
    fclose(fid);
end

%Flag -----
Fplus = 0;
nInPars = length(varargin);
if nInPars > 0
    Vlast = varargin(nInPars);
    tem = cell2mat(Vlast);
    if length(tem) == 1  % load XIncr
        Fplus = tem; % = 2;load time channel that include pre-triger event time
    end
end
FLoadAllChannels = 0;
if Fplus == 0 % no XIncr flag
    if nIns == 1 % load all channels
        FLoadAllChannels = 1;
    end
elseif Fplus == 2 | Fplus == 1%load XIncr
    if nIns == 2 % load all channels
        FLoadAllChannels = 1;
    end
else
    mstr = ['Loading DX Error: Last input argument is ', num2str(Fplus), 'not correct. It should be 1 or 2!'];
    msgbox( mstr, 'Error','error');
    return;
end

% check if num of output is correct
if FLoadAllChannels
    if nOuts > 1
        mstr = ['Loading DX Error: Num of return variables =,' num2str(nOuts), ' > 1 !  It should be one structure variable. '];
        msgbox( mstr, 'Error','error');
        return;
    end
    
    if nIns > 1
        mstr = 'Loading DX Error: No flag inputs are needed for loading all DX file!';
        msgbox( mstr, 'Error','error');
        return;
    end
else
    if  Fplus == 0
        nout_es = nIns - 1; %num of out variables suppose to be
    else
        nout_es = nIns - 2 + Fplus; %num of put variables suppose to be
    end
    if nOuts ~= nout_es
        mstr = ['Loading DX Error: Num of return variables = ', num2str(nOuts), ', should be ', num2str(nout_es), ' !'];
        msgbox( mstr, 'Error','error');
        return;
    end
end

% load DLL ---
fl = which('LoadDxChannels'); % find file's path
[pathstr, name, ext, versn] = fileparts(fl);
hd = [pathstr, '\LoadDxOut.h'];

% hd = 'E:\My_Utility\LoadDx\LoadDxOut.h'
% pathstr ='E:\My_Utility\Call'  %fortest ??????????????????

DllLib =[pathstr, '\LoadDx'];

loadlibrary (DllLib, hd);
%loadlibrary (DllLib, @HDproto);

if ~libisloaded('LoadDx')
    mstr = ['Loading DX Error: Failed to load DLL = ', DllLib];
    msgbox( mstr, 'Error','error');
    return;
end
%libfunctions LoadDx -full

%load Dx channel info ---
maxChns = 1000; %number of channels
sm.nChns = 0;
sm.pChnPoints = zeros(maxChns,1);
sc = libpointer('DX_INFO1', sm);
calllib('LoadDx', 'get_dx_info', sc,File ); % ---

DxHdr = get(sc, 'Value');
clear sc

chnNameAry = [];
if Fplus == 0 % no XIncr flag
    if nIns == 1 % load all channels
        nInChns = DxHdr.nChns;
        %FLoadAllChannels = 1;
    else %load some channels
        chnNameAry = varargin;
        nInChns = nIns -1;
    end
else %load XIncr
    if nIns == 2 % load all channels
        %FLoadAllChannels = 1;
        nInChns = DxHdr.nChns;
    else %load some channels
        nInChns = nIns - 2;
        chnNameAry = varargin(1:nInChns);
    end
end

Chn.XIncr = 0.000;
Chn.pChnPts = zeros(nInChns + 3,1);
%Load channels and names ---
if FLoadAllChannels == 1 % load all channels into DT structure
    n1Dpoints = 0;
    for i = 1:DxHdr.nChns
        n1Dpoints = n1Dpoints + DxHdr.pChnPoints(i);
    end
    if Fplus == 2 %plus time channel
        n1Dpoints = n1Dpoints + DxHdr.nMaxPoints;
    end

    Chn.pD = zeros(n1Dpoints, 1); % make space for 1D array
    pChn = libpointer('CHN_OB', Chn);

    LenNameStr = DxHdr.TotalFieldNamesLength + DxHdr.nChns; % includes cammas
    
    nstr = blanks(LenNameStr);%make empty str to hold return name string

    if Fplus == 2 % plus time channel
        [pChn,nstr] = calllib('LoadDx', 'LoadAllChnsPlusTimeChan',pChn, nstr, File );
    else
        [pChn,nstr] = calllib('LoadDx', 'LoadAllChns',pChn, nstr, File );
    end
    dChn = pChn;
    [chnNameAry] = parseCommaStr(nstr);
else % part of channels
    i = 1;% make name str
    namestr = char(chnNameAry(i));
    for i = 2:nInChns
        namestr = [namestr, ',',  char(chnNameAry(i))];
    end
    
    % make space for return data
    n1Dpoints = nInChns * DxHdr.nMaxPoints;
    if Fplus == 2 % plus time channel
        n1Dpoints = n1Dpoints + DxHdr.nMaxPoints;
    end
    Chn.pD = zeros(n1Dpoints, 1); % make space for 1D array
    pChn = libpointer('CHN_OB', Chn);

    if Fplus == 2 % plus time channel
        calllib('LoadDx', 'LoadChnsByNamesPlusTimeChn',pChn, namestr, File );
    else
        calllib('LoadDx', 'LoadChnsByNames',pChn, namestr, File );
    end

    dChn = get(pChn, 'Value');
end
clear pChn.pD
clear pChn;
unloadlibrary LoadDx;

% %----------------------------------------------------
% % separate double 1D to Channels

nOutChns = dChn.nChns;
% check if num of out channels correct
if Fplus == 2 % pluse time channel
    if (nOutChns - nInChns) ~= 1
        mstr = ['Loading DX Error: nOutChns=', num2str(nOutChns), ' is not equal to nInChns + 1 = ', num2str(nInChns +1)];
        msgbox( mstr, 'Error','error');
        return;
    end
else
    if nOutChns ~= nInChns
        mstr = ['Loading DX Error: nOutChns=', num2str(nOutChns), ' is not equal to nInChns = ', num2str(nInChns)];
        msgbox( mstr, 'Error','error');
        return;
    end
end

DT.XIncr = dChn.XIncr;
DT.EventPts = DxHdr.EventPts;

is = 1;
ie = 0;
for i = 1:nInChns
%     ie = ie  + DxHdr.pChnPoints(i);
    ie = ie  + dChn.pChnPts(i);
    ChnName0 = char(chnNameAry(i));
    %correct veriable names that are not suit MatLab naming conventions
    [ChnName] = correctVarName(ChnName0);

    if FLoadAllChannels == 1 % load all channels into DT structure
        cmdstr= ['DT.', ChnName, '=', 'dChn.pD(', num2str(is), ':', num2str(ie), ') ;'];
        eval(cmdstr);
%         if i == nInChns
%             cms2 = 'varargout(1) = {DT} ;';
%             eval(cms2);
%         end
    else
        cmdstr= [ChnName, '=', 'dChn.pD(', num2str(is), ':', num2str(ie), ') ;'];
        eval(cmdstr);
        cms2 = [ 'varargout(i) = {', ChnName '} ;'];
        eval(cms2);
    end
    is = ie + 1;
end

% time0, XIncr ---
DT.EventPts = DxHdr.EventPts;
tm = ((1:DxHdr.nMaxPoints)- DxHdr.EventPts) * DT.XIncr;;


i = nInChns + 1;
ie = ie + DxHdr.nMaxPoints;
if Fplus == 0
elseif Fplus == 1
    Xinc = dChn.XIncr;
    if FLoadAllChannels == 1 % load all channels into DT structure
        varargout(2) = {Xinc} ;
    else
        varargout(i) = {Xinc} ;
    end
elseif Fplus == 2
    Xinc = dChn.XIncr;
    if FLoadAllChannels == 1 % load all channels into DT structure
        cmdstr= ['DT.time0 =', 'dChn.pD(', num2str(is), ':', num2str(ie), ') ;'];
        eval(cmdstr);
%         varargout(1) = {DT} ;
        varargout(2) = {Xinc} ;
    else
        cmdstr= ['time0 = dChn.pD(', num2str(is), ':', num2str(ie), ') ;'];
        eval(cmdstr);
        varargout(i) = {time0} ;
        varargout(i+1) = {Xinc} ;;
    end
end

if FLoadAllChannels == 1 % add time channel
    DT.time0 = tm' ;
    varargout(1) = {DT} ;
end




% problem - It has problem when loading big file (253M) second time. not
% problem during first loading ???














