% SIS_out_v2 (Slowly Increasing Steer Output)
% In use with S7D VERSION 2.1  -  1/25/2008

% This is the general-purpose routine for processing SIS tests to determine
% the inputs to the steering controller.  It is normally used in preference
% to the older SIS_out.m, SIS_out_v2.m and the special-purpose SIS_out_v3.m.
%
% Orginal Code Garrick Forkenbrock and A. L. Dunn, 07/24/2002
% Modifications made by Devin Elsasser And Dave Dashner
% Identification information:
PhaseNo='NHTSA COMPLIANCE TESTING For ESC';
VehID=[];
IDString=['"',PhaseNo,':  ',deblank(VehID)];

% Initialize the two-dimensional output matrix:
OutputMatrix = [];

% Initialize the variables used for averaging the results and the increment counter:
MeanCnt=0;  meanTHETAENCF_3=0.0;  meanAYCG_CD2_3=0.0;  meanRER_Steer65=0.0;
meanSteerTimeRER65=0.0;  meanRER_Steer55=0.0;  meanSteerTimeRER55=0.0; meanTHETAENCF_5=0.0;
global rawdata
if isfield(handles,'vehlistnum')==0
    errordlg('Please select a vehicle from the list in the popup menu.');
    return
end
%Determin Vehicle being evaluated.
vehiclelist = get(handles.Vehicles_ppm3,'string');
vehicle = vehiclelist(handles.vehlistnum,:);
if strcmp(vehicle ,'Select Vehicle')
    errordlg('Please select a vehicle from the list in the popup menu.');
    return
end

load([handles.tmp_dir,'namedata.mat']);
[filename,pathname] = uigetfile('*.mat','Select Data Files To Calculate Metrics',app.workingdirectory,'MultiSelect','on');

if isfloat(filename)==0
    if iscell(filename)
        filename = sort(filename);
    end
    app.workingdirectory = pathname;
    save([handles.tmp_dir,'namedata.mat'],'app');
    
    % Loop through all requested files
    filename = cellstr(filename); %convert filenames from cells to strings
    for RunNumber = 1:length(filename)
        file2process = [deblank(pathname),deblank(filename{:,RunNumber})];
        load(file2process,'p');
        set(handles.File_txt11,'string',['Scalar Processing:   ',deblank(filename{:,RunNumber})]);
        pause(0.05);
        
        % Process file:
        %
        %Check for needed variables
        if exist('p')==0
            errordlg('Missing Variables [p.aycg,p.swaf,p.swrf,p.time,p.XIncr,p.rvz_f]');
            return
        elseif exist('p')==1 && isfield(p,'aycg')==0
            errordlg('Missing Variable [p.aycg]');
            return
        elseif exist('p')==1 && isfield(p,'swaf')==0
            errordlg('Missing Variable [p.swaf,p.swrf]');
            return
        elseif exist('p')==1 && isfield(p,'time')==0
            errordlg('Missing Variable [p.time]');
            return
        elseif exist('p')==1 && isfield(p,'XIncr')==0
            errordlg('Missing Variable [p.XIncr]');
            return
        elseif exist('p')==1 && isfield(p,'rvz_f')==0
            errordlg('Missing Variable [p.rvz_f]');
            return
        elseif exist('p')==1 && isfield(p,'spd')==0
            errordlg('Missing Variable [p.spd]');
            return
        end

        THETAENCF = p.swaf; %Filtered Steering Wheel Angle
        AYCG_CD2 = p.aycg; %Filtered and Corrected Lateral Acceleration
        XIncr = p.XIncr; %Time increment.  1/[sampling rate].
        SPCHSF = p.spd; %Vehicle Speed
        time = p.time; %Time
        
        %*************************************************************************
        swr = gradient(p.swaf)./p.XIncr;     % steer velocity
        % Filter steer velocity with 1.0 sec  moving mean phaseless filter (filtfilt)
        span=fix(1/p.XIncr*1.000);  %sample rate * time span = sample span
        b=ones(span,1);     % Filter coeffs
        a=length(b);           % Filter coeffs
        swrf_1=filtfilt(b,a,swr);
        % get rid of end effect artifacts of filter
        swrf_1(1:span)=0;
        swrf_1(end-span:end)=0;
        clear a b span swr
        %******************************************************************

        absTHETAENCF=abs(THETAENCF);  %Warning. This is a potential problem: negative portions of a curve will be flipped, while positive portions will not.--DD 5/30/03
        %Initial trial for EventPt = steering rate at 7 deg/sec
        swr7 = find(abs(swrf_1) > 6.75 & abs(swrf_1) < 20);
        %if it cannot be found set EventPt to 1
        if isempty(swr7)
            swr7 = 1; %Default swr7 count number
        else
            swr7 = swr7(1);
        end
        %Begin Search for 1st instance that steering rate reaches 7deg/sec
        %and is sustanined for atleast 500ms.
        while abs(swrf_1(swr7+round(0.5/XIncr)))<7 || abs(swrf_1(swr7+round(0.5/XIncr)))>25 && swr7+round(0.5/XIncr)<length(p.swaf)
            swr7 = swr7+round(0.1/XIncr);
            trackpt = swr7;
            swr7 = find(abs(swrf_1) > 6.0 & abs(swrf_1) < 8.0);
            if isempty(swr7)
                break
            end
            swr7 = swr7(1)+trackpt-1;
        end
        %Check to see if swr7 was found
        if isempty(swr7)==0
            THETAENCF = THETAENCF-mean(THETAENCF(swr7-round(0.4/XIncr)));
            while abs(THETAENCF(swr7))>1.5 && swr7>1
                swr7 = swr7-1;
            end
            EventPt = round(swr7);
        else
            h = msgbox('Could not find steering rate = 7deg/sec .  Skipping Test','Determining Maneuver Start Count');
            uiwait(h);
            clear mesg HW_zero_confirm p handstart swr7 trackpt swr swrf StartPt ZeroBegin ZeroEnd EventPt
            continue            
        end
        
        ZeroStart=EventPt-round(1.000/XIncr); 
        ZeroEnd=EventPt;

        if ZeroStart<(1/XIncr+1)  %Reject any point number less than 1.
            ZeroStart=1;
        end
        absTHETAENCF=absTHETAENCF-mean(absTHETAENCF((ZeroStart:ZeroEnd)));
        THETAENCF = THETAENCF-mean(THETAENCF((ZeroStart:ZeroEnd)));
        clear ZeroEnd ZeroStart

        handstart = round(EventPt);
        % Count backwards to determine when handwheel input began:
        while 0.9*absTHETAENCF(handstart) < absTHETAENCF(handstart-1)
            handstart=round(handstart)-1;
        end
        
        if handstart >=(1/XIncr+1)
            StartPt=round((1/XIncr));
        else
            StartPt=round(handstart)-1;
        end
        
        
        scrsz = get(0,'ScreenSize');            
        if isempty(handstart )==0
            THETAENCF=THETAENCF-mean(THETAENCF((handstart-StartPt):handstart));
            AYCG_CD2=AYCG_CD2-mean(AYCG_CD2((handstart-StartPt):handstart));
            ZeroBegin=round(handstart-StartPt); ZeroEnd=round(handstart);
            
            figure(1);clf;
            set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
            subplot(2,2,1)
            plot(THETAENCF)
            hold on;
            plot((handstart-StartPt):handstart,THETAENCF((handstart-StartPt):handstart),'r','LineWidth',2)      %flag initial mean speed calc interval
            grid;
            ylabel('Handwheel Angle (deg)')
            h= title('','Interpreter','none');set(h,'string',['File ',file2process])
            hold off;

            subplot(2,2,2)
            plot((handstart-StartPt):(handstart+round(3/(XIncr))),THETAENCF((handstart-StartPt):(handstart+round(3/(XIncr)))),'b','LineWidth',2)
            hold on;
            plot((handstart-StartPt):handstart,THETAENCF((handstart-StartPt):handstart),'r','LineWidth',2)      %flag initial mean speed calc interval
            grid;
            legend('SWA','Zeroing Range')
            ylabel('Handwheel Angle (deg)')
            title('Zoom to Zeroing Range')
            hold off;

        else
            THETAENCF=THETAENCF-mean(THETAENCF(round(0.150/XIncr):round(0.490/XIncr)));
            AYCG_CD2=AYCG_CD2-mean(AYCG_CD2(round(0.150/XIncr):round(0.490/XIncr)));
            ZeroBegin=round(0.150/XIncr); ZeroEnd=round(0.490/XIncr);
            
            pause
            
        
            figure(1)
            subplot(2,2,1)
            plot(THETAENCF)
            hold on;
            plot(round(0.150/XIncr):round(0.490/XIncr),THETAENCF(round(0.150/XIncr):round(0.490/XIncr)),'r','LineWidth',2)      %flag initial mean speed calc interval
            grid;
            ylabel('Handwheel Angle (deg)')
            h= title('','Interpreter','none');set(h,'string',['File ',file2process])
            hold off;

            subplot(2,2,2)
            plot(1:(handstart+(1/(XIncr))),THETAENCF(1:(handstart+(1/(XIncr)))),'b','LineWidth',2)
            hold on;
            plot(round(0.150/XIncr):round(0.490/XIncr),THETAENCF(round(0.150/XIncr):round(0.490/XIncr)),'r','LineWidth',2)      %flag initial mean speed calc interval
            grid;
            ylabel('Handwheel Angle (deg)');
            legend('SWA','Zeroing Range');
            title('Zoom to Zeroing Range');
            hold off;
        end

        HW_zero_confirm = questdlg('Does the handwheel zeroing appear to be correct?','Zeroing','Yes','No','Yes');
        if isempty(HW_zero_confirm)
            HW_zero_confirm='Yes';
        elseif strcmp(HW_zero_confirm,'No')
            clear mesg
            mesg{1} = '1.  Zoom to initiation of steer.                           ';
            mesg{2} = '2.  Determine steering start count. Press Enter To Continue';
            msgbox(char(mesg),'Steering Angle Zeroing');
            pause;
            clear mesg HW_zero_confirm p handstart swr7 trackpt swr swrf StartPt ZeroBegin ZeroEnd EventPt
            handstart = inputdlg('3.  Enter handwheel start count.','Steering Angle Zeroing');
            if isempty(handstart)
                msgbox('You did not enter a count number.  Skipping Test','Steering Angle Zeroing')
                clear mesg HW_zero_confirm p handstart swr7 trackpt swr swrf StartPt ZeroBegin ZeroEnd EventPt
                continue
            end
            handstart = round(str2double(char(handstart)));
            if handstart > round(1.000/XIncr)
                StartPt = round(1.000/XIncr);
                THETAENCF=THETAENCF-mean(THETAENCF((handstart-StartPt):handstart));
                AYCG_CD2=AYCG_CD2-mean(AYCG_CD2((handstart-StartPt):handstart));
                ZeroBegin=round(handstart-StartPt); ZeroEnd=round(handstart);
                
                msgbox('Press any key to continue.', 'modal')
                uiwait;

                figure(1)
                subplot(2,2,1)
                plot(THETAENCF)
                hold on;
                grid;
                ylabel('Handwheel Angle (deg)')
                h= title('','Interpreter','none');set(h,'string',['File ',file2process])
                hold off;

                subplot(2,2,2)
                plot((handstart-StartPt):(handstart+round(3/XIncr)),THETAENCF((handstart-StartPt):(handstart+round(3/XIncr))),'b','LineWidth',2)
                hold on;
                plot((handstart-StartPt):handstart,THETAENCF((handstart-StartPt):handstart),'r','LineWidth',2)      %flag initial mean speed calc interval
                grid;
                ylabel('Handwheel Angle (deg)')
                title('Zoom to Zeroing Range')
                hold off;

            else
                THETAENCF=THETAENCF-mean(THETAENCF(round(0.150/XIncr):round(0.490/XIncr)));
                AYCG_CD2=AYCG_CD2-mean(AYCG_CD2(round(0.150/XIncr):round(0.490/XIncr)));
                ZeroBegin=round(0.150/XIncr); ZeroEnd=round(0.490/XIncr);

                msgbox('Press any key to continue.', 'modal')
                uiwait;
                
                figure(1)
                subplot(2,2,1)
                plot(THETAENCF)
                hold on;
                plot(round(0.150/XIncr):round(0.490/XIncr),THETAENCF(round(0.150/XIncr):round(0.490/XIncr)),'r','LineWidth',2)      %flag initial mean speed calc interval
                grid;
                ylabel('Handwheel Angle (deg)')
                h= title('','Interpreter','none');set(h,'string',['File ',file2process])
                hold off;

                subplot(2,2,2)
                plot(1:(handstart+(3/(XIncr))),THETAENCF(1:(handstart+(3/(XIncr)))),'b','LineWidth',2)
                hold on;
                plot(round(0.150/XIncr):round(0.490/XIncr),THETAENCF(round(0.150/XIncr):round(0.490/XIncr)),'r','LineWidth',2)      %flag initial mean speed calc interval
                grid;
                ylabel('Handwheel Angle (deg)')
                title('Zoom to Zeroing Range')
                hold off;
            end
        end

        % Determine direction of steer input:
        DOS_chk=THETAENCF(round(handstart+3*(1/(XIncr))));
        if DOS_chk > 0
            DOS = 0;   % 0 = right steer
        else
            DOS = 1;   % 1 = left steer
        end

        lower_limit = 0.1;	% define the upper and lower limits of the contiguous region you wish to regress.
        upper_limit = 0.375;

        if DOS == 0
            lower_limit_cnt = find(AYCG_CD2(round(0.5/XIncr):end) >= 0.1);
            lower_limit_cnt_1 = lower_limit_cnt(1)+round(0.5/XIncr)-1;
            upper_limit_cnt = find(AYCG_CD2(round(0.5/XIncr):end) >= 0.375);
            upper_limit_cnt_1 = upper_limit_cnt(1)+round(0.5/XIncr)-1;
        end

        if DOS == 1
            lower_limit_cnt = find(AYCG_CD2(round(0.5/XIncr):end) <= -0.1);
            lower_limit_cnt_1 = lower_limit_cnt(1)+round(0.5/XIncr)-1;
            upper_limit_cnt = find(AYCG_CD2(round(0.5/XIncr):end) <= -0.375);
            upper_limit_cnt_1 = upper_limit_cnt(1)+round(0.5/XIncr)-1;
        end

        %Lower limit functionality check:
        Lower_Diff_1=abs(abs(AYCG_CD2(lower_limit_cnt_1))-0.1);
        Lower_Percent_Diff_1=100*(Lower_Diff_1)/0.1;

        if Lower_Percent_Diff_1 <=5
            lower_limit_cnt=lower_limit_cnt_1;
            % Display most appropriate 0.1 g information:

            Corr_Lower_Limit_cnt=lower_limit_cnt;
            Corr_Lower_Diff=abs(abs(AYCG_CD2(Corr_Lower_Limit_cnt))-0.1);
            Corr_Lower_Percent_Diff=100*(Corr_Lower_Diff)/0.1;

        else
            if Lower_Percent_Diff_1 >5
                lower_limit_cnt_2=lower_limit_cnt_1-1;
                Lower_Diff_2=abs(abs(AYCG_CD2(lower_limit_cnt_2))-0.1);
                Lower_Percent_Diff_2=100*(Lower_Diff_2)/0.1;

                if Lower_Percent_Diff_2 <=5
                    lower_limit_cnt=lower_limit_cnt_2;
                else
                    if Lower_Percent_Diff_2 >5
                        lower_limit_cnt_3=lower_limit_cnt_1+1;
                        Lower_Diff_3=abs(abs(AYCG_CD2(lower_limit_cnt_3))-0.1);
                        Lower_Percent_Diff_3=100*(Lower_Diff_3)/0.1;
                        if Lower_Percent_Diff_3 <=5
                            lower_limit_cnt=lower_limit_cnt_3;
                        else
                            if Lower_Percent_Diff_3 >5
                                lower_limit_cnt_4=lower_limit_cnt_1+2;
                                Lower_Diff_4=abs(abs(AYCG_CD2(lower_limit_cnt_4))-0.1);
                                Lower_Percent_Diff_4=100*(Lower_Diff_4)/0.1;
                                if Lower_Percent_Diff_3 <=5
                                    lower_limit_cnt=lower_limit_cnt_4;
                                else 'All maximum percent differences exceed 5 percent';
                                    if Lower_Percent_Diff_1 <= Lower_Percent_Diff_2 && Lower_Percent_Diff_1 <= Lower_Percent_Diff_3 && Lower_Percent_Diff_1 <= Lower_Percent_Diff_4
                                        lower_limit_cnt=lower_limit_cnt_1;
                                    else
                                        if Lower_Percent_Diff_2 <= Lower_Percent_Diff_1 && Lower_Percent_Diff_2 <= Lower_Percent_Diff_3 && Lower_Percent_Diff_2 <= Lower_Percent_Diff_4
                                            lower_limit_cnt=lower_limit_cnt_2;
                                        end
                                        if Lower_Percent_Diff_3 <= Lower_Percent_Diff_1 && Lower_Percent_Diff_3 <= Lower_Percent_Diff_2 && Lower_Percent_Diff_3 <= Lower_Percent_Diff_4
                                            lower_limit_cnt=lower_limit_cnt_3;
                                        end
                                        if Lower_Percent_Diff_4 <= Lower_Percent_Diff_1 && Lower_Percent_Diff_4 <= Lower_Percent_Diff_2 && Lower_Percent_Diff_4 <= Lower_Percent_Diff_3
                                            lower_limit_cnt=lower_limit_cnt_4;
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
                % Display most appropriate 0.1 g information:
                Corr_Lower_Limit_cnt=lower_limit_cnt;
                Corr_Lower_Diff=abs(abs(AYCG_CD2(Corr_Lower_Limit_cnt))-0.1);
                Corr_Lower_Percent_Diff=100*(Corr_Lower_Diff)/0.1;
            end
        end

        %Upper limit functionality check:
        Upper_Diff_1=abs(abs(AYCG_CD2(upper_limit_cnt_1))-0.375);
        Upper_Percent_Diff_1=100*(Upper_Diff_1)/0.375;

        if Upper_Percent_Diff_1 <=5
            upper_limit_cnt=upper_limit_cnt_1;
            % Display most appropriate 0.1 g information:

            Corr_Upper_Limit_cnt=upper_limit_cnt;
            Corr_Upper_Diff=abs(abs(AYCG_CD2(Corr_Upper_Limit_cnt))-0.375);
            Corr_Upper_Percent_Diff=100*(Corr_Upper_Diff)/0.375;

        else
            if Upper_Percent_Diff_1 >5
                upper_limit_cnt_2=upper_limit_cnt_1-1;
                Upper_Diff_2=abs(abs(AYCG_CD2(upper_limit_cnt_2))-0.375);
                Upper_Percent_Diff_2=100*(Upper_Diff_2)/0.375;

                if Upper_Percent_Diff_2 <=5
                    upper_limit_cnt=upper_limit_cnt_2;
                else
                    if Upper_Percent_Diff_2 >5
                        upper_limit_cnt_3=upper_limit_cnt_1+1;
                        Upper_Diff_3=abs(abs(AYCG_CD2(upper_limit_cnt_3))-0.375);
                        Upper_Percent_Diff_3=100*(Upper_Diff_3)/0.375;
                        if Upper_Percent_Diff_3 <=5
                            upper_limit_cnt=upper_limit_cnt_3;
                        else
                            if Upper_Percent_Diff_3 >5
                                upper_limit_cnt_4=upper_limit_cnt_1+2;
                                Upper_Diff_4=abs(abs(AYCG_CD2(upper_limit_cnt_4))-0.375);
                                Upper_Percent_Diff_4=100*(Upper_Diff_4)/0.375;
                                if Upper_Percent_Diff_3 <=5
                                    upper_limit_cnt=upper_limit_cnt_4;
                                else 'All maximum percent differences exceed 5 percent';
                                    if Upper_Percent_Diff_1 <= Upper_Percent_Diff_2 && Upper_Percent_Diff_1 <= Upper_Percent_Diff_3 && Upper_Percent_Diff_1 <= Upper_Percent_Diff_4
                                        upper_limit_cnt=upper_limit_cnt_1;
                                    else
                                        if Upper_Percent_Diff_2 <= Upper_Percent_Diff_1 && Upper_Percent_Diff_2 <= Upper_Percent_Diff_3 && Upper_Percent_Diff_2 <= Upper_Percent_Diff_4
                                            upper_limit_cnt=upper_limit_cnt_2;
                                        end
                                        if Upper_Percent_Diff_3 <= Upper_Percent_Diff_1 && Upper_Percent_Diff_3 <= Upper_Percent_Diff_2 && Upper_Percent_Diff_3 <= Upper_Percent_Diff_4
                                            upper_limit_cnt=upper_limit_cnt_3;
                                        end
                                        if Upper_Percent_Diff_4 <= Upper_Percent_Diff_1 && Upper_Percent_Diff_4 <= Upper_Percent_Diff_2 && Upper_Percent_Diff_4 <= Upper_Percent_Diff_3
                                            upper_limit_cnt=upper_limit_cnt_4;
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
                % Display most appropriate 0.1 g information:
                Corr_Upper_Limit_cnt=upper_limit_cnt;
                Corr_Upper_Diff=abs(abs(AYCG_CD2(Corr_Upper_Limit_cnt))-0.375);
                Corr_Upper_Percent_Diff=100*(Corr_Upper_Diff)/0.375;
            end
        end

        % Initialize counter and clear arrays of previous data:
        i = 0; clear x y
        for count = Corr_Lower_Limit_cnt:Corr_Upper_Limit_cnt
            i=i+1;
            x(i) = count;
            y(i) = AYCG_CD2(count);
        end

        % Monitor how vehicle speed changes from just before
        % steer initiation to steering plateau (after "re-zeroing"):
        SPD_start = mean(SPCHSF(ZeroBegin:ZeroEnd)); % MES
        SPD_end = mean(SPCHSF(ZeroEnd:upper_limit_cnt_1)); % Mean Speed from ZeroEnd to Ay=0.375g
      
        subplot(2,2,3)
        plot(SPCHSF)
        grid;
        hold on;
        if handstart-StartPt < 1
            StartPt=handstart-1;
        end
        plot((ZeroBegin:ZeroEnd),SPCHSF(ZeroBegin:ZeroEnd),'r','LineWidth',2)      %flag initial mean speed calc interval
        plot(ZeroEnd:upper_limit_cnt_1,SPCHSF(ZeroEnd:upper_limit_cnt_1),'m','LineWidth',2)       %flag final mean speed calc interval
        axis([0 length(SPCHSF) 15 55])
        legend('Vehicle SPD','MES','Mean SPD',3)
        ylabel('Vehicle Speed (mph)')
        xlabel('Count Number')
        clear StartPt
        hold off;

        % PERFORM LINEAR REGRESSION ON acc_work, THE 'LINEAR' PORTION OF THE LAT. ACCEL. DATA:
        %
        x_mean = mean (x);
        y_mean = mean (y);

        slope = sum((x - x_mean) .* (y - y_mean)) ./ (sum((x - x_mean).^2));
        intercept = y_mean - (x_mean .* slope);
        intercept_2 = y_mean - (slope .* x_mean);

        r = sum((x - x_mean) .* (y - y_mean)) ./ (sqrt( sum((x - x_mean).^2) * sum ((y - y_mean).^2)));
        r_squared = r.^2;


        % Calculate the model:
        y_model = (slope .* x) + intercept;
        x_end = x(length(x));	% this just used to know where to put the R^2 note on the plot
        y_end = y_model(length(y_model));


        subplot(2,2,4)
        absAYCG_CD2=abs(AYCG_CD2);
        plot(absAYCG_CD2(handstart:end),absTHETAENCF(handstart:end));  %recall absTHETAENCF = abs(THETAENCF)
        grid
        ylabel('Handwheel Angle (deg)')
        xlabel('ABS Lateral Acceleration (g)')
        
        msgbox('Press any key to continue.', 'modal')
        uiwait;
        
        figure(2)
        set(gcf,'Position',[scrsz(1)*0 scrsz(2)*0 scrsz(3)*0.9 scrsz(4)*0.9]);
        clf
        plot (AYCG_CD2, '-.k');
        hold on;
        grid on;
        line_width = 2;
        H1 = plot (x, y_model, '-r');
        set (H1, 'LineWidth', line_width);
        legend ('actual', 'linear fit')
        fitstring = ['   R^2 = ' num2str(r_squared)];
        text(x_end, y_end, fitstring);
        xlabel('Count Number')
        ylabel('Lateral Acceleration (g)')
        h= title('','Interpreter','none');set(h,'string',['File ',file2process])

        % Note:  try POLYFIT   Fit polynomial to data.
        if DOS == 0
            AYcount_3=round((0.3-intercept)/slope);
            AYcount_5=round((0.5-intercept)/slope);
            AYcount_408=round((0.408-intercept)/slope);
            axis([handstart-round(3/XIncr) handstart+round(6/XIncr) -0.1 0.9])
            hold off;
            figure(1)
            subplot(2,2,1)
            axis([handstart-round(3/XIncr) handstart+round(6/XIncr) -50 300])
            figure(2)
            legend ('actual', 'linear fit',2)
        end

        if DOS == 1
            AYcount_3=round((-0.3-intercept)/slope);
            AYcount_5=round((-0.5-intercept)/slope);
            AYcount_408=round((-0.408-intercept)/slope);
            axis([handstart-round(3/XIncr) handstart+round(6/XIncr) -0.9 0.1])
            hold off
            figure(1)
            subplot(2,2,1)
            axis([handstart-round(3/XIncr) handstart+round(6/XIncr) -300 50])
            figure(2)
            legend ('actual', 'linear fit',3)
        end

        THETAENCF_3=THETAENCF(AYcount_3);   % handwheel angle at 0.3 g, used for Road Edge Recovery and J-Turn steering requirements
        AYCG_CD2_3=AYCG_CD2(AYcount_3);     % actual lateral acceleration at the handwheel angle selected to produce 0.3 g
        RER_Steer65 = 6.5*THETAENCF_3;      % Road Edge Recovery handwheel input
        Jturn_Steer = 8.0*THETAENCF_3;      % J-Turn handwheel input

        THETAENCF_5=THETAENCF(AYcount_5);   % predicted handwheel angle at 0.5 g

        Step_Steer=THETAENCF(AYcount_408);  % handwheel angle at 0.408 g, used for Step Steer handwheel inputs
        AYCG_CD2_StepSteer=AYCG_CD2(AYcount_408);% actual lateral acceleration at the handwheel angle selected to produce 0.408 g

        % Calculate values Steer Times and Fishhook Scalar 5.5:
        SteerTimeRER65=RER_Steer65/720;
        RER_Steer55=THETAENCF_3*5.5;
        SteerTimeRER55=RER_Steer55/720;

        msgbox('Press any key to continue.', 'modal')
        uiwait;
        
         % Add the new line to the output matrix:
        OutputMatrix = [OutputMatrix; filename(RunNumber) {vehicle}...
            handstart DOS,SPD_start,SPD_end,AYcount_3,...
            THETAENCF_3,AYCG_CD2_3,r_squared,ZeroBegin,ZeroEnd];
        
        % Add the values to be averaged to the corresponding sums and increment counter:
        MeanCnt=MeanCnt+1;
        meanTHETAENCF_3=meanTHETAENCF_3+abs(THETAENCF_3);
        meanAYCG_CD2_3=meanAYCG_CD2_3+abs(AYCG_CD2_3);
        meanRER_Steer65=meanRER_Steer65+abs(RER_Steer65);
        meanSteerTimeRER65=meanSteerTimeRER65+abs(SteerTimeRER65);
        meanRER_Steer55=meanRER_Steer55+abs(RER_Steer55);
        meanSteerTimeRER55=meanSteerTimeRER55+abs(SteerTimeRER55);
        meanTHETAENCF_5=meanTHETAENCF_5+abs(THETAENCF_5);
        clear mesg HW_zero_confirm p handstart swr7 trackpt swr swrf StartPt ZeroBegin ZeroEnd EventPt
    end  % End of main counting loop.
if isempty(OutputMatrix)
    msgbox('Output file is Empty, Process Terminated.  Press any key to continue.', 'modal')
    uiwait;
    return
end
    % Average the values summed earlier:
    meanTHETAENCF_3=round((meanTHETAENCF_3/MeanCnt)*10)/10;
    meanAYCG_CD2_3=meanAYCG_CD2_3/MeanCnt;
    meanRER_Steer65=round(meanRER_Steer65/MeanCnt); InitAng65=meanRER_Steer65; ReversalAng65=-1.0*InitAng65;
    meanSteerTimeRER65=meanSteerTimeRER65/MeanCnt; ReversalSteerTime65=2*meanSteerTimeRER65;
    meanRER_Steer55=round(meanRER_Steer55/MeanCnt); InitAng55=meanRER_Steer55; ReversalAng55=-1.0*InitAng55;
    meanSteerTimeRER55=meanSteerTimeRER55/MeanCnt; ReversalSteerTime55=2*meanSteerTimeRER55;
    meanTHETAENCF_5=round(meanTHETAENCF_5/MeanCnt);
    set(handles.File_txt11,'string',['Scalar Processing:   ','Average Steering Angle At 0.3g  =  ',num2str(meanTHETAENCF_3)]);
    % Place the means in the output matrix:
    OutputMatrix = [OutputMatrix; {''} {'Averages'}...
            {''},{''},{''},{''},{''},meanTHETAENCF_3,meanAYCG_CD2_3,{''},{''},{''}];
    [sizerow,sizecol] = size(OutputMatrix);
    OutputMatrix = [OutputMatrix; cell([35,12])];
    if meanTHETAENCF_3<270/6.5
        scalarangles = [1.5*meanTHETAENCF_3:0.5*meanTHETAENCF_3:270 , 270]';
        scalarangles = round(scalarangles);
        scalars = [1.5:0.5:(length(scalarangles))/2+0.5, round(270/meanTHETAENCF_3*10)/10]';
    elseif 270/6.5<meanTHETAENCF_3<300/6.5
        scalarangles = (1.5*meanTHETAENCF_3:0.5*meanTHETAENCF_3:6.5*meanTHETAENCF_3)';
        scalarangles = round(scalarangles);
        scalars = (1.5:0.5:6.5)';
    elseif meanTHETAENCF_3>300/6.5
        scalarangles = [1.5*meanTHETAENCF_3:0.5*meanTHETAENCF_3:300 , 300]';
        scalarangles = round(scalarangles);
        scalars = [1.5:0.5:(length(scalarangles))/2+0.5, round(300/meanTHETAENCF_3*10)/10]';
    end
    OutputMatrix(sizerow+2,2:3) = [{'Scalars'} {'Steering Angles (deg)'}];
    OutputMatrix(sizerow+3:sizerow+2+length(scalars),2:3) = [num2cell(scalars), num2cell(scalarangles)];
    %Create Header Line for output file
    MnemonicsString = {'File';'Vehicle';'EventPt';'DOS';'MES [mph]';'Mean SPD [mph]';...
        'AYcount_3';'THETAENCF_3 [degree]';'AYCG_CD2_3 [g]';'r_squared';'ZeroBegin';'ZeroEnd'}; %...

    strt = char(filename{1});
    stp = char(filename{end});
    OutName=[app.defaultdir '\SIS_Scalars__' deblank(char(vehicle)) '__' strt(1:(end-4)) '-' stp(1:(end-4))];
    OutNameCheck = [OutName '.xls'];
    [FName,PName] = uiputfile('*.xls','Save As',OutName);
    OutName = [PName,FName];
    if ischar(OutName)
        if exist(OutNameCheck)
            XlsMatrixClear = {'-'};
            xlswrite(OutName, XlsMatrixClear);%Erase previous file with the same file name
        end

        XlsMatrix(1,1) = {'NHTSA Compliance Testing:  Slowly Increasing Steer Results - S7D Program Written 1/2007:'}; %Row 1
        XlsMatrix(2,1) = {OutName}; %Row 1
        XlsMatrix(3,1) = {cd}; %Row 2
        XlsMatrix(4,1) = {'Date Created'}; %Row 3
        XlsMatrix(4,3) = {date}; %Row 3
        XlsMatrix(5,1) = {'----------------------------------------------------------------------------------------------'}; %Row 4
        XlsMatrix(9,1) = {'----------------------------------------------------------------------------------------------'}; %Row 9

        % For First Data Matrix
        [x,y] = size(OutputMatrix);
        for i = 1:1:y;
            XlsMatrix(12,i) = MnemonicsString(i,:);%Row 12, Dispays the names of each output variable into columns
            for n = 1:1:x;
                XlsMatrix(12+n,i) = OutputMatrix(n,i);%Creates the columns of output data in excel
            end
        end

        xlswrite(OutName, XlsMatrix); % Saves XlsMatrix to an Excel File
        % Message to Program User That Processing Has Finished
        clear str1
        str1{1} = 'Processing Status';
        str1{2} = 'You Are Finished';
        %         set(handles.text5,'string',char(str1))
        zoom on;
        str{1} = 'SAVED Steering Scalar Table';
        str{2} = ['CONTAINING FILES: ' char(filename{1}) '-' char(filename{end})];
        str{3} = '--------------------------------------------------------------------------';
        str{4} = 'CAUTION:  Make Sure You Have Selected';
        str{5} = 'The Correct Vehicle Parameters!!';
        str{6} = '--------------------------------------------------------------------------';
        msgbox(char(str),'Data Spreadsheet Has Been Saved')
    else
        msgbox('DATA TABLE NOT SAVED','SAVE ERROR')
    end

else
    errordlg('No file selected');
end
clear app filename pathname i str
close(figure(1));
close(figure(2));