function [OutName] = correctVarName(InName)
% Correct vars names to meet MabLab naming conventions
% This is called by DX to mat file conversion program

% replace '-' with '_'
k = strfind(InName, '-');
if ~isempty(k)
    InName(k) = '_';
end

%start with digit 0-9
ch1 = InName(1);
if(ch1 >= 48 & ch1 <= 57)
    InName = ['X', InName];
end

%delete space in the head
if(ch1 == ' ')
    InName(1) = '';
end

% replace ' ' with '_'
k = strfind(InName, ' ');
if ~isempty(k)
    InName(k) = '_';
end

% replace '.' with ''
k = strfind(InName, '.');
if ~isempty(k)
    InName(k) = '';
end


OutName = InName;
