function [outstr, DxInfo] = getDxChnNames(File)
%------------------------------------------------------------
% Get all Channels' names and header info of a DX3 file 
% ourstr - cell string array of channel names
% 
% DxInfo - a struct contains fields:
%                     nChns: number of channels
%     TotalFieldNamesLength: Length of all fields names
%                   nPoints: number of points per channel
%                      year: DAS file data and time
%                       mon: month
%                       day: 
%                      hour: 
%                       min: 
%                       sec: 

% See also: getDxInfo,  LoadDxChannels
%------------------------------------------------------------
fl = which('LoadDxChannels');
[pathstr, name, ext, versn] = fileparts(fl);
hd = [pathstr, '\LoadDxOut.h'];, 
DllLib =[pathstr, '\LoadDx'];
loadlibrary (DllLib, hd); 

if ~libisloaded('LoadDx')
    disp('Failed to load LoadDx DLL !');
    return;
end

%libfunctions LoadDx -full
sm.nChns = 0;
sc = libpointer('DX_INFO1', sm);

calllib('LoadDx', 'get_dx_info', sc,File );
DxInfo = get(sc, 'Value');
clear sc

%make empty str
LenNameStr = DxNum.TotalFieldNamesLength + DxNum.nChns; % includes cammas
nstr = blanks(LenNameStr);%make empty str to hold return name string

[str] = calllib('LoadDx', 'getAllChnNames',nstr, File );

[outstr] = parseCommaStr(str);
unloadlibrary LoadDx
